<?php
add_shortcode('mygo_list_hotel', 'mygo_display_hotels_paginated');
function mygo_display_hotels_paginated() {
    ob_start();
    $login = get_option('mygo_login');
    $password = get_option('mygo_password');
    $selected_city = isset($_GET['city']) ? intval($_GET['city']) : 0;
    $selected_cat = isset($_GET['cat']) ? intval($_GET['cat']) : 0;
    $page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
    $limit = 9;
    $offset = ($page - 1) * $limit;

    $cities = [];
    $city_response = wp_remote_post('https://admin.mygo.co/api/hotel/ListCity', [
        'body' => json_encode(['Credential' => ['Login' => $login, 'Password' => $password]]),
        'headers' => ['Content-Type' => 'application/json'],
    ]);
    $city_data = json_decode(wp_remote_retrieve_body($city_response), true);
    if (isset($city_data['ListCity'])) $cities = $city_data['ListCity'];

    $cats = [];
    $cat_response = wp_remote_post('https://admin.mygo.co/api/hotel/ListCategorie', [
        'body' => json_encode(['Credential' => ['Login' => $login, 'Password' => $password]]),
        'headers' => ['Content-Type' => 'application/json'],
    ]);
    $cat_data = json_decode(wp_remote_retrieve_body($cat_response), true);
    if (isset($cat_data['ListCategorie'])) $cats = $cat_data['ListCategorie'];

    echo '<form method="get"><label>Ville : <select name="city">';
    echo '<option value="">-- Sélectionner une ville --</option>';
    foreach ($cities as $city) {
        $selected = selected($selected_city, $city['Id'], false);
        echo "<option value='{$city['Id']}' $selected>{$city['Name']}</option>";
    }
    echo '</select></label> ';
    echo '<label>Catégorie : <select name="cat">';
    echo '<option value="">-- Toutes les catégories --</option>';
    foreach ($cats as $cat) {
        $selected = selected($selected_cat, $cat['Id'], false);
        echo "<option value='{$cat['Id']}' $selected>{$cat['Title']}</option>";
    }
    echo '</select></label> <button type="submit">Rechercher</button></form>';

    if (!$selected_city) return ob_get_clean() . "<p>Veuillez sélectionner une ville.</p>";
    $list_response = wp_remote_post('https://admin.mygo.co/api/hotel/ListHotel', [
        'body' => json_encode(['Credential' => ['Login' => $login, 'Password' => $password], 'City' => $selected_city]),
        'headers' => ['Content-Type' => 'application/json'],
    ]);
    $list_data = json_decode(wp_remote_retrieve_body($list_response), true);
    $hotels = $list_data['ListHotel'] ?? [];
    if (empty($hotels)) return ob_get_clean() . "<p>Aucun hôtel trouvé.</p>";
    $filtered = array_filter($hotels, function($h) use ($selected_cat) {
        return !$selected_cat || $h['Category']['Id'] == $selected_cat;
    });
    $paged_hotels = array_slice(array_values($filtered), $offset, $limit);
    $total_pages = ceil(count($filtered) / $limit);

    echo '<div class="hotel-list" style="display:grid;grid-template-columns:repeat(3,1fr);gap:20px;">';
    foreach ($paged_hotels as $hotel) {
        echo '<div class="mygo-hotel-card">';
        echo '<img src="' . esc_url($hotel['Image']) . '" alt="' . esc_attr($hotel['Name']) . '" />';
        echo '<div class="mygo-hotel-card-content">';
        echo '<h3>' . esc_html($hotel['Name']) . '</h3>';
        echo '<div class="location">' . esc_html($hotel['City']['Name']) . ' - ' . esc_html($hotel['Category']['Title']) . '</div>';
        echo '<div class="price">À partir de <strong>-- TND</strong></div>';
        echo '<a href="' . esc_url(site_url('/hotel/?id=' . $hotel['Id'])) . '" class="btn-book">Réserver</a>';
        echo '</div></div>';
    }
    echo '</div>';
    if ($total_pages > 1) {
        echo '<div class="pagination" style="margin-top:20px;text-align:center;">';
        if ($page > 1) echo '<a href="' . esc_url(add_query_arg('paged', $page - 1)) . '">← Précédent</a> ';
        echo " Page $page / $total_pages ";
        if ($page < $total_pages) echo ' <a href="' . esc_url(add_query_arg('paged', $page + 1)) . '">Suivant →</a>';
        echo '</div>';
    }
    return ob_get_clean();
}
?>