if (typeof payments !== 'undefined') {
    const gateway_change = function() {
		const change_gate = jQuery('[name=wp_travel_payment_gateway]:checked').val();

		if ( 'authorizenet' == change_gate ) {
            document.getElementById("wpTravelAuthorizeNetPayment").setAttribute("name", "formAuthorizeNetPopup");
            document.getElementById("wpTravelAuthorizeNetPayment").setAttribute("id", "formAuthorizeNetPopup");
            var authorizenetVars = wp_travel_authorizenet_vars, // Authorizent Vars
            authorizeBtn = jQuery('#wp-travel-authorizenet');

            if (!window.AuthorizeNetPopup) window.AuthorizeNetPopup = {};
            if (!AuthorizeNetPopup.options) AuthorizeNetPopup.options = {
                onPopupClosed: null
                };

            AuthorizeNetPopup.closePopup = function (disabled) {
                toggledisabled(authorizeBtn, disabled);
                document.getElementById("divAuthorizeNetPopupScreen").style.display = "none";
                document.getElementById("divAuthorizeNetPopup").style.display = "none";
                document.getElementById("iframeAuthorizeNet").src = authorizenetVars.iframeUrl;
                if (AuthorizeNetPopup.options.onPopupClosed) AuthorizeNetPopup.options.onPopupClosed();
            };

            AuthorizeNetPopup.openPopup = function (token) {
                var popup = document.getElementById("divAuthorizeNetPopup");
                var popupScreen = document.getElementById("divAuthorizeNetPopupScreen");
                var ifrm = document.getElementById("iframeAuthorizeNet");
                var form = document.forms["formAuthorizeNetPopup"];
                jQuery("#popupToken").val(token);
                ifrm.style.width = "442px";
                ifrm.style.height = "578px";

                form.submit();

                popup.style.display = "";
                popupScreen.style.display = "";
                centerPopup();
            };

            AuthorizeNetPopup.onReceiveCommunication = function (querystr) {
                var params = parseQueryString(querystr);
                switch (params["action"]) {
                    case "successfulSave":
                        AuthorizeNetPopup.closePopup(true);
                        break;
                    case "cancel":
                        AuthorizeNetPopup.closePopup(false);
                        break;
                    case "transactResponse":
                        var response = params["response"];
                        jQuery("[name=payment_details]").remove();
                        var form = jQuery("form#wp-travel-booking").length > 0 ? '#wp-travel-booking' : '#wp-travel-partial-payment';
                        var $form = jQuery(form);
                        if($form.length >  0) {
                            $form.append(jQuery("<input type='hidden' name='payment_details' />")
                            .attr("value", JSON.stringify(response)))
                            if( form == '#wp-travel-booking' ) {
                                $form.find("input[type=submit]")
                                .click();
                            } else {
                                $form.append("<input type='hidden' name='complete_partial_payment' />")
                                $form.submit();
                            }
                        }

                        AuthorizeNetPopup.closePopup(true);
                        break;
                    case "resizeWindow":
                        var w = parseInt(params["width"]);
                        var h = parseInt(params["height"]);
                        var ifrm = document.getElementById("iframeAuthorizeNet");
                        ifrm.style.width = w.toString() + "px";
                        ifrm.style.height = h.toString() + "px";
                        centerPopup();
                        break;
                }
            };

            function centerPopup() {
                var d = document.getElementById("divAuthorizeNetPopup");
                d.style.left = "50%";
                d.style.top = "50%";
                var left = -Math.floor(d.clientWidth / 2);
                var top = -Math.floor(d.clientHeight / 2);
                d.style.marginLeft = left.toString() + "px";
                d.style.marginTop = top.toString() + "px";
                d.style.zIndex = "9999";

                if (d.offsetTop < 16) {
                    d.style.top = "16px";
                    d.style.marginTop = "0px";
                }
            }

            function parseQueryString(str) {
                var vars = [];
                var arr = str.split('&');
                var pair;
                for (var i = 0; i < arr.length; i++) {
                    pair = arr[i].split('=');
                    vars.push(pair[0]);
                    vars[pair[0]] = unescape(pair[1]);
                }
                return vars;
            }

            function toggledisabled(el, disabled){
                el.prop('disabled', disabled);
                if(disabled) el.css('cursor', 'not-allowed')
                else el.css('cursor', 'pointer')
                return el;
            }

            var bookingForm = jQuery("#wp-travel-booking");
            bookingFormParsleyObject = 0 < bookingForm.length && bookingForm.parsley();

            jQuery('#wp-travel-booking .button-field').append('<button type="submit" name="wp_travel_authorizenet" id="wp-travel-authorizenet" style="display: none;">Pay via Authorize.net</button>');
            var authorizeBtn = jQuery('#wp-travel-authorizenet');
            "authorizenet" == jQuery("[name=wp_travel_payment_gateway]:checked").val() && authorizeBtn.show().siblings().hide();

            jQuery(document).on("change keyup", "form#wp-travel-booking", function() {
                "authorizenet" == jQuery("[name=wp_travel_payment_gateway]:checked").val() && 'booking_with_payment' === jQuery('#wp-travel-option').val() && authorizeBtn.show().siblings().hide() || authorizeBtn.hide();
            });

            jQuery(document).on('click', '#wp-travel-complete-partial-payment', function(e){
                if( ! jQuery('#wp-travel-payment-authorizenet').is(':checked') ) {
                    return;
                }
                e.preventDefault();
                var $this = jQuery(this);
                $this.after("<i style='margin-top:12px; margin-left:10px;' class='fa-validated-now fa fa-spin fa-spinner'></i>");

                if ( typeof wp_travel != 'undefined' && typeof wp_travel.inventory != 'undefined' && wp_travel.inventory == 'yes' ) {
                    fetch( wp_travel.ajaxUrl + '?action=inventory_testing'+ wp_travel._nonce, {
                        method : 'POST',
                        headers : { 'Content-Type': 'application/json' },
                        body : JSON.stringify({ wp_travel_trip : typeof wp_travel.items != 'undefined' && wp_travel.items || Array(), nonce :  wp_travel.nonce } )
                    } ).then( function ( resp ) { 
                        resp.json().then( responces => {
                            if ( responces.success == true ) {
                                if ( typeof responces.data != 'undefined' && typeof responces.data.code != 'undefined' && typeof responces.data.inventory_available != 'undefined' && responces.data.code == "WP_TRAVEL_INVENTORY_TESTING" && responces.data.inventory_available == 'no_pax' ) {
                                    if ( confirm( 'Pax already booked') ) {
                                        fetch( wp_travel.ajaxUrl + '?action=wp_travel_use_inventory_empty_cart'+ wp_travel._nonce, {
                                            method : 'POST',
                                            headers : { 'Content-Type' : 'application/json' },
                                            body : JSON.stringify( { wp_travel_empty_cart : typeof wp_travel.items != 'undefined' && wp_travel.items || Array() } ),
                                        } ).then( results => results.json().then( resu => { location.reload();} ) ) ;
                                    }
                                } else {        
                                    jQuery.ajax({
                                        method : 'post',
                                        url : wp_travel.ajaxUrl,
                                        data : {
                                        action : 'wp_travel_authorize_net',
                                        formData : jQuery('#wp-travel-partial-payment').serialize(),
                                        authorizenetVars : authorizenetVars,
                                        amount: jQuery('#wp-travel-amount').val(),
                                        },
                                        success : function( res ) {
                                            if( res.success ){
                                                toggledisabled($this, true).next('.fa-validated-now').remove();
                                                AuthorizeNetPopup.openPopup(res.data.token);
                                                return;
                                            }else{
                                                console.log(res);
                                    
                                                toggledisabled($this, false).next('.fa-validated-now').remove();
                                                alert('Unable to proceed payment process.');
                                            }
                                        }
                                    })
                                }

                            } 
                        })
                                    
                    })
                } else {
                    jQuery.ajax({
                        method : 'post',
                        url : wp_travel.ajaxUrl,
                        data : {
                        action : 'wp_travel_authorize_net',
                        formData : jQuery('#wp-travel-partial-payment').serialize(),
                        authorizenetVars : authorizenetVars,
                        amount: jQuery('#wp-travel-amount').val(),
                        },
                        success : function( res ) {
                            if( res.success ){
                                toggledisabled($this, true).next('.fa-validated-now').remove();
                                AuthorizeNetPopup.openPopup(res.data.token);
                                return;
                            }else{
                                console.log(res);
                    
                                toggledisabled($this, false).next('.fa-validated-now').remove();
                                alert('Unable to proceed payment process.');
                            }
                        }
                    })
                }
            });
            jQuery(document).on('click', '#wp-travel-authorizenet', function(e){
                e.preventDefault();
                var $this = jQuery(this);
                if( ! bookingFormParsleyObject.validate() ){
                    return;
                };
                $this.after("<i style='margin-top:12px; margin-left:10px;' class='fa-validated-now fa fa-spin fa-spinner'></i>");
                toggledisabled($this, true);
                if ( typeof wp_travel != 'undefined' && typeof wp_travel.inventory != 'undefined' && wp_travel.inventory == 'yes' ) {
                    fetch( wp_travel.ajaxUrl + '?action=inventory_testing'+ wp_travel._nonce, {
                        method : 'POST',
                        headers : { 'Content-Type': 'application/json' },
                        body : JSON.stringify({ wp_travel_trip : typeof wp_travel.items != 'undefined' && wp_travel.items || Array(), nonce :  wp_travel.nonce } )
                    } ).then( function ( resp ) { 
                        resp.json().then( responces => {
                            if ( responces.success == true ) {
                                if ( typeof responces.data != 'undefined' && typeof responces.data.code != 'undefined' && typeof responces.data.inventory_available != 'undefined' && responces.data.code == "WP_TRAVEL_INVENTORY_TESTING" && responces.data.inventory_available == 'no_pax' ) {
                                    if ( confirm( 'Pax already booked') ) {
                                        fetch( wp_travel.ajaxUrl + '?action=wp_travel_use_inventory_empty_cart'+ wp_travel._nonce, {
                                            method : 'POST',
                                            headers : { 'Content-Type' : 'application/json' },
                                            body : JSON.stringify( { wp_travel_empty_cart : typeof wp_travel.items != 'undefined' && wp_travel.items || Array() } ),
                                        } ).then( results => results.json().then( resu => { location.reload();} ) ) ;
                                    }
                                } else {
                                                
                                    jQuery.ajax({
                                        method : 'post',
                                        url : wp_travel.ajaxUrl,
                                        data : {
                                            action : 'wp_travel_authorize_net',
                                            formData : jQuery('#wp-travel-booking').serialize(),
                                            authorizenetVars : authorizenetVars,
                                            amount: "partial" == jQuery("#wp-travel-payment-mode option:selected").val() ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price,
                                        },
                                        success : function( res ) {
                                            if( res.success ){
                                                toggledisabled($this, true).next('.fa-validated-now').remove();
                                                AuthorizeNetPopup.openPopup(res.data.token);
                                                return;
                                            }else{
                                                console.log(res);
                                                toggledisabled($this, false).next('.fa-validated-now').remove();
                                                alert('Unable to proceed payment process.');
                                            }
                                        }
                                    })
                                }

                            } 
                        })
                                    
                    })
                } else {
                    jQuery.ajax({
                        method : 'post',
                        url : wp_travel.ajaxUrl,
                        data : {
                            action : 'wp_travel_authorize_net',
                            formData : jQuery('#wp-travel-booking').serialize(),
                            authorizenetVars : authorizenetVars,
                            amount: "partial" == jQuery("#wp-travel-payment-mode option:selected").val() ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price,
                        },
                        success : function( res ) {
                            if( res.success ){
                                toggledisabled($this, true).next('.fa-validated-now').remove();
                                AuthorizeNetPopup.openPopup(res.data.token);
                                return;
                            }else{
                                console.log(res);
                                toggledisabled($this, false).next('.fa-validated-now').remove();
                                alert('Unable to proceed payment process.');
                            }
                        }
                    })
                }
            });
        } else {
            document.getElementById('formAuthorizeNetPopup').setAttribute("name", "wpTravelAuthorizeNetPayment");
            document.getElementById("formAuthorizeNetPopup").setAttribute("id", "wpTravelAuthorizeNetPayment");
	    }
	}
    jQuery(function($){
		document.getElementById("formAuthorizeNetPopup").setAttribute("name", "wpTravelAuthorizeNetPayment");
		document.getElementById("formAuthorizeNetPopup").setAttribute("id", "wpTravelAuthorizeNetPayment");
		gateway_change();
        $('[name=wp_travel_payment_gateway]').change(gateway_change); 
    });
}