jQuery(function($) {
    var messages = authorizenet_vars.messages;


    $('#currency, #wt_test_mode, #wp_travel_authorizenet_api_login_id, #wp_travel_authorizenet_transaction_key')
    .on('keyup, change', function(){
        $('#validAuthorizeMerchantAccount, #accountValidationResult').show();
    })

    $('#currency, #wt_test_mode').on('change', function(){
        $('input[name="wp_travel_authorizenet_valid_currency"]').val('no');
    });

    $('#validAuthorizeMerchantAccount').click(function(e){
        e.preventDefault();
        $this = $(this);
        $this.next().show();
        var apiUrl = document.getElementById('wt_test_mode').checked ? 'https://apitest.authorize.net/xml/v1/request.api' : 'https://api.authorize.net/xml/v1/request.api';

        $.ajax({
            method : 'post',
            url: authorizenet_vars.ajaxUrl,
            data : {
                'action' : 'wp_travel_currency_verification'
            },
            success : function(res){
                $this.next().hide();
    
                if(res.success){
                    if('-1' == res.data.currencies.indexOf($('#currency').val())){
                        $('#accountValidationResult').text(messages.currency_acceptance + res.data.currencies.toString()).css('color','#dc3232');
                        $('input[name="wp_travel_authorizenet_valid_currency"]').val('no');
                        return;
                    };
                    $('input[name="wp_travel_authorizenet_valid_currency"]').val('yes');
                    $('#accountValidationResult').text(messages.currency_validation_successful).show().css('color', 'green');
                }else{
                    $('#accountValidationResult').text(messages.account_validation_failed).css('color','#dc3232').show();
                    $('input[name="wp_travel_authorizenet_valid_currency"]').val('no');
                }
            }
        })
    });
});
