<?php
/**
 * Setting page template for the plugin.
 *
 * @package WP_Travel_Authorize_Net_Checkout
 */
?>
<?php
$payment_option_authorizenet = isset( $args['settings']['payment_option_authorizenet'] ) ? $args['settings']['payment_option_authorizenet'] : '';
$login_id        = isset( $args['settings']['wp_travel_authorizenet_api_login_id'] ) ? $args['settings']['wp_travel_authorizenet_api_login_id'] : '';
$transaction_key = isset( $args['settings']['wp_travel_authorizenet_transaction_key'] ) ? $args['settings']['wp_travel_authorizenet_transaction_key'] : '';
$is_validate     = isset( $args['settings']['wp_travel_authorizenet_valid_currency'] ) ? $args['settings']['wp_travel_authorizenet_valid_currency'] : 'no';
$show            = '';
if ( '' === $payment_option_authorizenet ) {
	$show = 'display:none';
}
?>

<table class="form-table">
	<tr>
		<th>
			<label for="payment_option_authorizenet">
				<?php esc_html_e( 'Enable', 'wp-travel-pro' ); ?></label>
		</th>
		<td>
			<label for="payment_option_authorizenet">
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input class="enable-payment-gateway payment_option_authorizenet" value="yes" <?php checked( $payment_option_authorizenet, 'yes' ); ?> type="checkbox" name="payment_option_authorizenet" id="payment_option_authorizenet">
						<span class="switch"></span>
					</label>
				</span>
				<p class="description"><?php esc_html_e( 'Check to enable Authorize.Net Checkout.', 'wp-travel-pro' ) ?></p>

			</label>
		</td>
	</tr>
	<tbody class="payment-gateway-fields">
	<tr>
		<th>
			<label for="wp_travel_authorizenet_api_login_id">
				<?php esc_html_e( 'Login ID', 'wp-travel-pro' ); ?></label>
				<p class="description">
					<?php
					echo sprintf( __( 'Get api credentials %s here. %s', 'wp-travel-pro' ), '<a href="https://www.authorize.net/sign-up/" target="_blank">', '</a>' );
					?>
				</p>
		</th>
		<td>
			<input type="text" name="wp_travel_authorizenet_api_login_id" id="wp_travel_authorizenet_api_login_id"
				value="<?php echo esc_attr( $login_id ); ?>">
		</td>
	</tr>
	<tr>
		<th>
			<label for="wp_travel_authorizenet_transaction_key">
				<?php esc_html_e( 'Transaction Key', 'wp-travel-pro' ); ?></label>
		</th>
		<td>
			<input type="text" name="wp_travel_authorizenet_transaction_key" id="wp_travel_authorizenet_transaction_key"
				value="<?php echo esc_attr( $transaction_key ); ?>">
		</td>
	</tr>
	<tr>
		<th></th>
		<td>
			<input type="hidden" id="wp_travel_authorizenet_valid_currency" name="wp_travel_authorizenet_valid_currency" value="<?php echo esc_attr( $is_validate ); ?>">
			<?php $show = 'yes' === $is_validate ? 'display: none' : ''; ?>
			<p id="accountValidationResult" style="color:#ffb900;<?php echo $show; ?>"><?php _e( "The store currency and Merchant account currency should be the same.<br>Please validate first to enable the payment gateway.", 'wp-travel-pro' ); ?></p>
			<button id="validAuthorizeMerchantAccount" class="button button-primary" style="<?php echo $show; ?>"><?php esc_html_e( 'Validate Account and Currency.', 'wp-travel-pro' ); ?></button>
			<i style='margin-top:7px;margin-left:10px;display:none;' class='fa-validated-now fa fa-spin fa-spinner'></i>
		</td>
	</tr>
	</tbody>
</table>
