<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * ==================================================================================================
 * Function to create array of countries name according to currency code.
 * Currently it only supports 167 currencies.
 *
 * @return array $currencies_name It returns the names of the currencies according to currency code.
 * ==================================================================================================
 */
function wp_travel_currency_exchange_rates_currencies_name() {
	$currencies_name = array(
		'AED' => 'United Arab Emirates Dirham',
		'AFN' => 'Afghan Afghani',
		'ALL' => 'Albanian Lek',
		'AMD' => 'Armenian Dram',
		'ANG' => 'Netherlands Antillean Guilder',
		'AOA' => 'Angolan Kwanza',
		'ARS' => 'Argentine Peso',
		'AUD' => 'Australian Dollar',
		'AWG' => 'Aruban Florin',
		'AZN' => 'Azerbaijani Manat',
		'BAM' => 'Bosnia-Herzegovina Convertible Mark',
		'BBD' => 'Barbadian Dollar',
		'BDT' => 'Bangladeshi Taka',
		'BGN' => 'Bulgarian Lev',
		'BHD' => 'Bahraini Dinar',
		'BIF' => 'Burundian Franc',
		'BMD' => 'Bermudan Dollar',
		'BND' => 'Brunei Dollar',
		'BOB' => 'Bolivian Boliviano',
		'BRL' => 'Brazilian Real',
		'BSD' => 'Bahamian Dollar',
		'BTC' => 'Bitcoin',
		'BTN' => 'Bhutanese Ngultrum',
		'BWP' => 'Botswanan Pula',
		'BYR' => 'Belarusian Ruble',
		'BYN' => 'New Belarusian Ruble',
		'BZD' => 'Belize Dollar',
		'CAD' => 'Canadian Dollar',
		'CDF' => 'Congolese Franc',
		'CHF' => 'Swiss Franc',
		'CLF' => 'Chilean Unit of Account (UF)',
		'CLP' => 'Chilean Peso',
		'CNY' => 'Chinese Yuan',
		'COP' => 'Colombian Peso',
		'CRC' => 'Costa Rican Colón',
		'CUC' => 'Cuban Convertible Peso',
		'CUP' => 'Cuban Peso',
		'CVE' => 'Cape Verdean Escudo',
		'CZK' => 'Czech Republic Koruna',
		'DJF' => 'Djiboutian Franc',
		'DKK' => 'Danish Krone',
		'DOP' => 'Dominican Peso',
		'DZD' => 'Algerian Dinar',
		'EGP' => 'Egyptian Pound',
		'ERN' => 'Eritrean Nakfa',
		'ETB' => 'Ethiopian Birr',
		'EUR' => 'Euro',
		'FJD' => 'Fijian Dollar',
		'FKP' => 'Falkland Islands Pound',
		'GBP' => 'British Pound Sterling',
		'GEL' => 'Georgian Lari',
		'GGP' => 'Guernsey Pound',
		'GHS' => 'Ghanaian Cedi',
		'GIP' => 'Gibraltar Pound',
		'GMD' => 'Gambian Dalasi',
		'GNF' => 'Guinean Franc',
		'GTQ' => 'Guatemalan Quetzal',
		'GYD' => 'Guyanaese Dollar',
		'HKD' => 'Hong Kong Dollar',
		'HNL' => 'Honduran Lempira',
		'HRK' => 'Croatian Kuna',
		'HTG' => 'Haitian Gourde',
		'HUF' => 'Hungarian Forint',
		'IDR' => 'Indonesian Rupiah',
		'ILS' => 'Israeli New Sheqel',
		'IMP' => 'Manx pound',
		'INR' => 'Indian Rupee',
		'IQD' => 'Iraqi Dinar',
		'IRR' => 'Iranian Rial',
		'ISK' => 'Icelandic Króna',
		'JEP' => 'Jersey Pound',
		'JMD' => 'Jamaican Dollar',
		'JOD' => 'Jordanian Dinar',
		'JPY' => 'Japanese Yen',
		'KES' => 'Kenyan Shilling',
		'KGS' => 'Kyrgystani Som',
		'KHR' => 'Cambodian Riel',
		'KMF' => 'Comorian Franc',
		'KPW' => 'North Korean Won',
		'KRW' => 'South Korean Won',
		'KWD' => 'Kuwaiti Dinar',
		'KYD' => 'Cayman Islands Dollar',
		'KZT' => 'Kazakhstani Tenge',
		'LAK' => 'Laotian Kip',
		'LBP' => 'Lebanese Pound',
		'LKR' => 'Sri Lankan Rupee',
		'LRD' => 'Liberian Dollar',
		'LSL' => 'Lesotho Loti',
		'LTL' => 'Lithuanian Litas',
		'LVL' => 'Latvian Lats',
		'LYD' => 'Libyan Dinar',
		'MAD' => 'Moroccan Dirham',
		'MDL' => 'Moldovan Leu',
		'MGA' => 'Malagasy Ariary',
		'MKD' => 'Macedonian Denar',
		'MMK' => 'Myanma Kyat',
		'MNT' => 'Mongolian Tugrik',
		'MOP' => 'Macanese Pataca',
		'MRO' => 'Mauritanian Ouguiya',
		'MUR' => 'Mauritian Rupee',
		'MVR' => 'Maldivian Rufiyaa',
		'MWK' => 'Malawian Kwacha',
		'MXN' => 'Mexican Peso',
		'MYR' => 'Malaysian Ringgit',
		'MZN' => 'Mozambican Metical',
		'NAD' => 'Namibian Dollar',
		'NGN' => 'Nigerian Naira',
		'NIO' => 'Nicaraguan Córdoba',
		'NOK' => 'Norwegian Krone',
		'NPR' => 'Nepalese Rupee',
		'NZD' => 'New Zealand Dollar',
		'OMR' => 'Omani Rial',
		'PAB' => 'Panamanian Balboa',
		'PEN' => 'Peruvian Nuevo Sol',
		'PGK' => 'Papua New Guinean Kina',
		'PHP' => 'Philippine Peso',
		'PKR' => 'Pakistani Rupee',
		'PLN' => 'Polish Zloty',
		'PYG' => 'Paraguayan Guarani',
		'QAR' => 'Qatari Rial',
		'RON' => 'Romanian Leu',
		'RSD' => 'Serbian Dinar',
		'RUB' => 'Russian Ruble',
		'RWF' => 'Rwandan Franc',
		'SAR' => 'Saudi Riyal',
		'SBD' => 'Solomon Islands Dollar',
		'SCR' => 'Seychellois Rupee',
		'SDG' => 'Sudanese Pound',
		'SEK' => 'Swedish Krona',
		'SGD' => 'Singapore Dollar',
		'SHP' => 'Saint Helena Pound',
		'SLL' => 'Sierra Leonean Leone',
		'SOS' => 'Somali Shilling',
		'SRD' => 'Surinamese Dollar',
		'STD' => 'São Tomé and Príncipe Dobra',
		'SVC' => 'Salvadoran Colón',
		'SYP' => 'Syrian Pound',
		'SZL' => 'Swazi Lilangeni',
		'THB' => 'Thai Baht',
		'TJS' => 'Tajikistani Somoni',
		'TMT' => 'Turkmenistani Manat',
		'TND' => 'Tunisian Dinar',
		'TOP' => 'Tongan Paʻanga',
		'TRY' => 'Turkish Lira',
		'TTD' => 'Trinidad and Tobago Dollar',
		'TWD' => 'New Taiwan Dollar',
		'TZS' => 'Tanzanian Shilling',
		'UAH' => 'Ukrainian Hryvnia',
		'UGX' => 'Ugandan Shilling',
		'USD' => 'United States Dollar',
		'UYU' => 'Uruguayan Peso',
		'UZS' => 'Uzbekistan Som',
		'VEF' => 'Venezuelan Bolívar Fuerte',
		'VND' => 'Vietnamese Dong',
		'VUV' => 'Vanuatu Vatu',
		'WST' => 'Samoan Tala',
		'XAF' => 'CFA Franc BEAC',
		'XAG' => 'Silver (troy ounce)',
		'XAU' => 'Gold (troy ounce)',
		'XCD' => 'East Caribbean Dollar',
		'XDR' => 'Special Drawing Rights',
		'XOF' => 'CFA Franc BCEAO',
		'XPF' => 'CFP Franc',
		'YER' => 'Yemeni Rial',
		'ZAR' => 'South African Rand',
		'ZMK' => 'Zambian Kwacha (pre-2013)',
		'ZMW' => 'Zambian Kwacha',
		'ZWL' => 'Zimbabwean Dollar',
	);

	return $currencies_name;
}

/**
 * ===============================================
 * API function to save the API data to transient.
 *
 * @return void
 * ===============================================
 */
function wp_travel_currency_exchange_rates_api() {
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$api_key               = ! empty( $settings['exchange_rate_api_key'] ) ? $settings['exchange_rate_api_key'] : '';
	$api_reset_time        = ! empty( $settings['set_api_timer_reset'] ) ? $settings['set_api_timer_reset'] : 24; // In hours.
	$is_premium            = ! empty( $settings['exchange_rate_api_key_premium_checkbox'] ) ? $settings['exchange_rate_api_key_premium_checkbox'] : 24; // In hours.
	$transient_reset_timer = ( $api_reset_time * 60 ) * 60; // Convert into seconds ( 1 hours = 3600 sec ).
	$transient_api_data    = get_transient( 'wp_travel_currency_exchange_rates_cached_api_data' );
	$api_key               = ! empty( $api_key ) ? $api_key : '';
	$is_premium_api        = ! empty( $is_premium ) ? $is_premium : 'no';
	if ( empty( $api_key ) ) {
		return;
	}

	$use_api_layer_fixer_api = isset( $settings['use_api_layer_fixer_api'] ) && 'yes' === $settings['use_api_layer_fixer_api'];
	$is_premium_api          = isset( $settings['exchange_rate_api_key_premium_checkbox'] ) && 'yes' === $settings['exchange_rate_api_key_premium_checkbox'];

	$api_protocal = 'http://';
	if ( $is_premium_api ) {
		$api_protocal = 'https://';
	}

	$api_url = $api_protocal . 'data.fixer.io/api/latest?access_key=' . $api_key . '&format=1';
	if ( $use_api_layer_fixer_api ) {
		$api_url = $api_protocal . 'api.apilayer.com/fixer/latest?apikey=' . $api_key . '&format=1';
	}

	$api_link_data = curl_init( $api_url );
	curl_setopt( $api_link_data, CURLOPT_RETURNTRANSFER, true );
	$json = curl_exec( $api_link_data );
	curl_close( $api_link_data );
	$api_data = json_decode( $json, true );

	$api_data = ! empty( $api_data ) ? $api_data : '';

	// Set api data to transient.
	if ( false === $transient_api_data ) {
		// Run this if no transient is set.
		$transient_api_data = $api_data;
		set_transient( 'wp_travel_currency_exchange_rates_cached_api_data', $transient_api_data, $transient_reset_timer );
	}

}

/**
 * ==========================================================================================================================
 * Function which will be used for all the templates instead of real time api data.
 *
 * @param  array $selected_currencies Selected currencies or entered currencies code from widgets or as shortcode attributes.
 * @return array $transient_api_data  API data saved in transient.
 * ==========================================================================================================================
 */
function wp_travel_currency_exchange_rates_transient_api_data( $selected_currencies ) {
	$transient_api_data  = get_transient( 'wp_travel_currency_exchange_rates_cached_api_data' );
	$selected_currencies = ! empty( $selected_currencies ) ? $selected_currencies : array( 'display_all_rates' );

	// If transient is empty or not set, call the API function to set the API data in transient.
	if ( false === $transient_api_data ) {
		wp_travel_currency_exchange_rates_api();
	}

	if ( ! empty( $transient_api_data ) && is_array( $transient_api_data ) && is_array( $selected_currencies ) && count( $transient_api_data ) > 0 ) {
		if ( ! is_admin() ) {
			if ( is_array( $selected_currencies ) && isset( $selected_currencies[0] ) && 'display_all_rates' === $selected_currencies[0] ) {
				return $transient_api_data;
			}
			$return_currency = array();
			foreach ( $transient_api_data['rates'] as $currency_codes => $rates ) {
				if ( in_array( $currency_codes, $selected_currencies ) ) {
					$return_currency[ $currency_codes ] = $rates;
				}
			}
			$transient_api_data['rates'] = $return_currency;
		}
		return $transient_api_data;
	}
}

/**
 * ==================================
 * This function purge the transient.
 * ==================================
 */
function wp_travel_currency_exchange_rates_templates_delete_transient() {
	delete_transient( 'wp_travel_currency_exchange_rates_cached_api_data' );

	// Added for v4 settings.
	if ( wp_doing_ajax() ) {
		wp_send_json_success( 'Purged Success.' );
	}
}
