<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * =====================================================
 * Create Shortcode for WP Travel Currency Exchange Rate.
 *
 * Shortcode [wp_travel_currency_exchange_rates]
 * Shortcode with parameter [wp_travel_currency_exchange_rates currency_code="__CURRENCY_CODE(S)__"]
 * Currency code: USD,NPR,AED etc...
 * =====================================================
 */
function wp_travel_currency_exchange_rates_shortcode( $atts = array(), $content = null, $tag = '' ) {
	$shortcode_atts['selected_currencies'] = array();
	$shortcode_contents                    = '';
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$api_key = ! empty( $settings['exchange_rate_api_key'] ) ? $settings['exchange_rate_api_key'] : '';

	// Normalize attribute keys, lowercase.
	$atts = array_change_key_case( (array) $atts, CASE_LOWER );

	// Override default attributes with user attributes.
	$shortcode_atts = shortcode_atts(
		array(
			'title'               => __( 'Exchange Rates', 'wp-travel-pro' ),
			'selected_currencies' => '', // Display currency/currencies selected by user, display all if empty.
		),
		$atts,
		$tag
	);

	if ( is_string( $shortcode_atts['selected_currencies'] ) && ! empty( $shortcode_atts['selected_currencies'] ) ) {
		$string_to_array                       = explode( ',', $shortcode_atts['selected_currencies'] );
		$shortcode_atts['selected_currencies'] = $string_to_array;
	}

	if ( ! empty( $api_key ) ) {
		$shortcode_contents .= '<div class="div_wp_travel_currency_exchange_rates_shortcode">';
		$shortcode_contents .= '<h2>' . esc_html( $shortcode_atts['title'] ) . '</h2>';
		$shortcode_contents .= wp_travel_currency_exchange_rates_frontend_templates( $shortcode_atts['selected_currencies'] );
		$shortcode_contents .= '</div>';
		$shortcode_contents  = ! empty( $shortcode_contents ) ? $shortcode_contents : '';
		return $shortcode_contents;
	}

}
add_shortcode( 'wp_travel_currency_exchange_rates', 'wp_travel_currency_exchange_rates_shortcode' );
