<?php
/**
 * Modules core file.
 *
 * @package wp-travel-custom-filters-core
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// WP Travel Custom Filters Core.
if ( ! class_exists( 'WP_Travel_Custom_Filters_Core' ) ) :
	/**
	 * WP Travel Custom Filters Core.
	 */
	class WP_Travel_Custom_Filters_Core {

		protected static $abspath;

		protected static $plugin_file;

		protected static $version;

		/**
		 * The object of WP_Travel_Filters
		 *
		 * @since 1.0.0
		 * @var object
		 */
		public static $filter;

		/**
		 * The single instance of the class.
		 *
		 * @var WP Custom Filter
		 * @since 1.0.0
		 */
		protected static $_instance = null;

		/**
		 * Main WP_Travel_Custom_Filters Instance.
		 * Ensures only one instance of WP_Travel_Custom_Filters is loaded or can be loaded.
		 *
		 * @since 1.0.0
		 * @static
		 * @see WP_Travel_Custom_Filters()
		 * @return WP_Travel_Custom_Filters - Main instance.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Init core.
		 *
		 * @param Array $params Core class init paramerters.
		 */
		public static function init( $params ) {
			self::$abspath     = $params['abspath'] . 'inc/modules/custom-filters-core/';
			self::$plugin_file = __FILE__;
			self::$version     = $params['version'];

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$enable_custom_filters = isset( $settings['show_wp_travel_custom_filters'] ) ? $settings['show_wp_travel_custom_filters'] : 'yes';

			add_filter( 'wp_travel_settings_fields', array( 'WP_Travel_Custom_Filters_Core', 'settings_fields' ) );
			add_action( 'wp_travel_addons_setings_tab_fields', array( 'WP_Travel_Custom_Filters_Core', 'plugin_action' ) );
			// if ( 'yes' !== $enable_custom_filters ) {
			// return;
			// }
			include_once self::$abspath . 'inc/class-wp-travel-filters.php';
			self::$filter = new WP_Travel_Filters( self::$abspath );
			add_action( 'admin_enqueue_scripts', array( 'WP_Travel_Custom_Filters_Core', 'assets' ) );
		}

		/**
		 * Default settings fields.
		 *
		 * @param array $settings WP Travel Settings.
		 * @return array
		 */
		public static function settings_fields( $settings ) {
			$settings['show_wp_travel_custom_filters'] = 'yes';
			return $settings;
		}

		/**
		 * Plugin action to show / hide plugin settings and features.
		 */
		public static function plugin_action() {
			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}

			$field_name  = 'show_wp_travel_custom_filters';
			$field_label = __( 'WP Travel Custom Filters', 'wp-travel-pro' );

			$field_value = isset( $settings[ $field_name ] ) ? $settings[ $field_name ] : 'yes'; ?>
			<table class="form-table">
				<tr>
					<th>
						<label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html( $field_label ); ?></label>
					</th>
					<td>
						<span class="show-in-frontend checkbox-default-design">
							<label data-on="ON" data-off="OFF">
								<input value="no" name="<?php echo esc_attr( $field_name ); ?>" type="hidden" />
								<input <?php checked( $field_value, 'yes' ); ?> value="yes" name="<?php echo esc_attr( $field_name ); ?>" id="<?php echo esc_attr( $field_name ); ?>" type="checkbox" />
								<span class="switch"></span>
							</label>
						</span>
						<p class="description"><label for="<?php echo esc_attr( $field_name ); ?>"><?php echo esc_html__( 'Show all your "', 'wp-travel-pro' ) . esc_html( $field_label ) . esc_html__( '" settings and enable its feature.', 'wp-travel-pro' ); ?></label></p>
					</td>
				</tr>
			</table>
			<?php

		}

		/**
		 * Field editor assets.
		 */
		public static function assets() {
			$prefix = defined( 'WP_DEBUG' ) && WP_DEBUG ? '' : '.min';
			if ( is_admin() && 'itinerary-booking_page_wp_travel_custom_filters_page' === get_current_screen()->id ) {
				wp_enqueue_style( 'wp-travel-custom-filters-style', plugin_dir_url( __FILE__ ) . "assets/css/wp-travel-custom-filters{$prefix}.css", array(), '1.0.0' );
				wp_enqueue_script( 'wp-travel-custom-filters-style', plugin_dir_url( __FILE__ ) . "assets/js/dist/custom-filters{$prefix}.js", array( 'jquery' ), '1.0.0', true );
			}
		}

	}
endif;
