<?php
class WP_Travel_Downloads_Admin_Metabox{
    public static function init(){
        add_action( 'add_meta_boxes', array(__CLASS__, 'register_meta_box' ) );
    }

    public static function register_meta_box(){
        add_meta_box(
            'wpt_cpt_downloads_metabox',
            'Upload content',
            array( __CLASS__, 'meta_box_callback' ), // Callback function from below function.
            'wp_travel_downloads', // Cpt Downloads slug.
            'normal',
            'default'
        );
    }

    public static function meta_box_callback() {
        global $post;
        $projects = get_post_meta( $post->ID, 'wpt_downloads_cpt_meta', true );
        $media_id = isset( $projects['media_id'] ) ? $projects['media_id'] : '';
        $src      = wp_get_attachment_url( $media_id );
        $caption  = isset( $projects['caption'] ) ? $projects['caption'] : '';
        ?>
        <div class="content">
            <div class="element-wrapper">
                <div class="element-wrapper-grid">
                    <div class="element-wrapper-grid-item img-wrap">
                        <img width="50px" id="wp_img_media_uploader" src="<?php echo esc_url( $src ); ?>" />
                        <input type="hidden" name="project[media_id]" value="<?php echo esc_attr( $media_id ); ?>" />
                        <div class="element-wrapper-btn-group"> <button class="upload_image_button"><i class="fas fa-pencil-alt"></i></button></div>
                    </div>
                    <div class="element-wrapper-grid-item">
                        <label for="wpt_downloads_caption"><span><?php echo esc_html__( 'Caption:', 'wp-travel-pro' ); ?></span>
                            <textarea type="text" name="project[caption]" id="wpt_downloads_caption" required><?php echo esc_html( $caption ); ?></textarea>
                        </label>
                    </div>
                </div>
            </div>
        </div>
    <?php
    }


}

WP_Travel_Downloads_Admin_Metabox::init();