<?php
class WP_Travel_Downloads_Frontend_Download_Tab {

	/**
	 * Init hooks.
	 *
	 * @return void
	 */
	public static function init() {
		add_filter( 'wp_travel_default_frontend_tabs', array( __CLASS__, 'add_downloads_tab' ) );
	}

	/**
	 * Function to add tab "Downloads" to front end of wp travel.
	 * Hooked from helpers.php of WP-Travel.
	 */
	public static function add_downloads_tab( $tabs ) {
		global $post;
		$post_id      = isset( $post->ID ) ? $post->ID : '';
		$all_downlods = WP_Travel_Downloads_Helpers_Downloads::get_downloads_by_trip_id( $post_id );
		$show_in_menu = ! is_wp_error( $all_downlods ) && 'WP_TRAVEL_TRIP_DOWNLOADS_DATA' === $all_downlods['code'] && ! empty( $all_downlods['downloads']['downloads'] ) ? 'yes' : 'no';

		if ( ! isset( $tabs['downloads'] ) ) {

			$tabs['downloads'] = array(
				'label'        => __( 'Downloads', 'wp-travel-pro' ),
				'label_class'  => '',
				'content'      => self::list_downloads_to_frontend(),
				'use_global'   => 'yes',
				'show_in_menu' => $show_in_menu,
			);
		} else {
			$tabs['downloads']['content'] = self::list_downloads_to_frontend();
		}

		return $tabs;
	}

	public static function list_downloads_to_frontend( $post_id = false, $all_downlods = false ) {
		ob_start();
		if ( ! $post_id ) {
			global $post;
			$post_id = isset( $post->ID ) ? $post->ID : '';
		}
		$selected_downloads_title         = '';
		$list_selected_downloads_frontend = '';
		$enabled_download_itinerary       = '';
		if ( false === $all_downlods ) {
			$all_downlods = WP_Travel_Downloads_Helpers_Downloads::get_downloads_by_trip_id( $post_id );
		}
		$settings                    = get_option( 'wp_travel_settings' ); // not used wptravel_get_settings due to looping issue.
		$enable_itinerary_downloader = isset( $settings['enable_itinerary_downloads'] ) ? $settings['enable_itinerary_downloads'] : 'no';
		if ( ( ! is_wp_error( $all_downlods ) && 'WP_TRAVEL_TRIP_DOWNLOADS_DATA' === $all_downlods['code'] ) ) {
			if ( ! empty( $all_downlods['downloads']['downloads'] ) ) {
				foreach ( $all_downlods['downloads']['downloads'] as $download ) {
					$selected_post_id           = $download['id'];
					$selected_downloads_title   = $download['title'];
					$selected_downloads_caption = $download['caption'];
					$pull_src_from_media_id     = isset( $download['download_file_data']['url'] ) ? $download['download_file_data']['url'] : null;

					// Check if URL path is correct otherwise get url from ID.
					if ( empty( pathinfo( $pull_src_from_media_id, PATHINFO_EXTENSION ) ) && ! empty( $download['download_file_data']['id'] ) ) {
						$pull_src_from_media_id = wp_get_attachment_url( $download['download_file_data']['id'] );
					}

					$featured_image = '';
					if ( isset( $download['featured_image_data'] ) && is_array( $download['featured_image_data'] ) && count( $download['featured_image_data'] ) > 0 ) {
						$featured_image = ! empty( $download['featured_image_data'] ) && ! empty( $download['featured_image_data']['sizes']['thumbnail']['url'] ) ? $download['featured_image_data']['sizes']['thumbnail']['url'] : $download['featured_image_data']['url'];
					}

					if ( empty( $featured_image ) && ! empty( $download['download_file_data']['id'] ) ) {
						$get_icon = self::icon_mime_type( $download['download_file_data']['id'] );
					} else {
						$get_icon = '<img src="' . $featured_image . '" width="100"/>';
					}

					$icon                              = '<a href="' . esc_url( $pull_src_from_media_id ) . '" target="_blank">' . $get_icon . '</a>';
					$list_selected_downloads_frontend .= '<div class="wp-travel-downloads-listings-public">' . wp_kses_post( $icon ) . ' ' . '<div class="wp_travel_downloads_tab_title_caption"><a href="' . esc_url( $pull_src_from_media_id ) . '" target="_blank">' . esc_html( $selected_downloads_title ) . '</a><span>' . esc_html( $selected_downloads_caption ) . '</span></div></div>';
				}
			}
			if ( ! empty( $list_selected_downloads_frontend ) ) {
				echo $list_selected_downloads_frontend; //phpcs:ignore
			}

			// Send attachment to users.
			?>
			<div id="send-email">
				<div class="send_email_checkbox">
					<input id="download-checkbox" type="checkbox" name="send_downloads_as_email" value="1"> <?php esc_html_e( 'Want to send trip information to others?', 'wp-travel-pro' ); ?>
				</div>

				<div id="user-email-address" class="email_field">
					<form class="form" id="ajax-email-form" method="post" action="">
						<input type="hidden" placeholder="<?php esc_attr_e( 'Enter Email Address', 'wp-travel-pro' ); ?>" name="wp_travel_send_email_to_user" value="1">
						<input id="email-id" type="text" placeholder="<?php esc_attr_e( 'Enter Email Address', 'wp-travel-pro' ); ?>" name="wp_travel_user_email_address">
						<strong><span class="invalid_error" style="color:red" id="invalid_email"><?php esc_html_e( 'Email ID is invalid', 'wp-travel-pro' ); ?></span></strong>
						<strong><span class="blank_error" style="color:red" id="blank_email"><?php esc_html_e( 'Please enter an email address.', 'wp-travel-pro' ); ?></span></strong>
						<button type="submit" class="btn-submit"><?php esc_html_e( 'Send', 'wp-travel-pro' ); ?></button>
					</form>
				</div>
			</div>
			<?php
			/**
			 * fixed resend itinerary pdf after reload browser
			 * @version 6.7.0
			 */
			$http_cache_check = isset( $_SERVER['HTTP_CACHE_CONTROL'] ) ? $_SERVER['HTTP_CACHE_CONTROL'] : 'max-age=0';
			if ( $http_cache_check != 'no-cache' ) {
				self::send_download_attachement_to_user();
			}

			$url                         = get_permalink( $post_id );
			$url                         = add_query_arg( 'download_itinerary', true, $url );
			$url                         = add_query_arg( 'trip_id', $post_id, $url );
			$url                         = add_query_arg( '_nonce', WP_Travel::create_nonce(), $url );
			$enabled_download_itinerary .= '<div class="wp-travel-itinerary-downloads">' . '<a class="itinerary-download-button" href="' . esc_url( $url ) . '"  target="_blank">' . esc_html__( 'Itinerary Downloads', 'wp-travel-pro' ) . '<i class="fas fa-download"></i>' . '</a></div>';

			// $trip_data['itinerary_downloads'] = get_post_meta( $post_id, 'itinerary_downloads', true );

			if ( 'yes' === $enable_itinerary_downloader ) {
				echo wp_kses_post( $enabled_download_itinerary );
			}
			
		} else {
			echo ( '<p class="wp-travel-no-detail-found-msg">No Downloads available</p>' );
		}
		return ob_get_clean();
	}

	public static function icon_mime_type( $post_id ) {
		$type = get_post_mime_type( $post_id );

		$img     = '<i class="fas fa-file-image"></i>';
		$video   = '<i class="fas fa-file-video"></i>';
		$audio   = '<i class="fas fa-file-audio"></i>';
		$text    = '<i class="fas fa-file-alt"></i>';
		$pdf     = '<i class="fas fa-file-pdf"></i>';
		$sheet   = '<i class="fas fa-file-excel"></i>';
		$docs    = '<i class="fas fa-file-word"></i>';
		$csv     = '<i class="fas fa-file-csv"></i>';
		$default = '<i class="fas fa-file"></i>';

		if ( ! $type ) {
			$type = 'text/plain';
		}

		switch ( $type ) {
			case 'image/jpeg':
			case 'image/jpg':
			case 'image/png':
			case 'image/gif':
				return $img;
			break;

			case 'video/mpeg':
			case 'video/mp4':
			case 'video/quicktime':
				return $video;
			break;

			case 'text/plain':
			case 'text/txt':
			case 'application/txt':
				return $text;
			break;

			case 'application/pdf':
				return $pdf;
			break;

			case 'text/csv':
			case 'application/csv':
				return $csv;
			break;

			case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
			case 'application/xml':
				return $sheet;
			break;

			case 'application/msword':
			case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
				return $docs;
			break;

			case 'audio/mp3':
			case 'audio/ogg':
			case 'audio/mpeg3':
			case 'audio/x-wav':
			case 'audio/wav':
			case 'audio/mpeg':
			case 'audio/m4a':
				return $audio;
			break;

			default:
				return $default;
			break;
		}
	}

	/**
	 * Send attachment to user.
	 *
	 * @return void.
	 */
	public static function send_download_attachement_to_user() {
		
		static $sent = 0; // To prevent the loop.

		if ( $sent ) {
			return;
		}

		if ( empty( $_POST ) ) {
			return;
		}


		if ( empty( $_POST['wp_travel_user_email_address'] ) && empty( $_POST['wp_travel_send_email_to_user'] ) ) {
			return;
		}

		$user_email = $_POST['wp_travel_user_email_address'];

		$trip_id             = get_the_ID();
		$trip_info           = ! empty( get_the_title( $trip_id ) ) ? get_the_title( $trip_id ) : 'Trip Information';
		$trip_url            = ! empty( get_the_permalink( $trip_id ) ) ? get_the_permalink( $trip_id ) : '';
		$wp_travel_downloads = get_post_meta( $trip_id, 'wp_travel_downloads', true );
		$downloadable_link   = '';
		if ( is_array( $wp_travel_downloads['downloads'] ) && count( $wp_travel_downloads['downloads'] ) > 0 ) {
			foreach ( $wp_travel_downloads['downloads'] as $selected_downloadable_id ) {
				$downloadables_title = get_the_title( $selected_downloadable_id );
				$download_datas      = get_post_meta( $selected_downloadable_id, 'wpt_downloads_cpt_meta', true );
				$media_id            = ! empty( $download_datas['media_id'] ) ? $download_datas['media_id'] : '';
				$downloads_url       = ! empty( $media_id ) ? wp_get_attachment_url( $media_id ) : '';
				$download_content    = ! empty( $download_datas['caption'] ) ? $download_datas['caption'] : '';
				$downloadable_link  .= "<li><a href='{$downloads_url}'>{$downloadables_title}</a> : {$download_content}</li>\n";
			}
		}

		// Email part start here.
		$to      = $user_email;
		$subject = $trip_info . ' Informations';
		$subject = apply_filters( 'wptravel_download_attachment_mail_subject', $subject, $trip_info );
		$body    = "Hello,<br><br>You have received <a href='{$trip_url}'>{$trip_info}</a> attachments. Please find the attachment link below. <br>" . $downloadable_link . "<br>Thank You"; // Needs enhancements ( Email Template ).
		$body    = apply_filters( 'wptravel_download_attachment_mail_content', $body, $trip_url, $trip_info, $downloadable_link  );
		$from    = get_option( 'admin_email' );
		$email   = new WP_Travel_Emails();
		$headers = $email->email_headers( $from, $to );

		// Trip itinerary pdf path.
		/**
		 * fixed issue sending itinerary donload while disable itinerary download
		 * @version 6.7.0
		 */
		$settings = get_option( 'wp_travel_settings' ); // not used wptravel_get_settings due to looping issue.
		$itinerary_download_enable = isset( $settings['enable_itinerary_downloads'] ) ? $settings['enable_itinerary_downloads'] : 'no';

		if ( 'yes' == $itinerary_download_enable ) { // fixed issue sending itinerary donload while disable itinerary download
			$attachment = '';
			WP_Travel_Downloads_Core::generate_pdf( $trip_id, false );
			$dir                   = trailingslashit( WP_TRAVEL_ITINERARY_PATH );
			$trips_name            = get_the_title( $trip_id );
			$downloadable_filename = $trips_name . '.pdf';
			$attachment            = $dir . $downloadable_filename;
			if ( $sent != 0 ) {
				if ( ! wp_mail( $to, $subject, $body, $headers, array( $attachment ) ) ) {
					WPTravel()->notices->add( '<strong>' . __( 'Error:', 'wp-travel-pro' ) . '</strong> ' . __( 'The email could not be sent. Possible reason: your host may have disabled the mail() function.', 'wp-travel-pro' ), 'error' );
				} else {
					WPTravel()->notices->add( '<strong>' . __( 'Success:', 'wp-travel-pro' ) . '</strong> ' . __( 'Mail sent successfully.', 'wp-travel-pro' ), 'success' );

				}
			}
		} else {
			if ( ! wp_mail( $to, $subject, $body, $headers ) ) {
				WPTravel()->notices->add( '<strong>' . __( 'Error:', 'wp-travel-pro' ) . '</strong> ' . __( 'The email could not be sent. Possible reason: your host may have disabled the mail() function.', 'wp-travel-pro' ), 'error' );
			} else {
				WPTravel()->notices->add( '<strong>' . __( 'Success:', 'wp-travel-pro' ) . '</strong> ' . __( 'Mail sent successfully.', 'wp-travel-pro' ), 'success' );

			}
		}

		$sent++; // To prevent running function for more than one time. ( Quick Fix ).
	}
}

WP_Travel_Downloads_Frontend_Download_Tab::init();
