<?php
class WP_Travel_Downloads_Helpers_Downloads {
	public static function get_downloads( $args = array() ) {
		$defaults        = array(
			'post_type'   => 'wp_travel_downloads',
			'post_status' => array( 'publish' ),
			'posts_per_page' => '-1',
		);
		$args            = wp_parse_args( $args, $defaults );
		$downloads_posts = get_posts( $args );
		if ( empty( $downloads_posts ) ) {
			if ( class_exists( 'WP_Travel_Helpers_Error_Codes' ) ) {
				return WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_NO_DOWNLOADS_FOUND' );
			}
			return;
		}

		$downloads = array();

		$index = 0;
		foreach ( $downloads_posts as $download ) {
			$downloads[ $index ]['id']                  = $download->ID;
			$downloads[ $index ]['title']               = $download->post_title;
			$downloads[ $index ]['title']               = $download->post_title;
			$downloads[ $index ]['status']              = $download->post_status;
			$downloads[ $index ]['featured_image_data'] = false;
			$post_thumbnail_id                          = get_post_thumbnail_id( $download->ID );
			if ( ! empty( $post_thumbnail_id ) ) {
				$attachment_meta = array();
				if (class_exists('WP_Travel_Helpers_Media') ) {
					$attachment_meta = WP_Travel_Helpers_Media::get_attachment_meta_data( $post_thumbnail_id );
				}

				if ( ! is_wp_error( $attachment_meta ) && 'WP_TRAVEL_ATTACHMENT_DATA' === $attachment_meta['code'] ) {
					$downloads[ $index ]['featured_image_data'] = $attachment_meta['attachment'];
				}
			}

			$download_files = get_post_meta( $download->ID, 'wpt_downloads_cpt_meta', true );
			if ( ! empty( $download_files['media_id'] ) ) {
				$attachment_meta = array();
				if (class_exists('WP_Travel_Helpers_Media') ) {
					$attachment_meta = WP_Travel_Helpers_Media::get_attachment_meta_data( absint( $download_files['media_id'] ) );
				}

				if ( ! is_wp_error( $attachment_meta ) && isset( $attachment_meta['code'] ) && 'WP_TRAVEL_ATTACHMENT_DATA' === $attachment_meta['code'] ) {
					$downloads[ $index ]['download_file_data'] = $attachment_meta['attachment'];
				}
			}
			$downloads[ $index ]['caption'] = ! empty( $download_files['caption'] ) ? $download_files['caption'] : '';
			$index++;
		}

		if ( class_exists( 'WP_Travel_Helpers_Response_Codes' ) ) {
			return WP_Travel_Helpers_Response_Codes::get_success_response(
				'WP_TRAVEL_DOWNLOADS_DATA',
				array(
					'downloads' => $downloads,
				)
			);
		}
		return;
	}
	



	public static function get_downloads_by_trip_id( $trip_id = false ) {
		
		if ( empty( $trip_id ) ) {		
			if ( class_exists( 'WP_Travel_Helpers_Error_Codes' ) ) {
				return WP_Travel_Helpers_Error_Codes::get_error( 'WP_TRAVEL_NO_TRIP_ID' );
			}
			return;
		}

		$all_downloads               = get_post_meta( $trip_id, 'wp_travel_downloads', true );
		$lagacy_downloads            = get_post_meta( $trip_id, 'wpt_itineraries_select_downloads', true );
		$response['downloads']       = array();
		$response['email_downloads'] = array();
		if ( ! empty( $all_downloads['downloads'] ) ) {
			$args['post__in']   = $all_downloads['downloads'];
			$trip_page_download = self::get_downloads( $args );

			if ( ! is_wp_error( $trip_page_download ) && 'WP_TRAVEL_DOWNLOADS_DATA' === $trip_page_download['code'] ) {
				$response['downloads'] = $trip_page_download['downloads'];
			}
		} elseif ( ! empty( $lagacy_downloads ) ) {
			$args['post__in']   = $lagacy_downloads;
			$trip_page_download = self::get_downloads( $args );

			if ( ! is_wp_error( $trip_page_download ) && 'WP_TRAVEL_DOWNLOADS_DATA' === $trip_page_download['code'] ) {
				$response['downloads'] = $trip_page_download['downloads'];
			}
		}

		if ( ! empty( $all_downloads['email_downloads'] ) ) {
			$args['post__in']   = $all_downloads['email_downloads'];
			$trip_page_download = self::get_downloads( $args );

			if ( ! is_wp_error( $trip_page_download ) && 'WP_TRAVEL_DOWNLOADS_DATA' === $trip_page_download['code'] ) {
				$response['email_downloads'] = $trip_page_download['downloads'];
			}
		}

		if ( class_exists( 'WP_Travel_Helpers_Response_Codes' ) ) {
			return WP_Travel_Helpers_Response_Codes::get_success_response(
				'WP_TRAVEL_TRIP_DOWNLOADS_DATA',
				array(
					'downloads' => $response,
				)
			);
		}
		return;
	}
}
