<?php
/**
 * Function to display font_awesome_icon according to mime_type.
 * Took help from https://stackoverflow.com/questions/28344776/wordpress-get-post-mime-type
 */
function wp_travel_downloads_icon_mime_type( $post_id ) {
	$type = get_post_mime_type( $post_id );

	$img     = '<i class="fas fa-file-image"></i>';
	$video   = '<i class="fas fa-file-video"></i>';
	$audio   = '<i class="fas fa-file-audio"></i>';
	$text    = '<i class="fas fa-file-alt"></i>';
	$pdf     = '<i class="fas fa-file-pdf"></i>';
	$sheet   = '<i class="fas fa-file-excel"></i>';
	$docs    = '<i class="fas fa-file-word"></i>';
	$csv     = '<i class="fas fa-file-csv"></i>';
	$default = '<i class="fas fa-file"></i>';

	if ( ! $type ) {
		return 'N/A';
	}

	switch ( $type ) {
		case 'image/jpeg':
		case 'image/png':
		case 'image/gif':
			return $img;
		break;

		case 'video/mpeg':
		case 'video/mp4':
		case 'video/quicktime':
			return $video;
		break;

		case 'text/plain':
		case 'text/txt':
		case 'application/txt':
			return $text;
		break;

		case 'application/pdf':
			return $pdf;
		break;

		case 'text/csv':
		case 'application/csv':
			return $csv;
		break;

		case 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet':
		case 'application/xml':
			return $sheet;
		break;

		case 'application/msword':
		case 'application/vnd.openxmlformats-officedocument.wordprocessingml.document':
			return $docs;
		break;

		case 'audio/mp3':
		case 'audio/ogg':
		case 'audio/mpeg3':
		case 'audio/x-wav':
		case 'audio/wav':
		case 'audio/mpeg':
		case 'audio/m4a':
			return $audio;
		break;

		default:
			return $default;
		break;
	}
}

/**
 * Function to display selected options to frontend under downloads tab.
 * Hooked from template-functions.php of WP Travel.
 */
function wp_travel_list_downloads_to_frontend() {
	wp_enqueue_style( 'wp_travel_downloads_frontend_css' );
	ob_start();
	global $post;
	$post_id                          = isset( $post->ID ) ? $post->ID : '';
	$selected_downloads_title         = '';
	$list_selected_downloads_frontend = '';

	$selected_downloads = get_post_meta( $post_id, 'wpt_itineraries_select_downloads', true );
	if ( ! empty( $selected_downloads ) ) {
		$args = array(
			'post_type'      => 'wp_travel_downloads',
			// 'post_status' => 'publish',
			'posts_per_page' => -1,
			'post__in'       => $selected_downloads
		);
		$download_posts = get_posts($args );
		if ( ! empty( $download_posts ) ) {
			foreach ( $download_posts as $download ) {
				$selected_post_id            = $download->ID;
				$selected_downloads_title    = get_the_title( $selected_post_id );
				$selected_downloads_array    = get_post_meta( $selected_post_id, 'wpt_downloads_cpt_meta', true );
				$selected_downloads_caption  = isset( $selected_downloads_array['caption'] ) ? $selected_downloads_array['caption'] : '';
				$selected_downloads_media_id = isset( $selected_downloads_array['media_id'] ) ? $selected_downloads_array['media_id'] : '';
				$pull_src_from_media_id      = wp_get_attachment_url( $selected_downloads_media_id );

				// Called from above function "wp_travel_downloads_icon_mime_type()".
				if ( has_post_thumbnail( $selected_post_id ) ) {
					$get_icon = get_the_post_thumbnail( $selected_post_id, 'thumbnail' );
				} else {
					$get_icon = wp_travel_downloads_icon_mime_type( $selected_downloads_media_id );
				}
				$icon                              = '<a href="' . esc_url( $pull_src_from_media_id ) . '" target="_blank">' . $get_icon . '</a>';
				$list_selected_downloads_frontend .= '<div class="wp-travel-downloads-listings-public">' . wp_kses_poat( $icon ) . ' ' . '<div class="wp_travel_downloads_tab_title_caption"><a href="' . esc_url( $pull_src_from_media_id ) . '" target="_blank">' . esc_html( $selected_downloads_title ) . '</a><span>' . esc_html( $selected_downloads_caption ) . '</span></div></div>';

			}
		}
		if ( ! empty( $selected_downloads_media_id ) ) {
			echo wp_kses_post( $list_selected_downloads_frontend );
		} else {
			echo ( '<p class="wp-travel-no-detail-found-msg"> No Downloads available</p>' );
		}
	} else {
		echo ( '<p class="wp-travel-no-detail-found-msg">No Downloads available</p>' );
	}
	return ob_get_clean();
}

/**
 * Function to add tab "Downloads" to front end of wp travel.
 * Hooked from helpers.php of WP-Travel.
 */
function wp_travel_downloads_add_downloads_tab( $tabs ) {
	global $post;
	$post_id            = isset( $post->ID ) ? $post->ID : '';
	$selected_downloads = get_post_meta( $post_id, 'wpt_itineraries_select_downloads', true );
	$show_in_menu       = ! empty( $selected_downloads ) ? 'yes' : 'no';

	if ( ! isset( $tabs['downloads'] ) ) {

		$tabs['downloads'] = array(
			'label'        => 'Downloads',
			'label_class'  => '',
			'content'      => wp_travel_list_downloads_to_frontend(),
			'use_global'   => 'yes',
			'show_in_menu' => $show_in_menu,
		);
	} else {
		$tabs['downloads']['content'] = wp_travel_list_downloads_to_frontend();
	}
	return $tabs;
}
// add_filter( 'wp_travel_default_trip_tabs', 'wp_travel_downloads_add_downloads_tab' );

/**
 * Function to initialize the Downloads tabs at frontend.
 *
 * @param [type] $display
 * @param string $post_id Returns the post id.
 * @param string $tab_key Returns the tab key frontend.
 * @return void
 */
function wp_travel_display_download_tabs( $display, $post_id, $tab_key ) {
	if ( 'downloads' === $tab_key && 'yes' === $display ) {
		$selected_downloads = get_post_meta( $post_id, 'wpt_itineraries_select_downloads', true );
		$display = ! empty( $selected_downloads ) ? 'yes' : 'no';
	}
	return $display;
}
// add_filter( 'wp_travel_frontend_tab_show_in_menu', 'wp_travel_display_download_tabs', 10, 3 );
