<?php
/**
 * WP Travel Plugin Name Core Class.
 *
 * @package wp-travel-plugin-name-core
 * @category Core
 * @author WP Travel
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// WP Travel Plugin Name core.
if ( ! class_exists( 'WpTravel_Google_Calendar_Core' ) ) :
	/**
	 * Core Class
	 */
	class WpTravel_Google_Calendar_Core {

		const WPTRAVEL_GOOGLE_CALENDAR_HANDLE = 'wptravel_google_calendar_';


		/**
		 * ABSPATH
		 *
		 * @var string $abspath
		 */
		protected static $abspath;

		/**
		 * Plugin File Path
		 *
		 * @var string $plugin_file
		 */
		protected static $plugin_file;

		/**
		 * Plugin File URL
		 *
		 * @var string $plugin_url
		 */
		protected static $plugin_url;

		/**
		 * Plugin Version
		 *
		 * @var string $version
		 */
		protected static $version;

		/**
		 * The single instance of the class.
		 *
		 * @var WP Travel Plugin Name Core
		 * @since 1.0.0
		 */
		protected static $_instance = null;

		/**
		 * Main WpTravel_Google_Calendar_Core Instance.
		 * Ensures only one instance of WpTravel_Google_Calendar_Core is loaded or can be loaded.
		 *
		 * @since 1.0.0
		 * @static
		 * @see WpTravel_Google_Calendar_Core()
		 * @return WpTravel_Google_Calendar_Core - Main instance.
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}

		/**
		 * Init core.
		 *
		 * @param array $plugin_data Plagin data.
		 */
		public static function init( $plugin_data ) {
			self::$abspath     = dirname( __FILE__ ) . '/';
			self::$plugin_file = __FILE__;
			self::$plugin_url  = plugin_dir_url( __FILE__ );
			self::$version     = $plugin_data['version'];
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_assets' ) );
			include_once self::$abspath . 'inc/admin-settings-misc-api-key.php';

			if ( function_exists( 'wptravel_get_settings' ) ) {
				$settings = wptravel_get_settings();
			} else {
				$settings = wp_travel_get_settings();
			}
			$enable_calendar = isset( $settings['show_wp_travel_google_calendar'] ) ? $settings['show_wp_travel_google_calendar'] : 'yes';
			// if ( 'yes' !== $enable_calendar ) {
			// return;
			// }
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'frontend_assets' ) );
			self::includes();

		}

		/**
		 * Frontend assets.
		 */
		public static function frontend_assets() {

		}

		/**
		 * Utilities admin assets.
		 */
		public static function admin_assets() {
			$deps = include_once sprintf( '%s/app/build/wp-travel-settings.asset.php', plugin_dir_path( __FILE__ ) );
			wp_register_script( self::WPTRAVEL_GOOGLE_CALENDAR_HANDLE . 'admin-settings', plugin_dir_url( __FILE__ ) . '/app/build/wp-travel-settings.js', $deps['dependencies'], $deps['version'], true );
			// wptravel_google_calendar_admin-settings
			wp_enqueue_script( 'wptravel_google_calendar_admin-settings' );
		}


		/**
		 * Include required core files used in admin and on the frontend.
		 *
		 * @return void
		 */
		public static function includes() {

			// if ( ! class_exists( 'WP_Travel' ) ) {
			// return;
			// }
			/**
			 * Include required files
			 */
			include_once self::$abspath . 'vendor/autoload.php';
			include_once self::$abspath . 'inc/admin-settings-misc-api-key.php';
			 include_once self::$abspath . 'class-wptravel-google-calendar.php';

		}

		/**
		 * Return redirect url after google login.
		 */
		public static function get_redirect_url() {
			return admin_url( '/edit.php?post_type=itinerary-booking&page=settings' );
		}
	}
endif;
