<?php
/**
 * Group Discount Functions.
 *
 * @package wp-travel-group-discount/inc
 */

 /**
  * Ajax callback function to get group discount price from frontend.
  */
function wp_travel_group_discount_price_callback() {
	// Run a security check first.
	check_ajax_referer( 'wp_travel_frontend_security', 'security' );

	if ( ! isset( $_POST['trip_id'] ) ) {
		return;
	}
	$response = array( 'price' => 0 );

	$trip_id     = sanitize_text_field( wp_unslash( $_POST['trip_id'] ) );
	$price_key   = isset( $_POST['price_key'] ) ? sanitize_text_field( wp_unslash( $_POST['price_key'] ) ) : '';
	$pax         = isset( $_POST['pax'] ) ? sanitize_text_field( wp_unslash( $_POST['pax'] ) ) : 1;
	$pricing_id  = isset( $_POST['pricing_id'] ) ? sanitize_text_field( wp_unslash( $_POST['pricing_id'] ) ) : '';
	$category_id = isset( $_POST['category_id'] ) ? sanitize_text_field( wp_unslash( $_POST['category_id'] ) ) : '';

	// $price = wp_travel_get_actual_trip_price( $trip_id, $price_key );
	if ( method_exists( 'WP_Travel_Helpers_Pricings',  'get_price' ) ) {
		$args = array(
			'trip_id' => $trip_id,
			'pricing_id' => $pricing_id,
			'category_id' => $category_id,
			'price_key' => $price_key,
		);
		$price = WP_Travel_Helpers_Pricings::get_price( $args );
	} else {
		// Legacy & deprecated. Need to remove in future
		$price = wp_travel_get_price( $trip_id, false, $pricing_id, $category_id, $price_key );
	}

	$response['price'] = $price;

	$group_price = wp_travel_group_discount_price( $trip_id, $pax, $pricing_id, $category_id, $price_key );
	if ( $group_price > 0 ) {
		$response['price'] = $group_price;
	}
	wp_send_json( $response );
}

/**
 * Group discount list table to view group discount price list.
 */
function wp_travel_group_discount_pricing_list( $trip_id, $price_key ) {

	$trip_pricing_options_data = get_post_meta( $trip_id, 'wp_travel_pricing_options', true ); // Pricing options list.

	$group_discount = get_post_meta( $trip_id, 'wp_travel_group_discount', true ); // group discount list

	$discount_data = array();
	if ( $trip_pricing_options_data && is_array( $trip_pricing_options_data ) ) {
		$array_cols = array_column( $trip_pricing_options_data, 'price_key' );

		// To preserve keys.
		$array_cols = array_combine( array_keys( $trip_pricing_options_data ), array_column( $trip_pricing_options_data, 'price_key' ) );

		$pricing_option_key = array_search( $price_key, $array_cols, true );

		if ( $pricing_option_key && isset( $group_discount[ $pricing_option_key ] ) ) {
			$discount_data = $group_discount[ $pricing_option_key ];
		}
	}

	if ( ! is_array( $discount_data ) || ( is_array( $discount_data ) && count( $discount_data ) < 1 ) ) {
		return;
	}
	// echo 'pricing id ' . $pricing_option_key . '-';
	$view_grp_disc_string = apply_filters( 'wp_travel_see_group_discount_text', __( 'view Group discount', 'wp-travel-pro' ) );
	$view_grp_disc_string = esc_html( $view_grp_disc_string );

	if ( isset( $discount_data['enable_group_discount'] ) && 'yes' === $discount_data['enable_group_discount'] ) {
		?>
		<div class="wp-travel-see-group-discount-wrap">

			<div class="wp-travel-see-group-discount">
				<span>
					<a href="javascript:void(0)" class="wp-travel-group-discount-view-detail"><?php echo esc_html( $view_grp_disc_string ); ?></a>
				</span>
			</div>
			<div class="wp-travel-see-group-discount-content">
				<a href="javascript:void(0)" class="wp-travel-see-group-discount-close" >X</a>

				<table id="group_discount">
				<!-- <tr><th colspan="3">Group Discount</th></tr> -->
					<tr>
						<th colspan="2"><?php esc_html_e( 'Pax', 'wp-travel-pro' ); ?></th>
						<th rowspan="2"><?php esc_html_e( 'Price', 'wp-travel-pro' ); ?></th>
					</tr>
					<tr>
						<th><?php esc_html_e( 'From', 'wp-travel-pro' ); ?></th>
						<th><?php esc_html_e( 'To', 'wp-travel-pro' ); ?></th>
					</tr>
					<?php
					if ( isset( $discount_data['pax_from'] ) && is_array( $discount_data['pax_from'] ) ) {
						foreach ( $discount_data['pax_from'] as $pax_key => $pax_from ) :
							$pax_to = $discount_data['pax_to'][ $pax_key ];
							$price  = $discount_data['price'][ $pax_key ];
							$price  = wp_travel_group_discount_price_override( $price );
							?>
							<tr>
								<td><?php echo esc_html( $pax_from ); ?></td>
								<td><?php echo esc_html( $pax_to ); ?></td>
								<td>
									<?php 
									if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
										echo wptravel_get_formated_price_currency( $price ); // @phpcs:ignore
									} else {
										echo wp_travel_get_formated_price_currency( $price ); // @phpcs:ignore
									}
									?></td>
							</tr>
							<?php
						endforeach;
					}
					?>
				</table>

			</div>
		</div>
		<?php
	} else { // multiple pricing category.
		if ( count( $discount_data ) > 0 ) {
			?>
			<div class="wp-travel-see-group-discount-wrap">

				<div class="wp-travel-see-group-discount">
					<span>
						<a href="javascript:void(0)" class="wp-travel-group-discount-view-detail"><?php echo esc_html( $view_grp_disc_string ); ?></a>
					</span>
				</div>
				<div class="wp-travel-see-group-discount-content">
					<a href="javascript:void(0)" class="wp-travel-see-group-discount-close" >X</a>

					<table id="group_discount">
						<!-- <tr><th colspan="3">Group Discount</th></tr> -->
						<tr>
							<th colspan="2"><?php esc_html_e( 'Pax', 'wp-travel-pro' ); ?></th>
							<th rowspan="2"><?php esc_html_e( 'Price', 'wp-travel-pro' ); ?></th>
						</tr>
						<tr>
							<th><?php esc_html_e( 'From', 'wp-travel-pro' ); ?></th>
							<th><?php esc_html_e( 'To', 'wp-travel-pro' ); ?></th>
						</tr>
						<?php
						foreach ( $discount_data as $category_id => $discount ) {
							$type = isset( $trip_pricing_options_data[ $pricing_option_key ]['categories'][ $category_id ]['type'] ) ? $trip_pricing_options_data[ $pricing_option_key ]['categories'][ $category_id ]['type'] : 'Na';
							?>
							<tr>
								<td colspan="3" class="center discount-heading" >
									<?php echo esc_html( $type ); ?>
								</td>
							</tr>
							<?php
							if ( isset( $discount['pax_from'] ) && is_array( $discount['pax_from'] ) ) {
								foreach ( $discount['pax_from'] as $pax_key => $pax_from ) :
									$pax_to = $discount['pax_to'][ $pax_key ];
									$price  = $discount['price'][ $pax_key ];
									$price  = wp_travel_group_discount_price_override( $price );
									?>
									<tr>
										<td><?php echo esc_html( $pax_from ); ?></td>
										<td><?php echo esc_html( $pax_to ); ?></td>
										<td><?php 
										if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
											echo wptravel_get_formated_price_currency( $price ); // @phpcs:ignore
										} else {
											echo wp_travel_get_formated_price_currency( $price ); // @phpcs:ignore
										}
										?></td>
									</tr>
									<?php
								endforeach;
							}
						}
						?>
					</table>

				</div>
			</div>
			<?php

		}
	}

}

add_action( 'wp_ajax_wt_group_discount_price', 'wp_travel_group_discount_price_callback' );
add_action( 'wp_ajax_nopriv_wt_group_discount_price', 'wp_travel_group_discount_price_callback' );

