<?php
/**
 * Admin Settings.
 *
 * @package wp-travel-group-discount/inc
 */

function wp_travel_group_discount_price( $trip_id, $pax, $pricing_id = '', $category_id = '', $price_key = '' ) {

	if ( method_exists( 'WP_Travel_Helpers_Pricings', 'get_price' ) ) {
		$args  = array(
			'trip_id'     => $trip_id,
			'pricing_id'  => $pricing_id,
			'category_id' => $category_id,
			'price_key'   => $price_key,
		);
		$price = WP_Travel_Helpers_Pricings::get_price( $args ); // this get_price method has already price conversion for multiple currency.
	} else {
		// Legacy & deprecated. Need to remove in future.
		$price = wp_travel_get_price( $trip_id, false, $pricing_id, $category_id, $price_key ); // ignored for multiple currency because we'll not support this anymore.
	}

	$switch_to_react = true; // force enable.
	if ( function_exists( 'wptravel_is_react_version_enabled' ) ) {
		$switch_to_react = wptravel_is_react_version_enabled(); // force enable but has filter to include backward compatibility for now.
	}
	if ( $switch_to_react ) {
		$pricings_data = WP_Travel_Helpers_Pricings::get_pricings( $trip_id );
		if ( 'WP_TRAVEL_TRIP_PRICINGS' === $pricings_data['code'] ) {
			// $pricings = $pricings_data['pricings'];
			$pricings     = array_filter(
				$pricings_data['pricings'],
				function( $p ) use ( $pricing_id ) {
					return $p['id'] == $pricing_id;
				}
			);
			$pricing      = array_shift( $pricings );
			$categories   = array_filter(
				$pricing['categories'],
				function( $c ) use ( $category_id ) {
					return $c['id'] == $category_id;
				}
			);
			$category     = array_shift( $categories );
			$group_prices = $category['group_prices'];
			if ( is_array( $group_prices ) ) {
				uasort(
					$group_prices,
					function( $a, $b ) {
						$maxa = (int) $a['max_pax'];
						$maxb = (int) $b['max_pax'];
						if ( $maxa == $maxb ) {
							return 0;
						}
						return ( $maxa < $maxb ) ? -1 : 1;
					}
				);
			}
			if ( isset( $pricing['has_group_price'] ) && $pricing['has_group_price'] ) { // Pricing group discount.
				$group_prices = $pricing['group_prices'];
				$group_price  = array();
				foreach ( $group_prices as $gp ) {
					if ( $pax >= $gp['min_pax'] && $pax <= $gp['max_pax'] ) {
						$group_price = $gp;
						break;
					}
				}
				$category_price = isset( $group_price['price'] ) ? WpTravel_Helpers_Trip_Pricing_Categories::get_converted_price( $group_price['price'] ) : $price; // $price is already converted from WP_Travel_Helpers_Pricings::get_price( $args ).
				$category_price = $category_price ? $category_price : 0; // Temp fixes.
				return $category_price;

			} elseif ( $category['has_group_price'] ) {
				$group_price = array();
				foreach ( $group_prices as $gp ) {
					if ( (int) $gp['min_pax'] <= $pax && (int) $gp['max_pax'] >= $pax ) {
						return WpTravel_Helpers_Trip_Pricing_Categories::get_converted_price( $gp['price'] );
					}
				}
				/**
				 * To get closest group discount.
				 */
				// $group_prices_reverse = array_reverse( $group_prices, true );
				// foreach ( $group_prices_reverse as $gpr ) {
				// if ( (int) $gpr['max_pax'] <= $pax ) {
				// return $gpr['price'];
				// }
				// }

				$price = $category['is_sale'] ? $category['sale_price'] : $category['regular_price'];
				return WpTravel_Helpers_Trip_Pricing_Categories::get_converted_price( $price );
			}
		}
		return $price;
	}
	$pricings     = wptravel_get_trip_pricing_option( $trip_id );
	$pricing_data = isset( $pricings['pricing_data'] ) ? $pricings['pricing_data'] : array();
	$min_pax      = 1;
	if ( $pricing_data && is_array( $pricing_data ) ) {
		$discount_data  = array();
		$group_discount = wp_travel_get_group_discount_data( $trip_id, $pricing_id );
		if ( isset( $group_discount[ $pricing_id ][ $category_id ] ) ) {
			$discount_data = $group_discount[ $pricing_id ][ $category_id ];
			if ( isset( $discount_data['enable_group_discount'] ) && 'yes' === $discount_data['enable_group_discount'] ) {
				if ( isset( $discount_data['pax_to'] ) && is_array( $discount_data['pax_to'] ) && count( $discount_data['pax_to'] ) > 0 ) {

					$pax_from  = $discount_data['pax_from']; // only used to check first value to compare with $min_pax value.
					$pax_upto  = $discount_data['pax_to'];
					$pax_price = $discount_data['price'];

					// Loop to get right $pax_key.
					foreach ( $pax_upto as $pax_key => $pax_val ) {
						if ( $pax >= $pax_val ) {
							if ( $pax != $pax_val ) {
								continue;
							}
							break;
						}
						break;
					}
					$price = $pax_price[ $pax_key ];

					/**
					 * If we are here, then it means
					 * we need to make the $price amount compatible
					 * for WP Travel Multiple Currency by overriding the value
					 * using this filter: wp_travel_group_discount_price_override
					 * which is hooked in wp-travel-pro/inc/modules/multiple-currency-core/inc/functions.php
					 * at function wp_travel_multiple_currency_converted_trip_price( $price )
					 */
					$price = wp_travel_group_discount_price_override( $price );

					// update price if pax is less than from pax and greater than min pax.
					if ( $pax >= $min_pax && $pax < $pax_upto[ $pax_key ] && $pax < $pax_from[ $pax_key ] ) {
						// $price = wp_travel_get_actual_trip_price( $trip_id, $price_key );
						if ( method_exists( 'WP_Travel_Helpers_Pricings', 'get_price' ) ) {
							$args  = array(
								'trip_id'     => $trip_id,
								'pricing_id'  => $pricing_id,
								'category_id' => $category_id,
								'price_key'   => $price_key,
							);
							$price = WP_Travel_Helpers_Pricings::get_price( $args );
						} else {
							// Legacy & deprecated. Need to remove in future
							$price = wp_travel_get_price( $trip_id, false, $pricing_id, $category_id, $price_key );
						}
					}
				}
			}
		}
	}
	return $price;
}


function wp_travel_get_group_discount_data( $trip_id, $pricing_id ) {

	if ( ! $trip_id ) {
		return array();
	}

	if ( ! $pricing_id ) {
		return array();
	}

	$group_discount = get_post_meta( $trip_id, 'wp_travel_group_discount', true ); // group discount list

	if ( is_array( $group_discount ) && ! empty( $group_discount ) && isset( $group_discount[ $pricing_id ]['price'] ) ) { // old data mapping.
		$group_discount[ $pricing_id ][ $pricing_id ] = $group_discount[ $pricing_id ]; // 2nd $pricing_id is set as catetory id because we don't have category id in old listing.
	}
	return $group_discount;

}

/**
 * Over rides the group discount price, helps the multiple currency especially.
 */
function wp_travel_group_discount_price_override( $price ) {
	$price = apply_filters( 'wp_travel_group_discount_price_override', $price );
	return $price;
}

