(function( $ ){
    $.extend($.fn, {
        wptravelHereMap: function( options ) {
            if ( this.length > 0 ) {
                // Get Selector name.
                var mapSelector = this[0].id;
                var selectorPrefix = '#';
                if ( ! mapSelector ) {
                    mapSelector = this[0].className;
                    selectorPrefix = '.';
                }
                var fullSelector = mapSelector;
                // End of getting selector name.

                var HereMap            = wp_travel.here_map; // Localized Data.
				var publicMapContainer = fullSelector;
				var appId              = HereMap.app.id;
				var appKey             = HereMap.app.key;
				var appCode            = HereMap.app.code;

				var latLng             = HereMap.latlng;
				var markerStyle        = HereMap.markerStyle;
				var iconUrl            = HereMap.imageIcon;
				var iconWidth          = HereMap.markerWidth ? parseInt(HereMap.markerWidth) : 32; //parseInt(HereMap.markerWidth);
				var iconHeight         = HereMap.markerHeight ? parseInt(HereMap.markerHeight) : 32;
				
				if( HereMap.enable_app_key == 'yes' ){

					$( window ).load(function() {

						if( appKey == '' ){
							return;
						}

						// Options data.
						var lat  = options && options.lat ? options.lat : HereMap.latlng.lat;
						var lng  = options && options.lng ? options.lng : HereMap.latlng.lng;
						var hereMapLatLng = { lat:lat, lng:lng };
						var zoom = options && options.zoom ? options.zoom : parseInt(HereMap.zoomLevel);

						/**
						 * Moves the map to display over Berlin
						 *
						 * @param  {H.Map} map      A HERE Map instance within the application
						 */
						function addDraggableMarker(map) {
							marker = new H.map.Marker(hereMapLatLng);
							// setMarker(marker)
							// Ensure that the marker can receive drag events
							marker.draggable = true;
							map.addObject(marker);
							map.setCenter(hereMapLatLng);
						}

						var platform = new H.service.Platform({
							apikey: appKey
						});

						var defaultLayers = platform.createDefaultLayers();

						var map = new H.Map(document.getElementById(publicMapContainer), defaultLayers.vector.normal.map, {
							zoom: zoom || 8,
							center: hereMapLatLng
						});

						window.addEventListener('resize', () => map.getViewPort().resize());
						var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));

						const ui = H.ui.UI.createDefault(map, defaultLayers);

						addDraggableMarker(map)
					});
				}else{
					$( window ).load(function() {

						if( latLng.lng == '' || latLng.lat == '' || appId == '' || appCode == '' ){
							return;
						}
	
						// Options data.
						var lat  = options && options.lat ? options.lat : HereMap.latlng.lat;
						var lng  = options && options.lng ? options.lng : HereMap.latlng.lng;
						var hereMapLatLng = { lat:lat, lng:lng };
						var zoom = options && options.zoom ? options.zoom : parseInt(HereMap.zoomLevel);
						
						/**
						 * Moves the map to display over Berlin
						 *
						 * @param  {H.Map} map      A HERE Map instance within the application
						 */
						function addDraggableMarker(map) {
							marker = new H.map.Marker(hereMapLatLng);
							// setMarker(marker)
							// Ensure that the marker can receive drag events
							marker.draggable = true;
							map.addObject(marker);
							map.setCenter(hereMapLatLng);
						}

	
						/**
						* Boilerplate map initialization code starts below:
						*/
	
						//Step 1: initialize communication with the platform
						var platform = new H.service.Platform({
							app_id: appId,
							app_code: appCode,
							useHTTPS: true
						});
	
						var pixelRatio = window.devicePixelRatio || 1;
						var defaultLayers = platform.createDefaultLayers({
							tileSize: pixelRatio === 1 ? 256 : 512,
							ppi: pixelRatio === 1 ? undefined : 320
	
						});
	
						//Step 2: initialize a map  - not specificing a location will give a whole world view.
						var map = new H.Map(document.getElementById(publicMapContainer),
							defaultLayers.normal.map, {
								zoom: zoom || 8,
								pixelRatio: pixelRatio
							});
	
						// behavior.
						window.addEventListener('resize', () => map.getViewPort().resize());
						var behavior = new H.mapevents.Behavior(new H.mapevents.MapEvents(map));

						const ui = H.ui.UI.createDefault(map, defaultLayers);

						addDraggableMarker(map)
					});
				}
				

            }
        }
    });
})( jQuery );
