payments.instamojo_checkout = function() {
}
jQuery(document).ready(function($) {

    var complete = function (l, response ) {
        var form_id = 'wp-travel-booking'; // Default payment form id

        var payment_form_id = jQuery( '#wp-travel-payment-form-id' ).val();

        if ( payment_form_id ) {
            form_id = payment_form_id;
        }

        jQuery('.loader-active').show();
        instamojo_remove();
        setTimeout(function() {
            jQuery( '[name=payment_details]' ).remove();
            jQuery( 'form#' + form_id ).append(jQuery("<input type='hidden' name='payment_details' />").attr("value", JSON.stringify(Object.assign({},l,response))));
            jQuery( 'form#' + form_id ).find("[type=submit]").click();
        }, 2);
    };
    
    var instamojo_trigger = function(e){
        jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
        var wt_parsley = jQuery("#wp-travel-booking").parsley()
        e.preventDefault();
        var l = jQuery("#wp-travel-payment-mode option:selected").val(); //Fix for partial payment.
        
        if ( $( '[name=complete_partial_payment]' ).length > 0 ) {
            o = $( '#wp-travel-amount' ).val(); // Added for partial payment.
        } else {
            o = "partial" == l ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price;
            if ( ! wt_parsley.isValid() ) {
                return wt_parsley.validate();
            }
        }

        var booking_option = $('[name=wp_travel_booking_option]').val();
        if ( 'booking_with_payment' === booking_option ) {

            if( o < 10) {
                alert('Instamojo checkout does not accept amount less than 10.');
                return;
            }
            if ( 'INR' !== wp_travel.payment.currency_code ) {
                alert('Instamojo checkout only support INR.');
                return;
            }
            jQuery('.wp-travel-form-field.button-field').append('<i class="wt-icon wt-icon-spin wt-icon-spinner"></i>');
            
            var title = $('.entry-title').html() || 'Trip Book';

            data = {
                // currency: wp_travel.payment.currency_code,
                // currency_symbol: wp_travel.currency_symbol,
                // total_qty: 1,
                get:'actual_amount',
                instamojo_amount: o,
                for: title,
                first_name:jQuery('input[name^=wp_travel_fname_traveller]').val(),
                last_name: jQuery('input[name^=wp_travel_lname_traveller]').val(),
                email: jQuery('[name^=wp_travel_email_traveller]').val(),
                phone: jQuery('[name^=wp_travel_phone_traveller]').val()
            };
            // var handle = wp_travel_stripe_handler(data); 
            fetch(wp_travel.ajaxUrl + "?action=inventory_testing&_nonce="+wp_travel._nonce, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                  wp_travel_trip:
                    (typeof wp_travel.items != "undefined" && wp_travel.items) || Array(),
                  nonce: wp_travel.nonce,
                }),
            }).then(function (resp) {
                resp.json().then((responces) => {
                    
                    if (responces.success == true) {
                        if (
                        typeof responces.data != "undefined" &&
                        typeof responces.data.code != "undefined" &&
                        typeof responces.data.inventory_available != "undefined" &&
                        responces.data.code == "WP_TRAVEL_INVENTORY_TESTING" &&
                        responces.data.inventory_available == "no_pax"
                        ) {
                        if (confirm("Sorry your booking can't proceed, booking is full.")) {
                            fetch(
                            wp_travel.ajaxUrl + "?action=wp_travel_use_inventory_empty_cart"+ wp_travel._nonce,
                            {
                                method: "POST",
                                headers: { "Content-Type": "application/json" },
                                body: JSON.stringify({
                                wp_travel_empty_cart:
                                    (typeof wp_travel.items != "undefined" && wp_travel.items) ||
                                    Array(),
                                }),
                            }
                            ).then((results) =>
                            results.json().then((resu) => {
                                location.reload();
                            })
                            );
                        }
                        } else {
                         
                            jQuery.get('', data ).then(function(response){ 
       
                                if ( response.success && response.payment_request && ( $url = response.payment_request.longurl) ){
                                  
                                    Instamojo.configure({
                                        handlers: {
                                            onOpen: function() {
                                                jQuery('i.wt-icon.wt-icon-spinner').remove();
                                            },
                                            onClose: function() {
                                                jQuery('i.wt-icon.wt-icon-spinner').remove();
                                            },
                                            onSuccess: function(r) {
                                                complete(r, response);
                                            },
                                            onFailure: function(response) {
                                                alert('Payment cancelled.')
                                                Instamojo.close();
                                            }
                                        }
                                    });
                                    Instamojo.open($url); 
                                } else {
                                    jQuery('i.wt-icon.wt-icon-spinner').remove();
                                    alert(typeof response.message == 'string' ? response.message : 'Something went wrong.' );
                                }
                            });
                        }
                    } else {
                       
                        jQuery.get('', data ).then(function(response){
                            if ( response.success && response.payment_request && ( $url = response.payment_request.longurl) ){
                                Instamojo.configure({
                                    handlers: {
                                        onOpen: function() {
                                            jQuery('i.wt-icon.wt-icon-spinner').remove();
                                        },
                                        onClose: function() {
                                            jQuery('i.wt-icon.wt-icon-spinner').remove();
                                        },
                                        onSuccess: function(r) {
                                            complete(r, response);
                                        },
                                        onFailure: function(response) {
                                            alert('Payment cancelled.')
                                            Instamojo.close();
                                        }
                                    }
                                });
                                Instamojo.open($url); 
                            } else {
                                jQuery('i.wt-icon.wt-icon-spinner').remove();
                                alert(typeof response.message == 'string' ? response.message : 'Something went wrong.' );
                            }
                        });
                    }
                });
            });
              
        }
    }

    var instamojo_checkout = function(){
        instamojo_remove();
        var payment_gateway = jQuery('input[name=wp_travel_payment_gateway]:checked').val()
        var booking_option = jQuery('[name=wp_travel_booking_option]').val();

        if ( 'instamojo_checkout' === payment_gateway && 'booking_with_payment' === booking_option ) {
            jQuery("#wp-travel-book-now, #wp-travel-complete-partial-payment").show().siblings().hide();
            jQuery(".paypal-button").remove();
            jQuery('[name=wp_travel_book_now], [name=complete_partial_payment]').click(instamojo_trigger);
        }
    }

    var instamojo_remove = function(){
        jQuery('[name=wp_travel_book_now]').off('click',instamojo_trigger);
        jQuery('[name=complete_partial_payment]').off('click',instamojo_trigger);
    }


    jQuery(document).on( 'change', '[name=wp_travel_booking_option]', function() {
        instamojo_checkout();
    });
    jQuery(document).on('change', '[name=wp_travel_payment_gateway]', function(){
        if( jQuery('[name=wp_travel_payment_gateway]').length > 1  ) {
            instamojo_checkout();
        }
    });

    // Instamojo Checkout on load.    
    instamojo_checkout();
    // Parsley validation on load.
    $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();
});
