<?php
/**
 * Inventory Error Codes Helper Function.
 */

function wp_travel_inventory_error_codes( $codes, $args ) {
	// Inventory Exceed.
	$exceed_message = __( 'Inventory exceed.', 'wp-travel-pro' );
	$allowed        = isset( $args['allowed'] ) ? (int) $args['allowed'] : 0;
	$entered        = isset( $args['entered'] ) ? (int) $args['entered'] : 0;

	if ( $allowed > 0 && $entered > 0 ) {
		$exceed_message .= sprintf( ' Allowed %d and entered %d.', $allowed, $entered );
	}
	$codes['WP_TRAVEL_INVENTORY_EXCEED'] = array( 'message' => $exceed_message );

	// Invntory Full.
	$codes['WP_TRAVEL_INVENTORY_FULL'] = array( 'message' => __( 'Inventory full.', 'wp-travel-pro' ) );

	$codes['WP_TRAVEL_INVENTORY_NOT_ENABLED'] = array( 'message' => __( 'Inventory not enabled.', 'wp-travel-pro' ) );

	return $codes;

}
 add_filter( 'wp_travel_error_codes', 'wp_travel_inventory_error_codes', 50, 2 );
