<?php
/**
 * Payment default client email template.
 *
 * @return HTML
 */
function wp_travel_invoice_client_default_email_content() {
	ob_start();
	?>
	<table class="wp-travel-wrapper" width="100%" cellpadding="0" cellspacing="0" style="color: #5d5d5d;font-family: Roboto, sans-serif;margin: auto;">
		<tr class="wp-travel-content" style="background: #fff;">
			<td colspan="2" align="left" class="wp-travel-content-top" style="background: #fff;box-sizing: border-box;margin: 0;padding: 20px 25px;">
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Dear', 'wp-travel-pro' ); ?> {customer_name},</p>
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Greetings from {sitename}.', 'wp-travel-pro' ); ?></p>
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Please find attached electronic invoice against your payment for the trips.', 'wp-travel-pro' ); ?></p>
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'If you have any query, please contact our account section or write to us at email.', 'wp-travel-pro' ); ?></p>
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Thank you for your business.', 'wp-travel-pro' ); ?></p>
				<br>
				<p style="line-height: 1.55;font-size: 14px;"><?php esc_html_e( 'Best Regards,', 'wp-travel-pro' ); ?></p>
				<p style="line-height: 1.55;font-size: 14px;">{sitename}.</p>
			</td>
		</tr>
	</table>
	<?php
	$content = ob_get_contents();
	ob_end_clean();
	return $content;
}

/**
 * Email Template Data for partial payment.
 *
 * @param array  $email_data Array of email data.
 * @param string $type       Type of email template(partial payment).
 * @param string $sent_to    Send to client or admin.
 * @return array
 */
function wp_travel_invoice_email_template( $email_data, $type, $sent_to ) {
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}

	if ( 'invoice' === $type ) {
		if ( 'client' === $sent_to ) {
			// Set Headings.
			$email_data['header_details'] = array(
				'header_title' => isset( $settings['invoice_client_template']['client_title'] ) && '' !== $settings['invoice_client_template']['client_title'] ? $settings['invoice_client_template']['client_title'] : __( 'Partial Payment Recieved', 'wp-travel-pro' ),
				'header_color' => isset( $settings['invoice_client_template']['client_header_color'] ) && '' !== $settings['invoice_client_template']['client_header_color'] ? $settings['invoice_client_template']['client_header_color'] : '#dd402e',
			);

			$email_data['subject'] = isset( $settings['invoice_client_template']['client_subject'] ) && '' !== $settings['invoice_client_template']['client_subject'] ? $settings['invoice_client_template']['client_subject'] : __( 'Partial Payment Recieved.', 'wp-travel-pro' );
			// Set Contents.
			$email_data['email_content'] = isset( $settings['invoice_client_template']['email_content'] ) && '' !== $settings['invoice_client_template']['email_content'] ? $settings['invoice_client_template']['email_content'] : wp_travel_invoice_client_default_email_content();
		}
	}
	return $email_data;
}

add_filter( 'wp_travel_email_template_type', 'wp_travel_invoice_email_template', 10, 3 );
