<?php

// Invoice Template : Default.

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! $booking_id ) {
	return;
}

$date_format = get_option( 'date_format' );
if ( function_exists( 'wptravel_booking_data' ) ) {
	$details = wptravel_booking_data( $booking_id );
} else {
	$details = wp_travel_booking_data( $booking_id );
}
$has_discount  = isset( $details['discount'] ) && $details['discount'] > 0;
$has_tax       = isset( $details['tax'] ) && $details['tax'] > 0;
$order_details = get_post_meta( $booking_id, 'order_items_data', true ); // Multiple Trips.

$wt_invoice_id = get_post_meta( $booking_id, 'wt_invoice_id', true );


$fname   = get_post_meta( $booking_id, 'wp_travel_fname_traveller', true );
$lname   = get_post_meta( $booking_id, 'wp_travel_lname_traveller', true );
$country = get_post_meta( $booking_id, 'wp_travel_country_traveller', true );
$phone   = get_post_meta( $booking_id, 'wp_travel_phone_traveller', true );
$email   = get_post_meta( $booking_id, 'wp_travel_email_traveller', true );

if ( function_exists( 'wptravel_get_settings' ) ) {
	$settings = wptravel_get_settings();
} else {
	$settings = wp_travel_get_settings();
}
$strings = array();
if( class_exists( 'WpTravel_Helpers_Strings') ) {
	$strings	= WpTravel_Helpers_Strings::get();
}

$use_relative_path = isset( $settings['use_relative_path'] ) ? $settings['use_relative_path'] : 'yes';
$invoice_logo      = isset( $settings['invoice_logo'] ) ? $settings['invoice_logo'] : '';
$invoice_address   = isset( $settings['invoice_address'] ) ? $settings['invoice_address'] : '';
$invoice_contact   = isset( $settings['invoice_contact'] ) ? $settings['invoice_contact'] : '';
$invoice_website   = isset( $settings['invoice_website'] ) ? $settings['invoice_website'] : '';

/**
 * string get
 */
$invoice_strings 	= isset( $strings['invoice' ] ) ? $strings['invoice'] : [];
$ivc_no 			= isset( $invoice_strings['invoice_number'] ) ? $invoice_strings['invoice_number'] : apply_filters( 'wp_invc_no', 'Invoice Number:' );
$ivc_date 			= isset( $invoice_strings['invoice_date'] ) ? $invoice_strings['invoice_date'] : apply_filters( 'wp_invc_date', 'Date' );
$customer_name_txt 		= isset( $invoice_strings['customer_name'] ) ? $invoice_strings['customer_name'] : apply_filters( 'wp_invc_cu_name', 'Customer Name:' );
$customer_phone 		= isset( $invoice_strings['phone'] ) ? $invoice_strings['phone'] : apply_filters( 'wp_invc_cu_name', 'Phone:' );
$customer_email_txt 	= isset( $invoice_strings['customer_email'] ) ? $invoice_strings['customer_email'] : apply_filters( 'wp_invc_cu_email', 'Customer Email:' );
$address 			= isset( $invoice_strings['address'] ) ? $invoice_strings['address'] : apply_filters( 'wp_invc_cu_address', 'Address:' );
$particular 		= isset( $invoice_strings['particular'] ) ? $invoice_strings['particular'] : apply_filters( 'wp_invc_particular', 'Particular' );
$price_txt 			= isset( $invoice_strings['price'] ) ? $invoice_strings['price'] : apply_filters( 'wp_invc_price', 'Price' );
$trip_pax_txt 		= isset( $invoice_strings['trip_pax'] ) ? $invoice_strings['trip_pax'] : apply_filters( 'wp_invc_trip_pax', 'Trip Tax' );
$trip_amount_txt 	= isset( $invoice_strings['trip_amount'] ) ? $invoice_strings['trip_amount'] : apply_filters( 'wp_invc_trip_amount', 'Trip Amount' );


$image_url = '';
if ( $invoice_logo ) {
	$image     = wp_get_attachment_image_src( $invoice_logo, 'thumbnail' );
	$image_url = $image[0];
	if ( 'yes' === $use_relative_path ) {
		$image_url = get_attached_file( $invoice_logo );
	}
}
if ( '' === $image_url ) {
	$image_url = wptravel_get_post_placeholder_image_url();
}
?>
	<!DOCTYPE html>
	<html <?php language_attributes(); ?>>
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta http-equiv="X-UA-Compatible" content="ie=edge">
		<title><?php echo esc_html( sprintf( __( 'Invoice : # %s', 'wp-travel-pro' ), $wt_invoice_id ) ); ?></title>
		<style>
			.page{
				height: 210mm;
				background-size:cover;
				padding:20px;
			}

			.page .header-info{
				border-bottom: 1px solid #ccc;
			}

			.page .header-info .site-identity{
				width: 200px;
				float: left;
			}

			.page .header-info .contact-info{
				padding-left: 300px;
				margin-top: -10px;
			}

			.page .header-info .contact-info p{
				margin: 0;
			}

			.invoice-details{
				margin-bottom: 25px;
			}

			.invoice-details .invoice-details{
				float: left;
				width: 300px;
			}

			.invoice-details .invoice-to{
				float: right;
				width: 300px;
			}

			table{
				width: 100%;
				background-color: #fafafa;
				border-spacing: 0;
			}

			tr th{
				background-color: green;
				color: #fff;
				padding: 10px;
				text-align: left;
				border: 0;
				text-transform:capitalize;
			}

			tr th.w-1{
				width: 150px;
			}
			tr td{
				padding: 10px;
				border-bottom: 1px solid #eee;
			}
			.text-right{
				text-align: right;
			}
			
		</style>
	</head>
	<body>
		<div class="page page-1">
			<div class="header-info">
				<div class="site-identity">
					<img src="<?php echo esc_url( $image_url ) ? esc_url( $image_url ) : $image_url; ?>" alt="">
				</div>
				<?php if ( $invoice_address || $invoice_contact || $invoice_website ) : ?>
					<div class="contact-info">
						<?php if ( $invoice_address ) : ?>
						<p><?php echo esc_attr( $invoice_address ); ?></p>
						<?php endif; ?>
						<?php if ( $invoice_contact ) : ?>
						<p><?php echo esc_attr( $invoice_contact ); ?></p>
						<?php endif; ?>
						<?php if ( $invoice_website ) : ?>
						<p><?php echo esc_attr( $invoice_website ); ?></p>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
			<div class="invoice-details">
				<div class="invoice-details">
					<p><strong><?php esc_html_e( $ivc_no, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $wt_invoice_id ); ?></p>
					<p><strong><?php esc_html_e( $ivc_date, 'wp-travel-pro' ); ?></strong> <?php echo get_the_time( $date_format, $booking_id ); ?></p>
				</div>
				<div class="invoice-to">
					<?php
					if ( is_array( $fname ) && count( $fname ) > 0 ) :
						foreach ( $fname as $cart_id => $first_names ) :
							if ( is_array( $first_names ) && count( $first_names ) > 0 ) :
								?>
									<p><strong><?php esc_html_e( $customer_name_txt, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $first_names[0] ); ?> <?php echo esc_html( $lname[ $cart_id ][0] ); ?></p>
									<p><strong><?php esc_html_e( $customer_email_txt, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $email[ $cart_id ][0] ); ?></p>
									<p><strong><?php esc_html_e( $address, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $country[ $cart_id ][0] ); ?></p>
									<p><strong><?php esc_html_e( $customer_phone, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $phone[ $cart_id ][0] ); ?></p>
									<?php
								endif;
							endforeach;
						else :
							?>
							<p><strong><?php esc_html_e( $customer_name_txt, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $fname ); ?> <?php echo esc_html( $lname ); ?></p>
							<p><strong><?php esc_html_e( $customer_email_txt, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $email ); ?></p>
							<p><strong><?php esc_html_e( $address, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $country ); ?></p>
							<p><strong><?php esc_html_e( $customer_phone, 'wp-travel-pro' ); ?></strong> <?php echo esc_html( $phone ); ?></p>
							<?php
						endif;
						?>
				</div>
			</div>
			<?php do_action( 'wp_travel_invoice_after_customer', $booking_id ); ?>
			<table cellspacing="0">
				<tr>
					<th><?php esc_html_e( $particular, 'wp-travel-pro' ); ?></th>
					<th><?php esc_html_e( $price_txt, 'wp-travel-pro' ); ?></th>
					<th><?php esc_html_e( $trip_pax_txt, 'wp-travel-pro' ); ?></th>
					<th class="w-1"><?php esc_html_e( $trip_amount_txt, 'wp-travel-pro' ); ?></th>
				</tr>
				<?php

				if ( $order_details ) { // Multiple Trips. Now from 1.8.3 it also included in single trip.
					$order_prices = get_post_meta( $booking_id, 'order_totals', true );

					foreach ( $order_details as $order_detail ) {

						if ( isset( $order_detail['trip'] ) ) { // @since 3.0.0.

							$trip_id   = $order_detail['trip_id'];
							$price_key = isset( $order_detail['price_key'] ) ? $order_detail['price_key'] : '';

							$trip_name = wptravel_get_trip_pricing_name( $trip_id, $price_key );
							if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
								$trip_price = wptravel_get_formated_price_currency( $order_detail['trip_price'] ); // Trip Total including all categories.
							} else {
								$trip_price = wp_travel_get_formated_price_currency( $order_detail['trip_price'] ); // Trip Total including all categories.
							}
							if ( ! empty( $order_detail['trip'] ) ) :
								?>
								<?php
								foreach ( $order_detail['trip'] as $category_id => $trip ) :
									$category_type = isset( $trip['type'] ) ? $trip['type'] : '';
									if ( 'custom' === $category_type && isset( $trip['type'] ) && ! empty( $trip['type'] ) ) {
										$category = $trip['custom_label'];
									} else {
										$category = wptravel_get_pricing_category_by_key( $category_type );
									}
									if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
										$price = wptravel_get_formated_price_currency( $trip['price'] );
									} else {
										$price = wp_travel_get_formated_price_currency( $trip['price'] );
									}
									$price_per = apply_filters( 'wp_travel_invoice_pdf_person', $trip['price_per'] );

									$trip_amount = $price;  // Individual price as per Trip category. // Default assume as group price.
									if ( 'group' !== $price_per ) {
										$trip_amount = $trip['price'] * $trip['pax'];

										if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
											$trip_amount = wptravel_get_formated_price_currency( $trip_amount );
										} else {
											$trip_amount = wp_travel_get_formated_price_currency( $trip_amount );
										}
									}
									
									if( !$trip['pax'] == '0' ):
									?>
										<tr>
											<td><?php echo esc_html( $trip_name ); ?> ( <?php echo esc_html( $category ); ?> )</td>
											<td><?php echo $price; ?>/ <?php echo esc_html( $price_per ); ?></td>
											<td><?php echo esc_html( $trip['pax'] ); ?></td>
											<td><?php echo $trip_amount; ?></td>
										</tr>

									<?php
									endif;
									endforeach;
								?>
									<?php
								endif;

							$total = $order_detail['trip_price'];
						}
						$order_detail['trip_extras'] = isset( $order_detail['trip_extras'] ) ? (array) $order_detail['trip_extras'] : array();
						if ( isset( $order_detail['trip_extras'] ) && isset( $order_detail['trip_extras']['id'] ) && count( $order_detail['trip_extras']['id'] ) > 0 ) :
							$extras = $order_detail['trip_extras'];
							?>
							<tr>
								<td colspan="4" ><h4><?php esc_html_e( 'Additional Services', 'wp-travel-pro' ); ?></h4></td>
							</tr>
							<?php
							foreach ( $order_detail['trip_extras']['id'] as $k => $extra_id ) :
								$trip_extras_data = get_post_meta( $extra_id, 'wp_travel_tour_extras_metas', true );

								$price      = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price'] : false;
								$sale_price = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price'] : false;

								if ( $sale_price ) {
									$price = $sale_price;
								}
								$price = WpTravel_Helpers_Trip_Pricing_Categories::get_converted_price( $price );

								$qty = isset( $extras['qty'][ $k ] ) && $extras['qty'][ $k ] ? $extras['qty'][ $k ] : 1;

								$total = $price * $qty;
								?>
									<tr>
										<td><?php echo esc_html( get_the_title( $extra_id ) ); ?></td>
										<td>
										<?php
										if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
											echo wptravel_get_formated_price_currency( $price, false, '', $booking_id );
										} else {
											echo wp_travel_get_formated_price_currency( $price, false, '', $booking_id );
										}
										?>
										</td>
										<td><?php echo esc_attr( $qty ); ?></td>
										<td>
										<?php
										if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
											echo wptravel_get_formated_price_currency( $total, false, '', $booking_id );
										} else {
											echo wp_travel_get_formated_price_currency( $total, false, '', $booking_id );
										}
										?>
										</td>
									</tr>
								<?php
							endforeach;
							?>
							<?php
						endif;
					}
					?>
					<?php
				} else { // single Trips.
					?>
					<tr>
						<td><?php echo esc_html( get_the_title( $trip_id ) ); ?></td>
						<td></td>
						<td><?php echo esc_html( $pax ); ?> </td>
						<td>
						<?php
						if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
							echo wptravel_get_formated_price_currency( $details['sub_total'], false, '', $booking_id );
						} else {
							echo wp_travel_get_formated_price_currency( $details['sub_total'], false, '', $booking_id );
						}
						?>
						</td>
					</tr>
					<?php
				}
				?>
				<!-- <tr>
					<td colspan="4"><hr></td>
				</tr> -->
				<?php if ( $has_discount || $has_tax ) : ?>
					<tr>
						<td colspan="3" class="text-right" ><?php esc_html_e( 'Gross total', 'wp-travel-pro' ); ?></td>
						<td>
						<?php
						if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
							echo wptravel_get_formated_price_currency( $details['sub_total'], false, '', $booking_id );
						} else {
							echo wp_travel_get_formated_price_currency( $details['sub_total'], false, '', $booking_id );
						}
						?>
						</td>
					</tr>
				<?php endif; ?>
				<?php if ( $has_discount ) : ?>
					<tr>
						<td colspan="3" class="text-right" ><?php esc_html_e( 'Discount', 'wp-travel-pro' ); ?></td>
						<td>-
						<?php
						if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
							echo wptravel_get_formated_price_currency( $details['discount'], false, '', $booking_id );
						} else {
							echo wp_travel_get_formated_price_currency( $details['discount'], false, '', $booking_id );
						}
						?>
						</td>
					</tr>
				<?php endif; ?>
				<?php if ( $has_tax ) : ?>
					<tr>
						<td colspan="3" class="text-right" ><?php esc_html_e( ! empty( $strings ) ? $strings['bookings']['price_tax'] : 'Tax', 'wp-travel-pro' ); ?></td>
						<td>
						<?php
						if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
							echo wptravel_get_formated_price_currency( $details['tax'], false, '', $booking_id );
						} else {
							echo wp_travel_get_formated_price_currency( $details['tax'], false, '', $booking_id );
						}
						?>
						</td>
					</tr>
				<?php endif; ?>
				<tr>
					<td colspan="3" class="text-right" ><?php esc_html_e( 'Net total', 'wp-travel-pro' ); ?></td>
					<td>
					<?php
					if ( function_exists( 'wptravel_get_formated_price_currency' ) ) {
						echo wptravel_get_formated_price_currency( $details['total'], false, '', $booking_id );
					} else {
						echo wp_travel_get_formated_price_currency( $details['total'], false, '', $booking_id );
					}

					?>
					</td>
				</tr>
				
			</table>
			<?php do_action( 'wp_travel_invoice_after_trip_details', $booking_id ); ?>
			<?php wptravel_view_payment_details_table( $booking_id ); ?>
		</div> <!-- /Page 1 -->
	</body>
	</html>
