<?php
/**
 * Functions.
 *
 * @package wp-travel-khalti/inc/admin/
 */

 /**
  * Khalti Settings HTML.
  *
  * @param Array $args Arguments.
  */
function wp_travel_settings_khalti( $args ) {
	if ( ! $args ) {
		return;
	}
	$payment_option_khalti = ( isset( $args['settings']['payment_option_khalti'] ) ) ? $args['settings']['payment_option_khalti'] : '';

	$test_publishable_key = ( isset( $args['settings']['khalti_test_publishable_key'] ) ) ? $args['settings']['khalti_test_publishable_key'] : '';
	$test_secret_key      = ( isset( $args['settings']['khalti_test_secret_key'] ) ) ? $args['settings']['khalti_test_secret_key'] : '';
	$publishable_key      = ( isset( $args['settings']['khalti_publishable_key'] ) ) ? $args['settings']['khalti_publishable_key'] : '';
	$secret_key           = ( isset( $args['settings']['khalti_secret_key'] ) ) ? $args['settings']['khalti_secret_key'] : '';
	?>
	<table class="form-table">
		<tr >
			<th><label for="payment_option_khalti"><?php esc_html_e( 'Enable Khalti', 'wp-travel-pro' ); ?></label></th>
			<td>
				<label for="payment_option_khalti">
					<span class="show-in-frontend checkbox-default-design">
						<label data-on="ON" data-off="OFF">
						<input type="checkbox" value="yes" <?php checked( 'yes', $payment_option_khalti ); ?> name="payment_option_khalti" id="payment_option_khalti" class="enable-payment-gateway" />
							<span class="switch">
							</span>
						</label>
					</span>
					<p class="description"><?php esc_html_e( 'Check to enable Khalti.', 'wp-travel-pro' ); ?></p>
				</label>
			</td>
		</tr>
		
		<tbody class="payment-gateway-fields khalti_tbody">
			
			<tr>
			<th><label for="khalti_test_publishable_key"><?php esc_html_e( 'Test Public Key', 'wp-travel-pro' ); ?></label></th>
			<td>
				<input type="password" value="<?php echo esc_attr( $test_publishable_key ); ?>" name="khalti_test_publishable_key" id="khalti_test_publishable_key"/>
			</td>
		</tr>
		<tr>
			<th><label for="khalti_test_secret_key"><?php esc_html_e( 'Test Secret Key', 'wp-travel-pro' ); ?></label></th>
			<td>
				<input type="password" value="<?php echo esc_attr( $test_secret_key ); ?>" name="khalti_test_secret_key" id="khalti_test_secret_key"/>
			</td>
		</tr>
		<tr>
			<th><label for="khalti_publishable_key"><?php esc_html_e( 'Live Public Key', 'wp-travel-pro' ); ?></label></th>
			<td>
				<input type="password" value="<?php echo esc_attr( $publishable_key ); ?>" name="khalti_publishable_key" id="khalti_publishable_key"/>
			</td>
		</tr>
		<tr>
			<th><label for="khalti_secret_key"><?php esc_html_e( 'Live Secret Key', 'wp-travel-pro' ); ?></label></th>
			<td>
				<input type="password" value="<?php echo esc_attr( $secret_key ); ?>" name="khalti_secret_key" id="khalti_secret_key"/>
			</td>

		</tr>
		</tbody>
		
	</table>
	<?php
}

add_action( 'wp_travel_payment_gateway_fields_khalti', 'wp_travel_settings_khalti' );
// add_action( 'wp_travel_payment_gateway_fields', 'wp_travel_settings_khalti' );

/**
 * Save Settings.
 *
 * @param Array $settings Settings array.
 * @param Array $settings_data Settings data array.
 */
function wp_travel_settings_khalti_savev4( $settings, $settings_data ) {
	if ( ! $settings ) {
		return;
	}
	$payment_option_khalti = ( isset( $settings_data['payment_option_khalti'] ) && '' !== $settings_data['payment_option_khalti'] ) ? $settings_data['payment_option_khalti'] : '';

	$khalti_test_publishable_key = ( isset( $settings_data['khalti_test_publishable_key'] ) && '' !== $settings_data['khalti_test_publishable_key'] ) ? $settings_data['khalti_test_publishable_key'] : '';
	$khalti_test_secret_key      = ( isset( $settings_data['khalti_test_secret_key'] ) && '' !== $settings_data['khalti_test_secret_key'] ) ? $settings_data['khalti_test_secret_key'] : '';
	$khalti_publishable_key      = ( isset( $settings_data['khalti_publishable_key'] ) && '' !== $settings_data['khalti_publishable_key'] ) ? $settings_data['khalti_publishable_key'] : '';
	$khalti_secret_key           = ( isset( $settings_data['khalti_secret_key'] ) && '' !== $settings_data['khalti_secret_key'] ) ? $settings_data['khalti_secret_key'] : '';

	$settings['payment_option_khalti']       = $payment_option_khalti;
	$settings['khalti_test_publishable_key'] = $khalti_test_publishable_key;
	$settings['khalti_test_secret_key']      = $khalti_test_secret_key;
	$settings['khalti_publishable_key']      = $khalti_publishable_key;
	$settings['khalti_secret_key']           = $khalti_secret_key;

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_settings_khalti_savev4', 10, 2 );

/**
 * Save Settings.
 *
 * @param Array $settings Settings array.
 */
function wp_travel_settings_khalti_save( $settings ) {
	if ( ! $settings ) {
		return;
	}
	$payment_option_khalti = ( isset( $_POST['payment_option_khalti'] ) && '' !== $_POST['payment_option_khalti'] ) ? $_POST['payment_option_khalti'] : '';

	$khalti_test_publishable_key = ( isset( $_POST['khalti_test_publishable_key'] ) && '' !== $_POST['khalti_test_publishable_key'] ) ? $_POST['khalti_test_publishable_key'] : '';
	$khalti_test_secret_key      = ( isset( $_POST['khalti_test_secret_key'] ) && '' !== $_POST['khalti_test_secret_key'] ) ? $_POST['khalti_test_secret_key'] : '';
	$khalti_publishable_key      = ( isset( $_POST['khalti_publishable_key'] ) && '' !== $_POST['khalti_publishable_key'] ) ? $_POST['khalti_publishable_key'] : '';
	$khalti_secret_key           = ( isset( $_POST['khalti_secret_key'] ) && '' !== $_POST['khalti_secret_key'] ) ? $_POST['khalti_secret_key'] : '';

	$settings['payment_option_khalti']       = $payment_option_khalti;
	$settings['khalti_test_publishable_key'] = $khalti_test_publishable_key;
	$settings['khalti_test_secret_key']      = $khalti_test_secret_key;
	$settings['khalti_publishable_key']      = $khalti_publishable_key;
	$settings['khalti_secret_key']           = $khalti_secret_key;

	return $settings;
}
add_filter( 'wp_travel_before_save_settings', 'wp_travel_settings_khalti_save' );
