<?php

class wp_travel_mailchimp_settings {

	private $mc_settings;

	private $message;

	public function __construct() {
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$settings = wptravel_get_settings();
		} else {
			$settings = wp_travel_get_settings();
		}
		$this->mc_settings = isset( $settings['mailchimp'] ) ? $settings['mailchimp'] : array();
		add_action( 'wp_travel_tabs_content_settings_misc_options_global', array( $this, 'add_settings' ), 25, 2 );
		add_filter( 'wp_travel_settings_fields', array( $this, 'settings_fields_v4' ) );
		add_filter( 'wp_travel_block_before_save_settings', array( $this, 'save_settings_v4' ), 2, 2 );
		add_filter( 'wp_travel_before_save_settings', array( $this, 'save_settings' ) );
		add_filter( 'wp_travel_settings_values', array( $this, 'settings_fields_value_v4' ) );
		add_filter( 'wp_travel_enquiries_form_fields', array( $this, 'add_enquiry_subscribe_field' ), 20 );
		add_filter( 'wp_travel_checkout_fields', array( $this, 'add_checkout_subscribe_field' ), 20 );
		add_action( 'wp_ajax_mc_lists', array( $this, 'get_mc_lists' ) );
	}

	public function get_mc_lists() {
		$mc_lists = array();
		$mc       = WP_Travel_MailChimp_Api::getInstance();
		if ( $mc instanceof WP_Travel_MailChimp_Api ) {
			try {
				$mc_lists = $mc->getLists( true );
			} catch ( MailChimp_WP_Travel_Error $e ) {
				$this->message = 'Message: ' . $e->getMessage();
			} catch ( MailChimp_WP_Travel_ServerError $e ) {
				$this->message = 'Message: ' . $e->getMessage();
			} catch ( Exception $e ) {
				$this->message = 'Message: ' . $e->getMessage();
			}
		} else {
			if ( ! isset( $this->mc_settings['api_key'] ) ) {
				$this->message = 'Message: No API Key.';
				return array();
			}
			$mc = new WP_Travel_Mailchimp_Api( $this->mc_settings['api_key'] );
			try {
				$mc_lists = $mc->getLists( true );
			} catch ( MailChimp_WP_Travel_Error $e ) {
				$this->message = 'Message: ' . $e->getMessage();
			} catch ( MailChimp_WP_Travel_ServerError $e ) {
				$this->message = 'Message: ' . $e->getMessage();
			} catch ( Exception $e ) {
				$this->message = 'Message: ' . $e->getMessage();
			}
		}
		if ( wp_doing_ajax() ) {
			if ( $this->message ) {
				wp_send_json_error( array( 'msg' => $this->message ) );
			}
			wp_send_json_success( array( 'lists' => $mc_lists ) );
		}
		return $mc_lists;
	}

	public function settings_fields_value_v4( $settings ) {
		$default_settings              = wptravel_settings_default_fields();
		$mailchimp_key                 = isset( $settings['mailchimp']['api_key'] ) && '' !== $settings['mailchimp']['api_key'] ? $settings['mailchimp']['api_key'] : $default_settings['mailchimp']['api_key'];
		$mailchimp_list_id             = isset( $settings['mailchimp']['list_id'] ) && '' !== $settings['mailchimp']['list_id'] ? $settings['mailchimp']['list_id'] : $default_settings['mailchimp']['list_id'];
		$mailchimp_opt_in              = isset( $settings['mailchimp']['opt_in'] ) && '' !== $settings['mailchimp']['opt_in'] ? $settings['mailchimp']['opt_in'] : $default_settings['mailchimp']['opt_in'];
		$mailchimp_subscribe_label     = isset( $settings['mailchimp']['subscribe_label'] ) && '' !== $settings['mailchimp']['subscribe_label'] ? $settings['mailchimp']['subscribe_label'] : $default_settings['mailchimp']['subscribe_label'];
		$mailchimp_subscribe_desc      = isset( $settings['mailchimp']['subscribe_desc'] ) && '' !== $settings['mailchimp']['subscribe_desc'] ? $settings['mailchimp']['subscribe_desc'] : $default_settings['mailchimp']['subscribe_desc'];
		$mailchimp_enable_subscription = isset( $settings['mailchimp']['enable_subscription'] ) && '' !== $settings['mailchimp']['enable_subscription'] ? $settings['mailchimp']['enable_subscription'] : $default_settings['mailchimp']['enable_subscription'];

		$settings['mailchimp']['api_key']             = $mailchimp_key;
		$settings['mailchimp']['list_id']             = $mailchimp_list_id;
		$settings['mailchimp']['opt_in']              = $mailchimp_opt_in;
		$settings['mailchimp']['subscribe_label']     = $mailchimp_subscribe_label;
		$settings['mailchimp']['subscribe_desc']      = $mailchimp_subscribe_desc;
		$settings['mailchimp']['enable_subscription'] = $mailchimp_enable_subscription;

		return $settings;
	}

	/**
	 * Settings Fields.
	 */
	public function settings_fields_v4( $args ) {
		$mailchimp_key                 = isset( $args['settings']['mailchimp']['api_key'] ) ? $args['settings']['mailchimp']['api_key'] : '';
		$mailchimp_list_id             = isset( $args['settings']['mailchimp']['list_id'] ) ? $args['settings']['mailchimp']['list_id'] : '';
		$mailchimp_opt_in              = isset( $args['settings']['mailchimp']['opt_in'] ) ? $args['settings']['mailchimp']['opt_in'] : 0;
		$mailchimp_subscribe_label     = ! empty( $args['settings']['mailchimp']['subscribe_label'] ) ? $args['settings']['mailchimp']['subscribe_label'] : _x( 'Subscribe', 'Mailchimp Subscribe Text', 'wp-travel-pro' );
		$mailchimp_subscribe_desc      = ! empty( $args['settings']['mailchimp']['subscribe_desc'] ) ? $args['settings']['mailchimp']['subscribe_desc'] : _x( 'Subscribe to our Newsletter and updates.', 'Mailchimp Subscribe Text', 'wp-travel-pro' );
		$mailchimp_enable_subscription = ! empty( $args['settings']['mailchimp']['enable_subscription'] ) ? $args['settings']['mailchimp']['enable_subscription'] : array( 'all' );

		$args['mailchimp']['api_key']             = $mailchimp_key;
		$args['mailchimp']['list_id']             = $mailchimp_list_id;
		$args['mailchimp']['opt_in']              = $mailchimp_opt_in;
		$args['mailchimp']['subscribe_label']     = $mailchimp_subscribe_label;
		$args['mailchimp']['subscribe_desc']      = $mailchimp_subscribe_desc;
		$args['mailchimp']['enable_subscription'] = $mailchimp_enable_subscription;

		return $args;
	}

	public function add_settings( $tab, $args ) {
		wp_enqueue_script( 'wp-travel-mailchimp-script' );
		if ( 'misc_options_global' !== $tab ) {
			return;
		}
		$mailchimp_key                 = isset( $args['settings']['mailchimp']['api_key'] ) ? $args['settings']['mailchimp']['api_key'] : '';
		$mailchimp_list_id             = isset( $args['settings']['mailchimp']['list_id'] ) ? $args['settings']['mailchimp']['list_id'] : '';
		$mailchimp_opt_in              = isset( $args['settings']['mailchimp']['opt_in'] ) ? $args['settings']['mailchimp']['opt_in'] : 0;
		$mailchimp_subscribe_label     = ! empty( $args['settings']['mailchimp']['subscribe_label'] ) ? $args['settings']['mailchimp']['subscribe_label'] : _x( 'Subscribe', 'Mailchimp Subscribe Text', 'wp-travel-pro' );
		$mailchimp_subscribe_desc      = ! empty( $args['settings']['mailchimp']['subscribe_desc'] ) ? $args['settings']['mailchimp']['subscribe_desc'] : _x( 'Subscribe to our Newsletter and updates.', 'Mailchimp Subscribe Text', 'wp-travel-pro' );
		$mailchimp_enable_subscription = ! empty( $args['settings']['mailchimp']['enable_subscription'] ) ? $args['settings']['mailchimp']['enable_subscription'] : array( 'all' );
		$mc_lists                      = $this->get_mc_lists();
		?>
		<h3><?php esc_html_e( 'Mailchimp Settings', 'wp-travel-pro' ); ?></h3>
		<table class="form-table">
			<tr>
				<th>
					<label for="mailchimp_api_key"><?php esc_html_e( 'API Key', 'wp-travel-pro' ); ?></label>
				</th>
				<td>
				<input type="text" id="mailchimp_api_key" name="mailchimp_api_key" value="<?php echo $mailchimp_key; ?>">
				<p class="description"><?php printf( __( 'Enter Mailchimp API Key. Learn more about %1$sMailchimp API Keys%2$s.', 'wp-travel-pro' ), '<a href="https://mailchimp.com/help/about-api-keys/" target="__blank">', '</a>' ); ?></p>
				</td>
			<tr>
			<tr>
				<th>
					<label for="mailchimp_list_id"><?php esc_html_e( 'Select List', 'wp-travel-pro' ); ?></label>
				</th>
				<td>
					<select name="mailchimp_list_id" id="mailchimp_list_id" class="wp-travel-select2" style="width:300px;">
						<?php
						echo '<option>' . __( 'Select List', 'wp-travel-pro' ) . '</option>';
						foreach ( $mc_lists as $k => $list ) {
							$selected = selected( $mailchimp_list_id, $k, false );
							echo "<option value=\"{$k}\" {$selected}>{$list}</option>";
						}
						?>
					</select>
					<span title="Refersh Lists" class="dashicons dashicons-image-rotate" id="mc_lists_loader" style="margin:5px 10px;font-size:15px;float:none;cursor:pointer;"></span>
					<?php if ( isset( $this->message ) ) : ?>
					<p style="color:red;"><?php echo $this->message; ?></p>
					<?php endif; ?>
				</td>
			<tr>
			<tr>
				<th>
					<label for="mailchimp_enable_subscription"><?php esc_html_e( 'Form', 'wp-travel-pro' ); ?></label>
				</th>
				<td>
					<select multiple name="mailchimp_enable_subscription[]" id="mailchimp_enable_subscription" class="wp-travel-select2" style="width:300px;">
						<?php
						$forms = array(
							'all'           => _x( 'All supported forms', 'Mailchimp Subscription Option', 'wp-travel-pro' ),
							'enquiry_form'  => _x( 'Enquiry Form', 'Mailchimp Subscription Option', 'wp-travel-pro' ),
							'checkout_form' => _x( 'Checkout Form', 'Mailchimp Subscription Option', 'wp-travel-pro' ),
						);
						foreach ( $forms as $key => $form ) {
							$selected = in_array( $key, $mailchimp_enable_subscription, true ) ? 'selected="selected"' : '';
							echo "<option value=\"{$key}\" {$selected}>{$form}</option>";
						}
						?>
					</select>
					<p class="description"><?php _e( 'Select WP Travel form you want collect email from.', 'wp-travel-pro' ); ?></p>
				</td>
			<tr>
			<tr>
				<th>
					<label for="mailchimp_opt_in"><?php esc_html_e( 'Opt-in', 'wp-travel-pro' ); ?></label>
				</th>
				<td>
				<span class="show-in-frontend checkbox-default-design">
					<label data-on="ON" data-off="OFF">
						<input type="checkbox" id="mailchimp_opt_in" name="mailchimp_opt_in" value="1" <?php checked( '1', $mailchimp_opt_in ); ?>>
						<span class="switch">
						</span>
					</label>
				</span>
				<p class="description"><?php printf( __( 'Enabling this option will enable the Mailchimp double opt-in option i.e sends contact an opt-in confirmation email when they subscribe. For details <a href="%1$s" target="new">%2$s</a>', 'wp-travel-pro' ), 'https://mailchimp.com/help/set-signup-preferences/', 'Choose Opt-In Settings' ); ?></p>
				</td>
			<tr>
			<tr class="mc_opt_in" style="display:<?php echo empty( checked( '1', $mailchimp_opt_in, false ) ) ? 'table-row' : 'none'; ?>">
				<th>
					<label for="mailchimp_subscribe_label"><?php esc_html_e( 'Subscribe Label', 'wp-travel-pro' ); ?></label>
				</th>
				<td>
				<input type="text" id="mailchimp_subscribe_label" name="mailchimp_subscribe_label" value="<?php echo esc_html( $mailchimp_subscribe_label ); ?>">
				<p class="description"><?php esc_html_e( 'This text will used as label to Opt-In checkbox.', 'wp-travel-pro' ); ?></p>
				</td>
			<tr>
			<tr class="mc_opt_in" style="display:<?php echo empty( checked( '1', $mailchimp_opt_in, false ) ) ? 'table-row' : 'none'; ?>">
				<th>
					<label for="mailchimp_subscribe_desc"><?php esc_html_e( 'Subscribe Description', 'wp-travel-pro' ); ?></label>
				</th>
				<td>
				<input type="text" id="mailchimp_subscribe_desc" name="mailchimp_subscribe_desc" value="<?php echo esc_html( $mailchimp_subscribe_desc ); ?>">
				<p class="description"><?php esc_html_e( 'You can tell why you want your customers to subscribe.', 'wp-travel-pro' ); ?></p>
				</td>
			<tr>
		</table>
		<?php
	}

	/**
	 * Adds Mailchimp Settings to WP Travel Settings.
	 *
	 * @param array $settings WP Travel Settings/
	 * @return void
	 */
	public function save_settings( $settings ) {
		$mailchimp_key                 = isset( $_POST['mailchimp_api_key'] ) ? $_POST['mailchimp_api_key'] : '';
		$mailchimp_list_id             = isset( $_POST['mailchimp_list_id'] ) ? $_POST['mailchimp_list_id'] : '';
		$mailchimp_opt_in              = isset( $_POST['mailchimp_opt_in'] ) ? $_POST['mailchimp_opt_in'] : 0;
		$mailchimp_subscribe_label     = isset( $_POST['mailchimp_subscribe_label'] ) ? stripslashes_deep( $_POST['mailchimp_subscribe_label'] ) : _x( 'Subscribe', 'Mailchimp Subscribe Label', 'wp-travel-pro' );
		$mailchimp_subscribe_desc      = isset( $_POST['mailchimp_subscribe_desc'] ) ? stripslashes_deep( $_POST['mailchimp_subscribe_desc'] ) : _x( 'Subscribe to our Newsletter and updates.', 'Mailchimp Subscribe Text', 'wp-travel-pro' );
		$mailchimp_enable_subscription = isset( $_POST['mailchimp_enable_subscription'] ) ? $_POST['mailchimp_enable_subscription'] : array( 'all' );

		$settings['mailchimp']['api_key']             = $mailchimp_key;
		$settings['mailchimp']['list_id']             = $mailchimp_list_id;
		$settings['mailchimp']['opt_in']              = $mailchimp_opt_in;
		$settings['mailchimp']['subscribe_label']     = $mailchimp_subscribe_label;
		$settings['mailchimp']['subscribe_desc']      = $mailchimp_subscribe_desc;
		$settings['mailchimp']['enable_subscription'] = $mailchimp_enable_subscription;
		return $settings;
	}

	/**
	 * Save v4 settings
	 */
	public function save_settings_v4( $settings, $settings_data ) {
		if ( isset( $settings_data['mailchimp']['api_key'] ) && '' !== ( $settings_data['mailchimp']['api_key'] ) ) {
			$settings['mailchimp']['api_key'] = stripslashes_deep( $settings_data['mailchimp']['api_key'] );
		}
		if ( isset( $settings_data['mailchimp']['list_id'] ) && '' !== ( $settings_data['mailchimp']['list_id'] ) ) {
			$settings['mailchimp']['list_id'] = stripslashes_deep( $settings_data['mailchimp']['list_id'] );
		}
		if ( isset( $settings_data['mailchimp']['opt_in'] ) && '' !== ( $settings_data['mailchimp']['opt_in'] ) ) {
			$settings['mailchimp']['opt_in'] = stripslashes_deep( $settings_data['mailchimp']['opt_in'] );
		}
		if ( isset( $settings_data['mailchimp']['subscribe_label'] ) && '' !== ( $settings_data['mailchimp']['subscribe_label'] ) ) {
			$settings['mailchimp']['subscribe_label'] = stripslashes_deep( $settings_data['mailchimp']['subscribe_label'] );
		}
		if ( isset( $settings_data['mailchimp']['subscribe_desc'] ) && '' !== ( $settings_data['mailchimp']['subscribe_desc'] ) ) {
			$settings['mailchimp']['subscribe_desc'] = stripslashes_deep( $settings_data['mailchimp']['subscribe_desc'] );
		}
		if ( isset( $settings_data['mailchimp']['enable_subscription'] ) && '' !== ( $settings_data['mailchimp']['enable_subscription'] ) ) {
			$settings['mailchimp']['enable_subscription'] = stripslashes_deep( $settings_data['mailchimp']['enable_subscription'] );
		}

		return $settings;
	}

	/**
	 * Undocumented function
	 *
	 * @param [type] $fields
	 * @return void
	 */
	private function subscribe_field( $form ) {
		$settings = $this->mc_settings;

		if ( isset( $settings['opt_in'] ) && '1' === $settings['opt_in'] ) {
			return false;
		}
		if ( empty( $settings['subscribe_label'] ) || empty( $settings['subscribe_desc'] ) ) {
			return false;
		}
		if ( isset( $settings['enable_subscription'] ) && ( in_array( $form, $settings['enable_subscription'], true ) || in_array( 'all', $settings['enable_subscription'], true ) ) ) {
			return array(
				'type'          => 'checkbox',
				'label'         => $settings['subscribe_label'],
				'name'          => 'wp_travel_subscribe',
				'id'            => 'wp-travel-subscribe',
				'options'       => array( 'subscribe' => $settings['subscribe_desc'] ),
				'priority'      => 450,
				'wrapper_class' => 'wp-travel-enquiry-subscribe-section',
			);
		}
	}

	public function add_enquiry_subscribe_field( $fields ) {

		$field = $this->subscribe_field( 'enquiry_form' );

		if ( $field ) {
			$fields['subscribe'] = $field;
		}
		return $fields;
	}

	public function add_checkout_subscribe_field( $fields ) {
		$field = $this->subscribe_field( 'checkout_form' );

		if ( $field ) {
			$fields['payment_fields']['subscribe'] = $field;
		}
		return $fields;
	}
}

/**
 * Mailchimp Settings Initialize.
 *
 * @since 1.0.5
 */
function mailchimp_settings_init() {
	new wp_travel_mailchimp_settings();
}

add_action( 'init', 'mailchimp_settings_init' );
