<?php
/**
 * Settings Helper.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



/**
 * Add additional options in the settings for partial payment.
 *
 * @param array $options Additional Options.
 * @param array $settings  All settings.
 * @since WP Travel 4.0.7
 */
function wp_travel_utilities_settings_options( $options, $settings ) {
	$options['has_partial_payment'] = true;
	$email_cycle_option             = array(
		array(
			'label' => __( 'Send email before 1 day', 'wp-travel-pro' ),
			'value' => 1,
		),
		array(
			'label' => __( 'Send email before 5 days', 'wp-travel-pro' ),
			'value' => 5,
		),
		array(
			'label' => __( 'Send email before 15 days', 'wp-travel-pro' ),
			'value' => 15,
		),
	);
	$email_cycle_option             = apply_filters( 'wptravel_partial_payment_reminder_email_cycle_option', $email_cycle_option );
	// Remaining Partial Payment Reminder Email Options.
	$options['email_cycle_option'] = $email_cycle_option;
	return $options;
}
add_filter( 'wp_travel_settings_options', 'wp_travel_utilities_settings_options', 15, 2 );

// for v4 settings. [Default]
add_filter( 'wp_travel_settings_fields', 'wp_travel_partial_payment_settingsv4_fields' );
/**
 * V4 settings fields.
 *
 * @param Array $settings Settings.
 * @return Array
 */
function wp_travel_partial_payment_settingsv4_fields( $settings ) {

	// Set Headings.
	$admin_email_data['admin_header_color'] = isset( $settings['partial_payment_admin_template']['admin_header_color'] ) && '' !== $settings['partial_payment_admin_template']['admin_header_color'] ? $settings['partial_payment_admin_template']['admin_header_color'] : '#dd402e';
	$admin_email_data['admin_title']        = isset( $settings['partial_payment_admin_template']['admin_title'] ) && '' !== $settings['partial_payment_admin_template']['admin_title'] ? $settings['partial_payment_admin_template']['admin_title'] : __( 'Partial Payment', 'wp-travel-pro' );
	$admin_email_data['admin_subject']      = isset( $settings['partial_payment_admin_template']['admin_subject'] ) && '' !== $settings['partial_payment_admin_template']['admin_subject'] ? $settings['partial_payment_admin_template']['admin_subject'] : __( 'Partial Payment', 'wp-travel-pro' );
	// Set Contents.
	$admin_email_data['email_content'] = isset( $settings['partial_payment_admin_template']['email_content'] ) && '' !== $settings['partial_payment_admin_template']['email_content'] ? $settings['partial_payment_admin_template']['email_content'] : wp_travel_partial_payment_admin_default_email_content();

	$settings['partial_payment_admin_template'] = $admin_email_data;

	// Set Headings.
	$client_email_data['client_title']        = isset( $settings['partial_payment_client_template']['client_title'] ) && '' !== $settings['partial_payment_client_template']['client_title'] ? $settings['partial_payment_client_template']['client_title'] : __( 'Partial Payment Received', 'wp-travel-pro' );
	$client_email_data['client_header_color'] = isset( $settings['partial_payment_client_template']['client_header_color'] ) && '' !== $settings['partial_payment_client_template']['client_header_color'] ? $settings['partial_payment_client_template']['client_header_color'] : '#dd402e';
	$client_email_data['client_subject']      = isset( $settings['partial_payment_client_template']['client_subject'] ) && '' !== $settings['partial_payment_client_template']['client_subject'] ? $settings['partial_payment_client_template']['client_subject'] : __( 'Partial Payment Received', 'wp-travel-pro' );
	// Set Contents.
	$client_email_data['email_content'] = isset( $settings['partial_payment_client_template']['email_content'] ) && '' !== $settings['partial_payment_client_template']['email_content'] ? $settings['partial_payment_client_template']['email_content'] : wp_travel_partial_payment_client_default_email_content();

	$settings['partial_payment_client_template'] = $client_email_data;

	// Remaining Partial Payment Reminder Email Options.
	$remaining_partial_payment_reminder['email_cycle']                         = isset( $settings['remaining_partial_payment_reminder']['email_cycle'] ) && '' !== $settings['remaining_partial_payment_reminder']['email_cycle'] ? $settings['remaining_partial_payment_reminder']['email_cycle'] : 'once_in_four_days';
	$remaining_partial_payment_reminder['send_remaining_payment_notification'] = isset( $settings['remaining_partial_payment_reminder']['send_remaining_payment_notification'] ) && '' !== $settings['remaining_partial_payment_reminder']['send_remaining_payment_notification'] ? $settings['remaining_partial_payment_reminder']['send_remaining_payment_notification'] : '';
	$remaining_partial_payment_reminder['reminder_title']                      = isset( $settings['remaining_partial_payment_reminder']['reminder_title'] ) && '' !== $settings['remaining_partial_payment_reminder']['reminder_title'] ? $settings['remaining_partial_payment_reminder']['reminder_title'] : __( 'Remaining Payment', 'wp-travel-pro' );
	$remaining_partial_payment_reminder['reminder_header_color']               = isset( $settings['remaining_partial_payment_reminder']['reminder_header_color'] ) && '' !== $settings['remaining_partial_payment_reminder']['reminder_header_color'] ? $settings['remaining_partial_payment_reminder']['reminder_header_color'] : '';
	$remaining_partial_payment_reminder['email_content']                       = isset( $settings['remaining_partial_payment_reminder']['email_content'] ) && '' !== $settings['remaining_partial_payment_reminder']['email_content'] ? $settings['remaining_partial_payment_reminder']['email_content'] : wp_travel_partial_payment_reminder_email_content();

	$settings['remaining_partial_payment_reminder'] = $remaining_partial_payment_reminder;

	return $settings;
};
