<?php
/**
 * Partial Payment Email Settings Functions.
 *
 * @package wp-travel-partial-payment/inc/admin/
 */



function wp_travel_partial_email_templates_settings_save( $settings ) {

	// Partial Payment Admin Email Settings.
	$partial_payment_admin_email_template_settings = ( isset( $_POST['partial_payment_admin_template'] ) && '' !== $_POST['partial_payment_admin_template'] ) ? stripslashes_deep( $_POST['partial_payment_admin_template'] ) : '';

	// Partial Payment Client Email Settings.
	$partial_payment_client_email_template_settings = ( isset( $_POST['partial_payment_client_template'] ) && '' !== $_POST['partial_payment_client_template'] ) ? stripslashes_deep( $_POST['partial_payment_client_template'] ) : '';

	// Remaining Partial Payment Reminder Email Options
	$remaining_partial_payment_reminder = ( isset( $_POST['remaining_partial_payment_reminder'] ) && '' !== $_POST['remaining_partial_payment_reminder'] ) ? stripslashes_deep( $_POST['remaining_partial_payment_reminder'] ) : '';

	$settings['partial_payment_admin_template']  = $partial_payment_admin_email_template_settings;
	$settings['partial_payment_client_template'] = $partial_payment_client_email_template_settings;

	$settings['remaining_partial_payment_reminder'] = $remaining_partial_payment_reminder;

	return $settings;
}
add_filter( 'wp_travel_before_save_settings', 'wp_travel_partial_email_templates_settings_save' );

/**
 * Save data for v4.
 */
function wp_travel_partial_email_templates_v4settings_save( $settings, $settings_data ) {

	// Partial Payment Admin Email Settings.
	if ( isset( $settings_data['partial_payment_admin_template'] ) && '' !== $settings_data['partial_payment_admin_template'] ) {
		$settings['partial_payment_admin_template'] = stripslashes_deep( $settings_data['partial_payment_admin_template'] );
	}

	// Partial Payment Client Email Settings.
	if ( isset( $settings_data['partial_payment_client_template'] ) && '' !== $settings_data['partial_payment_client_template'] ) {
		$settings['partial_payment_client_template'] = stripslashes_deep( $settings_data['partial_payment_client_template'] );
	}

	// Remaining Partial Payment Reminder Email Options.
	if ( isset( $settings_data['remaining_partial_payment_reminder'] ) && '' !== $settings_data['remaining_partial_payment_reminder'] ) {
		$settings['remaining_partial_payment_reminder'] = stripslashes_deep( $settings_data['remaining_partial_payment_reminder'] );
	}

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_partial_email_templates_v4settings_save', 12, 2 );




