<?php
/**
 * Settings class
 */


/**
 * WP_Travel_PayHere_Settings.
 */
class WP_Travel_PayHere_Settings {

	/**
	 * Default Settings.
	 *
	 * @var array
	 */
	private $default_settings;

	/**
	 * Instance.
	 *
	 * @var object
	 */
	protected static $_instance = null;

	/**
	 * Return Instance.
	 *
	 * @return object
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		self::$_instance        = $this;
		$this->default_settings = array(
			'payment_option_payhere' => 'no',
			'merchant_secret'        => '',
			'merchant_id'            => '',
			'passphrase'             => '',
		);
		add_filter( 'wp_travel_block_before_save_settings', array( $this, 'save_settings_v4' ), 12, 2 );
		add_filter( 'wp_travel_before_save_settings', array( $this, 'save_settings' ) );
	}

	/**
	 * Save Settings v4.
	 *
	 * @return void
	 */
	public function save_settings_V4( $settings, $settings_data ) {
		$defaults = $this->get_default_settings();
		if ( isset( $settings_data['wp_travel_payhere_settings'] ) ) {
			$payhere_settings = $settings_data['wp_travel_payhere_settings'];
			foreach ( $defaults as $key => $value ) {
				if ( isset( $payhere_settings[ $key ] ) ) {
					$settings['wp_travel_payhere_settings'][ $key ] = $payhere_settings[ $key ];
					if ( 'payment_option_payhere' === $key ) {
						$settings['payment_option_payhere'] = $payhere_settings[ $key ];
					}
					continue;
				}
				$settings['wp_travel_payhere_settings'][ $key ] = $value;
			}
		}
		if ( ! isset( $payhere_settings['payment_option_payhere'] ) ) {
			$settings['payment_option_payhere'] = 'no';
		}
		return $settings;
	}

	/**
	 * Save Settings.
	 *
	 * @return void
	 */
	public function save_settings( $settings ) {
		$defaults = $this->get_default_settings();
		if ( isset( $_POST['wp_travel_payhere_settings'] ) ) {
			$payhere_settings = $_POST['wp_travel_payhere_settings'];
			foreach ( $defaults as $key => $value ) {
				if ( isset( $payhere_settings[ $key ] ) ) {
					$settings['wp_travel_payhere_settings'][ $key ] = $payhere_settings[ $key ];
					if ( 'payment_option_payhere' === $key ) {
						$settings['payment_option_payhere'] = $payhere_settings[ $key ];
					}
					continue;
				}
				$settings['wp_travel_payhere_settings'][ $key ] = $value;
			}
		}
		if ( ! isset( $payhere_settings['payment_option_payhere'] ) ) {
			$settings['payment_option_payhere'] = 'no';
		}
		return $settings;
	}

	/**
	 * Settings.
	 *
	 * @return array
	 */
	public function get_settings() {
		$wp_travel_settings = array();
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$wp_travel_settings = wptravel_get_settings();
		}
		$settings = $this->get_default_settings();
		if ( isset( $wp_travel_settings['wp_travel_payhere_settings'] ) && is_array( $wp_travel_settings['wp_travel_payhere_settings'] ) ) {
			$settings = $this->parse_args( $wp_travel_settings['wp_travel_payhere_settings'] );
		}
		return $settings;
	}

	/**
	 * Parse Arguments.
	 *
	 * @param [type] $args
	 * @return void
	 */
	private function parse_args( $args ) {
		$defaults = $this->get_default_settings();
		return wp_parse_args( $args, $defaults );
	}

	/**
	 * Default Settings.
	 *
	 * @return void
	 */
	private function get_default_settings() {
		return $this->default_settings;
	}
}

new WP_Travel_PayHere_Settings();
