<?php
/**
 * Functions.
 *
 * @package wp-travel-paypal/inc/
 */

add_filter( 'wp_travel_payment_gateway_lists', 'wp_travel_payhere_gateway' );
/**
 * Add the Gateway.
 *
 * @param array $gateways Gateways List.
 */
function wp_travel_payhere_gateway( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['payhere'] = __( 'PayHere Checkout', 'wp-travel-pro' );
	return $gateways;
}

add_filter( 'wp_travel_premium_addons_list', 'wp_travel_payhere_addons' );
/**
 * Adds to addon List.
 *
 * @param array $addons Addons List.
 * @return array
 */
function wp_travel_payhere_addons( $addons ) {
	$addons['payhere'] = __( 'PayHere Checkout', 'wp-travel-pro' );
	return $addons;
}

add_action( 'wp_travel_payhere_verify_itn', 'wp_travel_payhere_verify_itn_cb' );
/**
 * PayHere ITN Verification Callback.
 *
 * @return void
 */
function wp_travel_payhere_verify_itn_cb() {
	header( 'HTTP/1.0 200 OK' );
	flush();
	$postdata        = array();
	$expected_params = array(
		'payhere_listener' => '',
		'merchant_id'      => '',
		'order_id'         => '',
		'payment_id'       => '',
		'payhere_amount'   => '',
		'payhere_currency' => '',
		'status_code'      => '',
		'md5sig'           => '',
		'custom_1'         => '',
		'custom_2'         => '',
		'status_message'   => '',
		'card_holder_name' => '',
		'card_no'          => '',
		'method'           => '',
		'recurring'        => '',
	);

	foreach ( $expected_params as $key => $value ) {
		if ( isset( $_POST[ $key ] ) ) {
			$postdata[ $key ] = wp_unslash( $_POST[ $key ] );
			continue;
		}
		$postdata[ $key ] = $value;
	}

	$params = wp_parse_args( $postdata, $expected_params );
	if ( function_exists( 'wptravel_get_settings' ) ) {
		$settings = wptravel_get_settings();
	} else {
		$settings = wp_travel_get_settings();
	}
	$merchant_secret   = ! empty( $wp_travel_settings['wp_travel_payhere_settings']['merchant_secret'] ) ? $wp_travel_settings['wp_travel_payhere_settings']['merchant_secret'] : '';
	extract( $params );
	$hash = strtoupper ( md5 ( $merchant_id . $order_id . $payhere_amount . $payhere_currency . $status_code . strtoupper( md5( $merchant_secret ) ) ) );

	if ( 2 === (int) $status_code ) {

		$payment_gateway = 'payhere';
		// Update booking status and Payment args.
		$booking_id = isset( $_POST['custom_1'] ) ? (int) $_POST['custom_1'] : 0;
		$payment_id = get_post_meta( $booking_id, 'wp_travel_payment_id', true );
		update_post_meta( $booking_id, 'wp_travel_booking_status', 'booked' );

		// get previous payment ids.
		$payhere_args = get_post_meta( $payment_id, '_payhere_args', true );

		// Update order as required
		if ( '' !== $payhere_args ) { // Partial Payment.
			if ( isset( $payhere_args['payment_id'] ) && $_POST['payment_id'] !== $payhere_args['payment_id'] ) :

				/**
				 * This will return the current payment id to insert payment meta for the current payment.
				 * 
				 * @hooked wptravel_update_payment_post from partial payment which will also update booking option [booking_only | booking_with_payment ]
				 *
				 * @since 4.0.2
				 */
				$new_payment_id = apply_filters( 'wptravel_before_insert_partial_payment', $payment_id, $booking_id, $payment_gateway );

				$detail         = $params;
				$amount         = $payhere_amount;
				wptravel_update_payment_status( $booking_id, $amount, 'paid', $detail, sprintf( '_%s_args', $payment_gateway ), $new_payment_id );
				do_action( 'wp_travel_payhere_checkout_clear_transient', $booking_id, $order_id );
			endif;
		} else { // New Payment.
			update_post_meta( $payment_id, '_payhere_args', $params );
			update_post_meta( $payment_id, 'wp_travel_payment_status', 'paid' );
			update_post_meta( $payment_id, 'wp_travel_payment_amount', $payhere_amount );
			do_action( 'wp_travel_after_successful_payment', $booking_id );
		}
	}
}

add_action( 'init', 'wp_travel_payhere_listen_itn' );
/**
 * Listen for a $_GET request from our PayPal IPN.
 * This would also do the "set-up" for an "alternate purchase verification"
 */
function wp_travel_payhere_listen_itn() {
	if ( isset( $_GET['payhere_listener'] )
		&& $_GET['payhere_listener'] == 'IPN'
		|| isset( $_GET['test'] )
		&& $_GET['test'] == true ) {
		do_action( 'wp_travel_payhere_verify_itn' );
	}
}
