import { addFilter } from '@wordpress/hooks'
import { useSelect, dispatch } from '@wordpress/data'
import { PanelRow, TextControl, ToggleControl } from '@wordpress/components'
import { __ } from '@wordpress/i18n'

/**
 * Adding PayU Content
 */
addFilter( 'wp_travel_payment_gateway_fields_payu', 'wp-travel', (content) => {
    return [ ...content, <PayUContent /> ]
});

const PayUContent = () => {

    /**
     * Get Store Settings.
     */
    const { updateSettings } = dispatch('WPTravel/Admin');

    const allData = useSelect( (select) => {
        return select('WPTravel/Admin').getAllStore()
    }, [] );

    const {
        wp_travel_payu_settings,
        wt_test_mode
    } = allData

    const updatePayUData = (storeName, storeKey, value) => { // storeName[storeKey] = value
        updateSettings({ ...allData, [storeName]: { ...allData[storeName], [storeKey]: value } })
    }

    const clientIdDesc = __('Please register <a href="https://registration.payu.com/" target="__blank">here</a> to get Merchant Account and credentials needed here.', 'wp-travel-pro');

    return (
        <>
            {
                wt_test_mode === 'yes' ?
                <strong><p className="howTo" style={{color: '#ffffff', textAlign: 'center', backgroundColor: 'darkseagreen'}} >{ __( 'Test Mode Active', 'wp-travel-pro' ) }</p></strong>
                : <strong><p className="howTo" style={{color: '#ffffff', textAlign: 'center', backgroundColor: 'darkseagreen'}} >{ __( 'Live Mode Active', 'wp-travel-pro' ) }</p></strong>
            }
            <PanelRow>
                <label>{ __( 'Enable PayU', 'wp-travel-pro' ) }</label>
                <div className="wp-travel-field-value">
                    <ToggleControl
                        checked={ wp_travel_payu_settings.payment_option_payu == 'yes' }
                        onChange={
                            (value) => {
                                updatePayUData( 'wp_travel_payu_settings', 'payment_option_payu', 'yes' == wp_travel_payu_settings.payment_option_payu ? 'no': 'yes' );
                            }
                        }
                    />
                    <p className="description">{__( 'Check to enable PayU Checkout.', 'wp-travel-pro' )}</p>
                </div>
            </PanelRow>

            {
                wp_travel_payu_settings.payment_option_payu === 'yes' &&
                <>
                    <PanelRow>
                        <label>{ __( 'Merchant POS ID', 'wp-travel-pro' ) }</label>
                            <div className="wp-travel-field-value">
                                <TextControl
                                    value={ 'undefined' !== typeof wp_travel_payu_settings.merchant_pos_id ? wp_travel_payu_settings.merchant_pos_id : '' }
                                    onChange={
                                        (value) => {
                                            updatePayUData( 'wp_travel_payu_settings', 'merchant_pos_id', value );
                                        }
                                    }
                                />
                                <p className="description" dangerouslySetInnerHTML={{ __html: clientIdDesc }}></p>
                            </div>
                    </PanelRow>

                    <PanelRow>
                        <label>{ __( 'Second Key (MD5)', 'wp-travel-pro' ) }</label>
                            <div className="wp-travel-field-value">
                                <TextControl
                                    value={ 'undefined' !== typeof wp_travel_payu_settings.second_key ? wp_travel_payu_settings.second_key : '' }
                                    onChange={
                                        (value) => {
                                            updatePayUData( 'wp_travel_payu_settings', 'second_key', value );
                                        }
                                    }
                                />
                            </div>
                    </PanelRow>

                    <PanelRow>
                        <label>{ __( 'Client ID', 'wp-travel-pro' ) }</label>
                            <div className="wp-travel-field-value">
                                <TextControl
                                    value={ 'undefined' !== typeof wp_travel_payu_settings.client_id ? wp_travel_payu_settings.client_id : '' }
                                    onChange={
                                        (value) => {
                                            updatePayUData( 'wp_travel_payu_settings', 'client_id', value );
                                        }
                                    }
                                />
                            </div>
                    </PanelRow>

                    <PanelRow>
                        <label>{ __( 'Client Secret', 'wp-travel-pro' ) }</label>
                            <div className="wp-travel-field-value">
                                <TextControl
                                    value={ 'undefined' !== typeof wp_travel_payu_settings.client_secret ? wp_travel_payu_settings.client_secret : '' }
                                    onChange={
                                        (value) => {
                                            updatePayUData( 'wp_travel_payu_settings', 'client_secret', value );
                                        }
                                    }
                                />
                            </div>
                    </PanelRow>

                </>
            }
        </>
    )
}