<?php


/**
 * Save settings of wp travel express checkout for v4
 *
 * @param array $settings List of settings.
 * @param array $settings_data List of settings data.
 */
function wp_travel_express_checkout_save_settingsv4( $settings, $settings_data ) {

	if ( ! $settings ) {
		return $settings;
	}
	foreach ( array( 'wp_travel_express_checkout_production', 'payment_option_express_checkout', 'wp_travel_express_checkout_sand_box', 'wp_travel_express_checkout' ) as $key ) {

		if ( isset( $settings_data[ $key ] ) ) {
			$settings[ $key ] = $settings_data[ $key ];
		}
	}

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_express_checkout_save_settingsv4', 10, 2 );

/**
 * Save settings of wp travel express checkout
 *
 * @param array $settings List of settings.
 */
function wp_travel_express_checkout_save_settings( $settings ) {

	if ( ! $settings ) {
		return $settings;
	}

	foreach ( array( 'wp_travel_express_checkout_production', 'payment_option_express_checkout', 'wp_travel_express_checkout_sand_box', 'wp_travel_express_checkout' ) as $key ) {

		if ( isset( $_POST[ $key ] ) ) {
			$settings[ $key ] = $_POST[ $key ];
		}
	}

	return $settings;
}
add_filter( 'wp_travel_before_save_settings', 'wp_travel_express_checkout_save_settings' );
