<?php
/**
 * Functions.
 *
 * @package wp-travel-paypal-express-checkout/inc/
 */


/**
 * Sum of amount of transaction.
 *
 * @param object $transaction A object of transaction.
 */
function wp_travel_sum_amounts( $transaction ) {
	if( apply_filters( 'wp_travel_use_paypal_sdk_v2', false ) == false ){
		return $transaction->amount->total;
	}else{
		return $transaction->amount->value;
	}
	
}


/**
 * Return Payment Gateway list.
 *
 * @param array $gateways Payment Gateways.
 */
function wp_travel_gateway_paypal_express_checkout( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['express_checkout'] = __( 'Paypal Express Checkout', 'wp-travel-pro' );
	return $gateways;
}

/**
 * Return Premium addons list.
 *
 * @param array $addons List of premium addons.
 */
function wp_travel_addons_paypal_express_checkout( $addons ) {
	$addons['express_checkout'] = __( 'Paypal Express Checkout', 'wp-travel-pro' );
	return $addons;
}

function wp_travel_add_vars_paypal_express_checkout( $args, $settings ) {
	if ( ! $args ) {
		return;
	}

	$vars = array();
	if ( isset( $settings['wp_travel_express_checkout'] ) ) {

		$vars = array_merge( $vars, $settings['wp_travel_express_checkout'] );
	}

	$locale = get_locale();

	$vars['locale'] = in_array( $locale, wp_travel_paypal_express_checkout_options( 'locales' ), true ) ? $locale : 'en_US';

	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	$vars['env'] = ! $test_mode ? 'production' : 'sandbox';

	$vars['sandbox_client_id']  = isset( $settings['wp_travel_express_checkout_sand_box']['client_id'] ) ? $settings['wp_travel_express_checkout_sand_box']['client_id'] : '';

	$vars['production_client_id']  = isset( $settings['wp_travel_express_checkout_production']['client_id'] ) ? $settings['wp_travel_express_checkout_production']['client_id'] : '';

	if ( count( $vars ) > 0 ) {
		$args['express_checkout'] = $vars;
	}
	return $args;
}
