<?php
/**
 * File Name: WP Travel PayPal Express Checkout Options
 *
 * @package  WP-Travel-Paypal-Express-Checkout
 * @category Core
 * @author   WenSolutions
 */

/**
 * Provide Express checkout button options
 *
 * @param string $key Get the representation of key.
 */
function wp_travel_paypal_express_checkout_options( $key ) {
	$options['locales'] = [
		'en_US',
		'en_AU',
		'en_GB',
		'fr_CA',
		'es_ES',
		'it_IT',
		'fr_FR',
		'de_DE',
		'pt_BR',
		'zh_CN',
		'da_DK',
		'zh_HK',
		'id_ID',
		'he_IL',
		'ja_JP',
		'nl_NL',
		'no_NO',
		'pl_PL',
		'pt_PT',
		'ru_RU',
		'sv_SE',
		'th_TH',
		'zh_TW',
	];

	$options['colors'] = [
		'gold' => 'Gold',
		'blue' => 'Blue',
		'silver' => 'Silver',
		'black' => 'Black',
	];

	$options['shape'] = [
		'rect' => 'Rectangle',
		'pill' => 'Pill',
	];

	$options['size'] = [
		'small' => 'Small',
		'medium' => 'Medium',
		'large' => 'Large',
		'responsive' => 'Responsive',
	];

	$options['label'] = [
		'checkout' => 'Checkout',
		'credit' => 'Credit',
		'pay' => 'Pay',
		'buynow' => 'Buy now',
		'paypal' => 'Paypal',
	];
	$options['layout'] = [
		'horizontal' => 'Horizontal',
		'vertical' => 'Vertical',
	];

	return array_key_exists( $key, $options ) ? $options[ $key ] : [];

}