<?php
/**
 * Functions.
 *
 * @package wp-travel-paypal/inc/
 */

// Functions.
/**
 * Return
 */
function wp_travel_gateway_paystack( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['paystack'] = __( 'Paystack Checkout', 'wp-travel-pro' );
	return $gateways;
}

function wp_travel_paystack_add_vars( $args, $settings ) {
	if ( ! $args ) {
		return;
	}
	$publishable_key = isset( $settings['paystack_public_key'] ) ? $settings['paystack_public_key'] : '';

	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	if ( $test_mode ) {
		$publishable_key = isset( $settings['paystack_test_public_key'] ) ? $settings['paystack_test_public_key'] : '';
	}

	$args['payment']['paystack_public_key'] = $publishable_key;
	return $args;
}

function wp_travel_paystack_addons( $addons ) {
	$addons['paystack'] = __( 'Paystack Checkout', 'wp-travel-pro' );
	return $addons;
}
