jQuery(function($){

	var parsley = $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();
	var supportedCurency = ['PLN']
	var isPayU = function(){
		return parsley.isValid() && $('[name=wp_travel_booking_option]').val() == 'booking_with_payment' && 'payu' === $('#wp-travel-payment-payu:checked').val()
	}

	$('#wp-travel-book-now').on('click', function(e){
		if(isPayU()){
			if ( supportedCurency.indexOf( wp_travel.payment.currency_code ) < 0 ) {
				e.preventDefault();
				alert('PayU checkout only support Polish złoty(PLN).');
				return;
			}
		}
	});
	// For Partial Payment.
	$('#wp-travel-complete-partial-payment').on('click', function(e){
		var isPayU = $('[name=wp_travel_booking_option]').val() == 'booking_with_payment' && 'payu' === $('#wp-travel-payment-payu:checked').val()
		if(isPayU){
			if ( supportedCurency.indexOf( wp_travel.payment.currency_code ) < 0 ) {
				e.preventDefault();
				alert('PayU checkout only support Polish złoty(PLN).');
				return;
			}
		}
	});

	$('#wp-travel-booking').on('change keyup', function(){
		'payu' === $('#wp-travel-payment-payu:checked').val() && $('#wp-travel-book-now').show().siblings().hide();
	})

	var paymentForm = $('#wp_travel_payu_payment_form');
	paymentForm && paymentForm.find('input[type=submit]').click();
});
