<?php
/**
 * Settings class
 */

/**
 * WP_Travel_PayU_Settings.
 */
class WP_Travel_PayU_Settings {

	/**
	 * Default Settings.
	 *
	 * @var array
	 */
	private $default_settings;

	/**
	 * Instance.
	 *
	 * @var object
	 */
	protected static $_instance = null;

	/**
	 * Return Instance.
	 *
	 * @return object
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		self::$_instance        = $this;
		$this->default_settings = array(
			'payment_option_payu' => 'no',
			'merchant_pos_id'     => '',
			'second_key'       => '',
			'client_id'           => '',
			'client_secret'       => '',
		);

		add_filter( 'wp_travel_block_before_save_settings', array( $this, 'save_settings_v4' ), 12, 2 );
		add_filter( 'wp_travel_before_save_settings', array( $this, 'save_settings' ) );
	}

	/**
	 * Push Settings to WP Travel Settings v4 Array.
	 *
	 * @return array
	 */
	public function save_settings_v4( $settings, $settings_data ) {
		$defaults = $this->get_default_settings();
		if ( isset( $settings_data['wp_travel_payu_settings'] ) ) {
			$payu_settings = $settings_data['wp_travel_payu_settings'];
			foreach ( $defaults as $key => $value ) {
				if ( isset( $payu_settings[ $key ] ) ) {
					$settings['wp_travel_payu_settings'][ $key ] = $payu_settings[ $key ];
					if ( 'payment_option_payu' === $key ) {
						$settings['payment_option_payu'] = $payu_settings[ $key ];
					}
					continue;
				}
				$settings['wp_travel_payu_settings'][ $key ] = $value;
			}
		}
		if ( ! isset( $payu_settings['payment_option_payu'] ) ) {
			$settings['payment_option_payu'] = 'no';
		}
		return $settings;
	}

	/**
	 * Push Settings to WP Travel Settings Array.
	 *
	 * @return array
	 */
	public function save_settings( $settings ) {
		$defaults = $this->get_default_settings();
		if ( isset( $_POST['wp_travel_payu_settings'] ) ) {
			$payu_settings = $_POST['wp_travel_payu_settings'];
			foreach ( $defaults as $key => $value ) {
				if ( isset( $payu_settings[ $key ] ) ) {
					$settings['wp_travel_payu_settings'][ $key ] = $payu_settings[ $key ];
					if ( 'payment_option_payu' === $key ) {
						$settings['payment_option_payu'] = $payu_settings[ $key ];
					}
					continue;
				}
				$settings['wp_travel_payu_settings'][ $key ] = $value;
			}
		}
		if ( ! isset( $payu_settings['payment_option_payu'] ) ) {
			$settings['payment_option_payu'] = 'no';
		}
		return $settings;
	}

	/**
	 * Gets Parsed addon Settings.
	 *
	 * @return array
	 */
	public function get_settings() {
		$wp_travel_settings = array();
		if ( function_exists( 'wptravel_get_settings' ) ) {
			$wp_travel_settings = wptravel_get_settings();
		}
		$settings = $this->get_default_settings();
		if ( isset( $wp_travel_settings['wp_travel_payu_settings'] ) && is_array( $wp_travel_settings['wp_travel_payu_settings'] ) ) {
			$settings = $this->parse_args( $wp_travel_settings['wp_travel_payu_settings'] );
		}
		return $settings;
	}

	/**
	 * Parse Arguments.
	 *
	 * @param array $args Arguments to Parse.
	 * @return array
	 */
	private function parse_args( $args ) {
		$defaults = $this->get_default_settings();
		return wp_parse_args( $args, $defaults );
	}

	/**
	 * Default Settings.
	 *
	 * @return array
	 */
	private function get_default_settings() {
		return $this->default_settings;
	}
}

new WP_Travel_PayU_Settings();
