<?php
/**
 * Functions.
 *
 * @package payu-chekcout-core/inc/
 */

 /**
  * Config Payment.
  *
  * @return void
  */
function wp_travel_payu_config() {
	// include_once plugin_dir_path( __FILE__ ) . 'vendors/openpayu_php/lib/OpenPayU.php';
	$settings_instance = WP_Travel_PayU_Settings::instance();
	$settings          = $settings_instance->get_settings();

	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	$env               = $test_mode ? 'sandbox' : 'secure';

	extract( $settings );

	// set Environment.
	OpenPayU_Configuration::setEnvironment( $env );

	// set POS ID and Second MD5 Key (from merchant admin panel).
	OpenPayU_Configuration::setMerchantPosId( $merchant_pos_id ); // POS ID (pos_id) / OAuth protocol - client_id.
	OpenPayU_Configuration::setSignatureKey( $second_key ); // Second key (MD5).

	// set Oauth Client Id and Oauth Client Secret (from merchant admin panel).
	OpenPayU_Configuration::setOauthClientId( $client_id ); // OAuth protocol - client_id / POS ID (pos_id).
	OpenPayU_Configuration::setOauthClientSecret( $client_secret ); // Key (MD5) / OAuth protocol - client_secret.
}

/**
 * Returns Client IP.
 *
 * @return string
 */
function wp_travel_payu_get_user_ip() {
	if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
		// IP from share internet.
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
		// IP pass from proxy.
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = $_SERVER['REMOTE_ADDR'];
	}
	$ip = preg_replace( '/^(\d{1,3}+\.\d{1,3}+\.\d{1,3}+\.\d{1,3}+).*/', '$1', $ip );
	return $ip;
}

add_filter( 'wp_travel_payment_gateway_lists', 'wp_travel_payu_gateway' );
/**
 * Add the Gateway.
 *
 * @param array $gateways Gateways List.
 */
function wp_travel_payu_gateway( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['payu'] = __( 'PayU Checkout', 'wp-travel-pro' );
	return $gateways;
}

add_filter( 'wp_travel_premium_addons_list', 'wp_travel_payu_addons' );
/**
 * Adds to addon List.
 *
 * @param array $addons Addons List.
 * @return array
 */
function wp_travel_payu_addons( $addons ) {
	$addons['payu'] = __( 'PayU Checkout', 'wp-travel-pro' );
	return $addons;
}

/**
 * Converts JSON Data to Array.
 *
 * @param string  $data Json String.
 * @param boolean $assoc Assoc Format.
 * @return void
 */
function wp_travel_payu_convert_json2array( $data, $assoc = false ) {
	if ( empty( $data ) ) {
		return null;
	}

	return json_decode( $data, $assoc );
}

add_action( 'wp_travel_payu_verify_ipn', 'wp_travel_payu_verify_ipn_cb' );
/**
 * PayU ITN Verification Callback.
 *
 * @return void
 */
function wp_travel_payu_verify_ipn_cb() {

	if ( 'POST' === $_SERVER['REQUEST_METHOD'] ) {
		$body = file_get_contents( 'php://input' );
		$data = trim( $body );

		wp_travel_payu_config();

		$response = OpenPayU_Order::verifyResponse(
			array(
				'response' => $data,
				'code'     => 200,
			),
			'OrderNotifyRequest'
		);

		if ( ! property_exists( $response->getResponse(), 'refund' ) ) {
			$booking_id = (int) preg_replace( '/_.*$/', '', $response->getResponse()->order->extOrderId );
			$status     = $response->getResponse()->order->status;

			$data = wp_travel_payu_convert_json2array( $data, true );

			switch ( $status ) {
				case OpenPayuOrderStatus::STATUS_COMPLETED:
					$payment_gateway = 'payu';
					$payment_id      = get_post_meta( $booking_id, 'wp_travel_payment_id', true );
					update_post_meta( $booking_id, 'wp_travel_booking_status', 'booked' );
					// get previous payment ids .
					$payu_args = get_post_meta( $payment_id, '_payu_args', true );
					if ( '' !== $payu_args ) { // Partial Payment.
						/**
						 * This will return the current payment id to insert payment meta for the current payment.
						 * 
						 * @hooked wptravel_update_payment_post from partial payment which will also update booking option [booking_only | booking_with_payment ]
						 *
						 * @since 4.0.2
						 */
						$new_payment_id = apply_filters( 'wptravel_before_insert_partial_payment', $payment_id, $booking_id, $payment_gateway );
						$amount         = (int) round( $data['order']['totalAmount'] / 100 );
						$detail         = $data['order'];
						wptravel_update_payment_status( $booking_id, $amount, 'paid', $detail, sprintf( '_%s_args', $payment_gateway ), $new_payment_id );
							// endif;
					} else { // New Payment.
						$payu_amount = (int) round( $data['order']['totalAmount'] / 100 );
						update_post_meta( $payment_id, '_payu_args', $data['order'] );
						update_post_meta( $payment_id, 'wp_travel_payment_status', 'paid' );
						update_post_meta( $payment_id, 'wp_travel_payment_amount', $payu_amount );
						global $wt_cart;
						$wt_cart->clear();
						do_action( 'wp_travel_after_successful_payment', $booking_id );
					}
					break;
			}
		}
		header( 'HTTP/1.0 200 OK' );
		flush();
	}
}

add_action( 'init', 'wp_travel_payu_listen_ipn' );
/**
 * Listen for a $_GET request from our PayPal IPN.
 * This would also do the "set-up" for an "alternate purchase verification"
 */
function wp_travel_payu_listen_ipn() {
	if ( isset( $_GET['payu_listener'] )
		&& $_GET['payu_listener'] == 'IPN'
		|| isset( $_GET['test'] )
		&& $_GET['test'] == true ) {
		do_action( 'wp_travel_payu_verify_ipn' );
	}
}
