<?php
/**
 * Functions.
 *
 * @package payu-latam-chekcout-core/inc/
 */

add_filter( 'wp_travel_payment_gateway_lists', 'wp_travel_payu_latam_gateway' );
/**
 * Add the Gateway.
 *
 * @param array $gateways Gateways List.
 */
function wp_travel_payu_latam_gateway( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['payu_latam'] = __( 'PayU Latam Checkout', 'wp-travel-pro' );
	return $gateways;
}

add_filter( 'wp_travel_premium_addons_list', 'wp_travel_payu_latam_addons' );
/**
 * Adds to addon List.
 *
 * @param array $addons Addons List.
 * @return array
 */
function wp_travel_payu_latam_addons( $addons ) {
	$addons['payu_latam'] = __( 'PayU Latam Checkout', 'wp-travel-pro' );
	return $addons;
}

add_action( 'init', 'wp_travel_payu_latam_listen_itn' );
/**
 * Listen for a $_GET request from our PayPal IPN.
 * This would also do the "set-up" for an "alternate purchase verification"
 */
function wp_travel_payu_latam_listen_itn() {
	if ( isset( $_GET['payu_latam_listener'] )
		&& $_GET['payu_latam_listener'] == 'ITN'
		|| isset( $_GET['test'] )
		&& $_GET['test'] == true ) {
		do_action( 'wp_travel_payu_latam_verify_itn' );
	}
}

add_action( 'wp_travel_payu_latam_verify_itn', 'wp_travel_payu_latam_verify_itn_cb' );
/**
 * PayU Latam ITN Verification Callback.
 *
 * @return void
 */
function wp_travel_payu_latam_verify_itn_cb() {
	header( 'HTTP/1.0 200 OK' );
	flush();

	if ( isset( $_REQUEST['state_pol'] ) && $_REQUEST['state_pol'] == '4' ) {
		$data           = $_REQUEST;
		$payment_method = 'payulatam';
		$booking_id     = isset( $data['extra2'] ) ? (int) $data['extra2'] : 0;
		$payment_id     = get_post_meta( $booking_id, 'wp_travel_payment_id', true );
		update_post_meta( $booking_id, 'wp_travel_booking_status', 'booked' );

		// get previous payment ids.
		$payulatam_args = get_post_meta( $payment_id, '_payu_latam_args', true );

		// Update order as required.
		if ( '' !== $payulatam_args ) { // Partial Payment.
			if ( isset( $payulatam_args['transaction_id'] ) && $data['transaction_id'] !== $payulatam_args['transaction_id'] ) :

				/**
				 * This will return the current payment id to insert payment meta for the current payment.
				 *
				 * @hooked wptravel_update_payment_post from partial payment which will also update booking option [booking_only | booking_with_payment ]
				 *
				 * @since 4.0.2
				 */
				$new_payment_id = apply_filters( 'wptravel_before_insert_partial_payment', $payment_id, $booking_id, $payment_gateway );

				$detail = $data;
				$amount = $data['value'];
				wptravel_update_payment_status( $booking_id, $amount, 'paid', $detail, sprintf( '_%s_args', $payment_method ), $new_payment_id );
				endif;
		} else { // New Payment.
			update_post_meta( $payment_id, '_payu_latam_args', $data );
			update_post_meta( $payment_id, 'wp_travel_payment_status', 'paid' );
			update_post_meta( $payment_id, 'wp_travel_payment_amount', $data['value'] );
			do_action( 'wp_travel_after_successful_payment', $booking_id );
		}
	}
	exit();
}
