<?php

function wptravel_trip_quick_view( $trip_id ){
?>
<div class="modal-overlay"></div>
<div class="wp-travel-quick-view">
    <span class="open-quick-view-modal"><i class="far fa-eye"></i> <?php echo esc_html__( "Quick View", 'wp-travel-pro' ) ?></span>
    <div class="wp-travel-quick-view-modal">
        <button class="close-modal"><i class="fas fa-times"></i></button>
        <div class="wp-travel trip-headline-wrapper clearfix">
                
            <div class="wp-travel-feature-slide-content featured-side-image left-plot">
                <div class="banner-image-wrapper" style="background-image: url(<?php echo esc_url( apply_filters( 'wp_travel_trip_single_page_thumbnail_background',  wptravel_get_post_thumbnail_url( $trip_id, 'large' ), $trip_id ) ); ?>)">
                        <?php echo wp_kses_post( apply_filters( 'wp_travel_trip_single_page_thumbnail', wp_kses( wptravel_get_post_thumbnail( $trip_id ), wptravel_allowed_html( array( 'img' ) ) ), $trip_id ) ); ?>
                </div>
            </div>
            <div class="wp-travel-feature-slide-content featured-detail-section right-plot">
                <div class="right-plot-inner-wrap">
                    <?php $show_title = apply_filters( 'wp_travel_show_single_page_title', true ); ?>
                    <?php if ( $show_title ) : ?>
                        <header class="entry-header">
                            <?php apply_filters( 'wp_travel_single_archive_trip_tilte', the_title( '<h1 class="entry-title">', '</h1>' ),  $trip_id ); ?>
                        </header>
                    <?php endif; ?>					
                    <?php wptravel_do_deprecated_action( 'wp_travel_after_single_title', array( $trip_id ), '2.0.4', 'wp_travel_single_trip_after_title' );  // @since 1.0.4 and deprecated in 2.0.4 ?>
                    <?php do_action( 'wp_travel_single_trip_after_title', $trip_id ); ?>
                    
                </div>
            </div>
            
        </div>
        <?php
			wptravel_frontend_trip_facts( $trip_id  );
            wptravel_frontend_contents( $trip_id );
		?>
    </div>
</div>
<?php
}