payments.razorpay_checkout = function(){
}

jQuery(document).ready(function($) {
    var complete = function (l, response ) {
        var form_id = 'wp-travel-booking'; // Default payment form id

        var payment_form_id = jQuery( '#wp-travel-payment-form-id' ).val();

        if ( payment_form_id ) {
            form_id = payment_form_id;
        }

        jQuery('.loader-active').show();
        razorpay_remove();
        setTimeout(function() {
            jQuery( '[name=payment_details]' ).remove();
            jQuery( 'form#' + form_id ).append(jQuery("<input type='hidden' name='payment_details' />").attr("value", JSON.stringify(Object.assign({},l,response))));
            jQuery( 'form#' + form_id ).find("[type=submit]").click();
        }, 2);
    };

    var razorpay_trigger = function(e){
        jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
        var wt_parsley = jQuery("#wp-travel-booking").parsley()
        e.preventDefault();
        var l = jQuery("#wp-travel-payment-mode option:selected").val(); //fix for partial payment.

        if ( $( '[name=complete_partial_payment]' ).length > 0 ) {
            o = $( '#wp-travel-amount' ).val(); // Added for partial payment.
        } else {
            o = "partial" == l ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price;
            if ( ! wt_parsley.isValid() ) {
                return wt_parsley.validate();
            }
        }
        o = parseInt( o*100 );
        var booking_option = $('[name=wp_travel_booking_option]').val();
        if ( 'booking_with_payment' === booking_option ) {

            if( o < 1000 ) {
                alert('Razorpay checkout does not accept amount less than 10.');
                return;
            }
            if ( 'INR' !== wp_travel.payment.currency_code ) {
                alert('Razorpay checkout only support INR.');
                return;
            }
            jQuery('.wp-travel-form-field.button-field').append('<i class="wt-icon wt-icon-spin wt-icon-spinner"></i>');
            var data = {
                "key": wp_travel.payment.razorpay_api_key,
                "amount": (o), // 2000 paise = INR 20
                "currency": 'INR',
                "name": [jQuery('[name^=wp_travel_fname]').val(), jQuery('[name^=wp_travel_lname]').val()].join(' '),
                "description": jQuery('.product-name').html(),
                // "image": "/your_logo.png",
                "handler": function(response) {
                    response.amount = o/100;
                    complete(response);
                    jQuery('.fa.fa-spin.fa-spinner').remove()
                },
                "prefill": {
                    "name": [jQuery('[name^=wp_travel_fname]').val(), jQuery('[name^=wp_travel_lname]').val()].join(' '),
                    "email": jQuery('[name^=wp_travel_email]').val(),
                    "contact" : jQuery('[name^=wp_travel_phone_traveller]').val()
                },
                "notes": {
                    "address": jQuery('[name=wp_travel_address]').val()
                },
                // "theme": {
                //     // "color": razor_pay.theme_color || '#000'
                //     "color": '#000'
                // }
            };
            fetch(wp_travel.ajaxUrl + "?action=inventory_testing&&_nonce="+wp_travel._nonce, {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                  wp_travel_trip:
                    (typeof wp_travel.items != "undefined" && wp_travel.items) || Array(),
                  nonce: wp_travel.nonce,
                }),
            }).then(function (resp) {
                resp.json().then((responces) => {
                    if (responces.success == true) {
                        if (
                            typeof responces.data != "undefined" &&
                            typeof responces.data.code != "undefined" &&
                            typeof responces.data.inventory_available != "undefined" &&
                            responces.data.code == "WP_TRAVEL_INVENTORY_TESTING" &&
                            responces.data.inventory_available == "no_pax"
                        ) {
                        if (confirm("Sorry your booking can't proceed, booking is full.")) {
                            fetch(
                            wp_travel.ajaxUrl + "?action=wp_travel_use_inventory_empty_cart"+ wp_travel._nonce,
                            {
                                method: "POST",
                                headers: { "Content-Type": "application/json" },
                                body: JSON.stringify({
                                wp_travel_empty_cart:
                                    (typeof wp_travel.items != "undefined" && wp_travel.items) ||
                                    Array(),
                                }),
                            }
                            ).then((results) =>
                            results.json().then((resu) => {
                                location.reload();
                            })
                            );
                        }
                        } else {
                            var orderData = {
                                action: 'create_razorpay_order', // Name of the action that will be handled by the server
                                amount: (o), // Example amount in paise (INR 10000)
                                currency: 'INR',
                                name: [jQuery('[name^=wp_travel_fname]').val(), jQuery('[name^=wp_travel_lname]').val()].join(' '),
                                email: jQuery('[name^=wp_travel_email]').val(),
                                contact : jQuery('[name^=wp_travel_phone_traveller]').val(),
                                address: jQuery('[name=wp_travel_address]').val()
                            };
                    
                            $.ajax({
                                url: wp_travel.ajaxUrl, // WordPress AJAX URL
                                type: 'POST',
                                data: orderData,
                                success: function(response) {
                                    // Handle the response from the server (Razorpay Order ID)
                                    if (response.success) {
                                        var order_id = response.data.order_id;
                                        
                                        data["order_id"] = order_id;

                                        var rzp1 = new Razorpay(data);
                                        rzp1.open();
                    
                          
                                    } else {
                                        console.error('Failed to create order:', response.message);
                                    }
                                },
                                error: function() {
                                    console.error('Error in AJAX request');
                                }
                            });
                            
                        }
                    } else {
                        var orderData = {
                            action: 'create_razorpay_order', // Name of the action that will be handled by the server
                            amount: (o), // Example amount in paise (INR 10000)
                            currency: 'INR',
                            name: [jQuery('[name^=wp_travel_fname]').val(), jQuery('[name^=wp_travel_lname]').val()].join(' '),
                            email: jQuery('[name^=wp_travel_email]').val(),
                            contact : jQuery('[name^=wp_travel_phone_traveller]').val(),
                            address: jQuery('[name=wp_travel_address]').val()
                        };
                
                        $.ajax({
                            url: wp_travel.ajaxUrl, // WordPress AJAX URL
                            type: 'POST',
                            data: orderData,
                            success: function(response) {
                                // Handle the response from the server (Razorpay Order ID)
                                if (response.success) {
                                    var order_id = response.data.order_id;
                                    
                                    data["order_id"] = order_id;

                                    var rzp1 = new Razorpay(data);
                                    rzp1.open();
                
                      
                                } else {
                                    console.error('Failed to create order:', response.message);
                                }
                            },
                            error: function() {
                                console.error('Error in AJAX request');
                            }
                        });
                    }
                });
            });
        }
    }

    var razorpay_checkout = function(){
        razorpay_remove();
        var payment_gateway = jQuery('input[name=wp_travel_payment_gateway]:checked').val()
        var booking_option = jQuery('[name=wp_travel_booking_option]').val();

        if ( 'razorpay_checkout' === payment_gateway && 'booking_with_payment' === booking_option ) {
            jQuery("#wp-travel-book-now, #wp-travel-complete-partial-payment").show().siblings().hide();
            jQuery(".paypal-button").remove();
            jQuery('[name=wp_travel_book_now], [name=complete_partial_payment]').click(razorpay_trigger);
        }
    }

    var razorpay_remove = function(){
        jQuery('[name=wp_travel_book_now]').off('click',razorpay_trigger);
        jQuery('[name=complete_partial_payment]').off('click',razorpay_trigger);
    }


    jQuery(document).on( 'change', '[name=wp_travel_booking_option]', function() {
        razorpay_checkout();
    });
    jQuery(document).on('change', '[name=wp_travel_payment_gateway]', function(){
        if( jQuery('[name=wp_travel_payment_gateway]').length > 1  ) {
            razorpay_checkout();
        }
    });

    jQuery(document).on('click', '[name=wp_travel_payment_gateway]', function(){
        if( jQuery('[name=wp_travel_payment_gateway]').length > 0  ) {
            razorpay_checkout();
        }
    });

    // Razorpay Checkout on load.
    razorpay_checkout();
    // Parsley validation on load.
    $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();
});
