<?php
/**
 * Settings file of WP Travel Squareup Checkout.
 *
 * @package WP Travel.
 */

/**
 * Setting field for squareup checkout. Use this for adding fields value on backend.
 *
 * @param array $settings_fields Fields.
 * @return array $settings_fields.
 */
function wptravel_squareup_checkout_settings_field( $settings_fields ) {
	$settings_fields['payment_option_squareup_checkout'] = 'no'; // chalne wala
	return $settings_fields;

}
add_filter( 'wp_travel_settings_fields', 'wptravel_squareup_checkout_settings_field' );

/**
 * Save Settings.
 *
 * @param Array $settings Settings array.
 * @param Array $settings_data Settings data array.
 */
function wptravel_settings_squareup_savev4( $settings, $settings_data ) {
	if ( ! $settings ) {
		return;
	}
	$payment_option_squareup = ( isset( $settings_data['payment_option_squareup'] ) && '' !== $settings_data['payment_option_squareup'] ) ? $settings_data['payment_option_squareup'] : '';

	$squareup_access_token = ( isset( $settings_data['squareup_access_token'] ) && '' !== $settings_data['squareup_access_token'] ) ? $settings_data['squareup_access_token'] : '';

	$squareup_application_id = ( isset( $settings_data['squareup_application_id'] ) && '' !== $settings_data['squareup_application_id'] ) ? $settings_data['squareup_application_id'] : '';
	$squareup_location_id    = ( isset( $settings_data['squareup_location_id'] ) && '' !== $settings_data['squareup_location_id'] ) ? $settings_data['squareup_location_id'] : '';

	$settings['payment_option_squareup'] = $payment_option_squareup;

	$settings['squareup_access_token']   = $squareup_access_token;
	$settings['squareup_application_id'] = $squareup_application_id;
	$settings['squareup_location_id']    = $squareup_location_id;

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wptravel_settings_squareup_savev4', 10, 2 );


