<?php


use Square\Environment;
use Square\Exceptions\ApiException;
use Square\SquareClient;
use Square\Models\CreatePaymentRequest;
use Square\Models\Money;



// ajax response code here:
function wptravel_sqaure_ajax_response() {
	if ( function_exists( 'wp_travel_get_settings' ) ) {
		$settings = wp_travel_get_settings();
	} else {
		$settings = wptravel_get_settings();
	}

	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	$access_token = $settings['squareup_access_token'];

	$environment = Environment::PRODUCTION;
	if ( $test_mode ) {
		$environment = Environment::SANDBOX;
	}
	// // Initialize the Square client.
	$api_client = new SquareClient(
		array(
			'accessToken' => $access_token,
			'environment' => $environment,
		)
	);
	// 'additionalHeaders' => array( 'Set-Cookie: cross-site-cookie=whatever, SameSite=None, Secure=true' ),
	// In production, the environment arg is 'production'
	// End of client side

	// Payment starts.
	$json_str = file_get_contents( 'php://input' );
	$payload  = json_decode( $json_str );

	if ( ! isset( $payload->sourceId ) ) {

		return;
	}

	$payments_api = $api_client->getPaymentsApi();
	$money        = new Money();
	$money->setAmount( wptravel_square_convert_amount( $payload->amount ) ); // zero decimal currency.
	$currency = $settings['currency'];
	if ( 'JPY' === $currency ) {
		$currency = 'YEN';
	}
	$money->setCurrency( $currency );

	$create_payment_request = new CreatePaymentRequest( $payload->sourceId, uniqid(), $money );

	try {
		$response = $payments_api->createPayment( $create_payment_request );
		if ( $response->isError() ) {
			// wp_send_json_error( $errors );
			echo 'Api response has Errors';
			$errors = $response->getErrors();
			print_r( $errors );
			exit();
		} else {
			$result = $response->getResult();
			wp_send_json( $result );
		}
	} catch ( ApiException $e ) {
		echo 'Caught exception!<br/>';
		exit();
	}
	die();

}



add_action( 'wp_ajax_wptravel_sqaure_ajax_response', 'wptravel_sqaure_ajax_response' );
add_action( 'wp_ajax_nopriv_wptravel_sqaure_ajax_response', 'wptravel_sqaure_ajax_response' );
