<?php
/**
 * Functions.
 *
 * @package wp-travel-squareup/inc/
 */

 /**
  * Return Payment Gateway list.
  *
  * @param array $gateways Payment Gateways.
  */
function wp_travel_gateway_squareup_checkout( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['squareup_checkout'] = __( 'Squareup Checkout', 'wp-travel-pro' );
	return $gateways;
}

		/**
		 * Return Premium addons list.
		 *
		 * @param array $addons List of premium addons.
		 */
function wp_travel_addons_squareup_checkout( $addons ) {
	$addons['squareup_checkout'] = __( 'Squareup Checkout', 'wp-travel-pro' );
	return $addons;
}



function wp_travel_add_vars_squareup( $args, $settings ) {
	if ( ! $args ) {
		return;
	}
	$application_id = isset( $settings['squareup_application_id'] ) ? $settings['squareup_application_id'] : '';

	$location_id = isset( $settings['squareup_location_id'] ) ? $settings['squareup_location_id'] : '';

	$access_token = isset( $settings['squareup_access_token'] ) ? $settings['squareup_access_token'] : '';

	$args['payment']['squareup_application_id'] = $application_id;

	$args['payment']['squareup_location_id']  = $location_id;
	$args['payment']['squareup_access_token'] = $access_token;
	return $args;
}


