

(function ($) {

    function formsaver(method, container) {
        function getStorageId(container) {
            return 'formdata__$url__$extra'.replace('$url', location.pathname)
                                           .replace('$extra', container.attr('id') || '');
        }

        var storageId = getStorageId(container),
            controller = {
                save: function () {
                    this._save(storageId, this.extractValues());
                },
                restore: function () {
                    this.fillFields(this._load(storageId));
                },
                clear: function () {
                    this._remove(storageId);
                },

                extractValues: function () {
                    var formData = container.find(":input[name]").serializeArray(),
                        preparedData = {};
                    $.each(formData, function (index, element) {
                        var name = element.name,
                            value = encodeURIComponent(element.value);
                        if (preparedData[name]) {
                            preparedData[name] = preparedData[name] instanceof Array ?
                                                 preparedData[name].concat(value) :
                                                 [preparedData[name], value];
                        } else {
                            preparedData[name] = value;
                        }
                    });
                    return preparedData;
                },
                fillFields: function (formData) {
                    $.each(formData, function (name, value) {
                        var tag_name = document.getElementsByName(name)[0].tagName;
                        var input_type = document.getElementsByName(name)[0].type;
   
                        // var field = container.find("[name=" + name + "]"),
                        //     inputType = field.prop('type');
                        // value = value instanceof Array ? value.map(decodeURIComponent) :
                        //                                  decodeURIComponent(value);
                        if (input_type === 'checkbox') {
                            if (name.includes('_checkout_terms') || name.includes('_subscribe')) {
								$( tag_name+"[name='"+name+"']" ).prop('checked', true);
							}

                            if (Array.isArray(value)) {
                                $.each(value, function(index, data) {
                                    $( tag_name+"[name='"+name+"'][value='"+data+"']" ).prop('checked', true);
                                });
                            }else{
                                $( tag_name+"[name='"+name+"'][value='"+value+"']" ).prop('checked', true);
                            }

                            $( "input[name='wp_travel_checkout_gdpr_msg[]']" ).prop('checked', true);

                        } else if (input_type === 'radio') {
                            $( tag_name+"[name='"+name+"'][value='"+value+"']" ).attr('checked', 'checked');
                        } else {
                            $( tag_name+"[name='"+name+"']" ).val(decodeURIComponent(value));
                        }
                    });
                },

                _save: function (storageId, data) {
                    localStorage[storageId] = JSON.stringify(data);
                },
                _load: function (storageId) {
                    return localStorage[storageId] ? JSON.parse(localStorage[storageId]) : {};
                },
                _remove: function (storageId) {
                    localStorage.removeItem(storageId);
                }
            },
            methodsQueue = method instanceof Array ? method : [method];

        $.each(methodsQueue, function (index, method) {
            controller[method]();
        });
    }
    $.fn.saveForm = function () {
        formsaver('save', $(this));
    };
    $.fn.restoreForm = function () {
        formsaver(['restore', 'clear'], $(this));
    };

    


})(jQuery);