jQuery(function ($) {

  const clientSecret = new URLSearchParams(window.location.search).get(
      "payment_intent_client_secret"
  );

  const countryCodeMap = {
    "Afghanistan": "AF",
    "Albania": "AL",
    "Algeria": "DZ",
    "Andorra": "AD",
    "Angola": "AO",
    "Antigua and Barbuda": "AG",
    "Argentina": "AR",
    "Armenia": "AM",
    "Australia": "AU",
    "Austria": "AT",
    "Azerbaijan": "AZ",
    "Bahamas": "BS",
    "Bahrain": "BH",
    "Bangladesh": "BD",
    "Barbados": "BB",
    "Belarus": "BY",
    "Belgium": "BE",
    "Belize": "BZ",
    "Benin": "BJ",
    "Bhutan": "BT",
    "Bolivia": "BO",
    "Bosnia and Herzegovina": "BA",
    "Botswana": "BW",
    "Brazil": "BR",
    "Brunei": "BN",
    "Bulgaria": "BG",
    "Burkina Faso": "BF",
    "Burundi": "BI",
    "Cabo Verde": "CV",
    "Cambodia": "KH",
    "Cameroon": "CM",
    "Canada": "CA",
    "Central African Republic": "CF",
    "Chad": "TD",
    "Chile": "CL",
    "China": "CN",
    "Colombia": "CO",
    "Comoros": "KM",
    "Congo (Congo-Brazzaville)": "CG",
    "Congo (Democratic Republic)": "CD",
    "Costa Rica": "CR",
    "Croatia": "HR",
    "Cuba": "CU",
    "Cyprus": "CY",
    "Czech Republic": "CZ",
    "Denmark": "DK",
    "Djibouti": "DJ",
    "Dominica": "DM",
    "Dominican Republic": "DO",
    "Ecuador": "EC",
    "Egypt": "EG",
    "El Salvador": "SV",
    "Equatorial Guinea": "GQ",
    "Eritrea": "ER",
    "Estonia": "EE",
    "Eswatini": "SZ",
    "Ethiopia": "ET",
    "Fiji": "FJ",
    "Finland": "FI",
    "France": "FR",
    "Gabon": "GA",
    "Gambia": "GM",
    "Georgia": "GE",
    "Germany": "DE",
    "Ghana": "GH",
    "Greece": "GR",
    "Grenada": "GD",
    "Guatemala": "GT",
    "Guinea": "GN",
    "Guinea-Bissau": "GW",
    "Guyana": "GY",
    "Haiti": "HT",
    "Honduras": "HN",
    "Hungary": "HU",
    "Iceland": "IS",
    "India": "IN",
    "Indonesia": "ID",
    "Iran": "IR",
    "Iraq": "IQ",
    "Ireland": "IE",
    "Israel": "IL",
    "Italy": "IT",
    "Jamaica": "JM",
    "Japan": "JP",
    "Jordan": "JO",
    "Kazakhstan": "KZ",
    "Kenya": "KE",
    "Kiribati": "KI",
    "Korea, North": "KP",
    "Korea, South": "KR",
    "Kuwait": "KW",
    "Kyrgyzstan": "KG",
    "Laos": "LA",
    "Latvia": "LV",
    "Lebanon": "LB",
    "Lesotho": "LS",
    "Liberia": "LR",
    "Libya": "LY",
    "Liechtenstein": "LI",
    "Lithuania": "LT",
    "Luxembourg": "LU",
    "Madagascar": "MG",
    "Malawi": "MW",
    "Malaysia": "MY",
    "Maldives": "MV",
    "Mali": "ML",
    "Malta": "MT",
    "Marshall Islands": "MH",
    "Mauritania": "MR",
    "Mauritius": "MU",
    "Mexico": "MX",
    "Micronesia": "FM",
    "Moldova": "MD",
    "Monaco": "MC",
    "Mongolia": "MN",
    "Montenegro": "ME",
    "Morocco": "MA",
    "Mozambique": "MZ",
    "Myanmar (Burma)": "MM",
    "Namibia": "NA",
    "Nauru": "NR",
    "Nepal": "NP",
    "Netherlands": "NL",
    "New Zealand": "NZ",
    "Nicaragua": "NI",
    "Niger": "NE",
    "Nigeria": "NG",
    "North Macedonia": "MK",
    "Norway": "NO",
    "Oman": "OM",
    "Pakistan": "PK",
    "Palau": "PW",
    "Panama": "PA",
    "Papua New Guinea": "PG",
    "Paraguay": "PY",
    "Peru": "PE",
    "Philippines": "PH",
    "Poland": "PL",
    "Portugal": "PT",
    "Qatar": "QA",
    "Romania": "RO",
    "Russia": "RU",
    "Rwanda": "RW",
    "Saint Kitts and Nevis": "KN",
    "Saint Lucia": "LC",
    "Saint Vincent and the Grenadines": "VC",
    "Samoa": "WS",
    "San Marino": "SM",
    "Sao Tome and Principe": "ST",
    "Saudi Arabia": "SA",
    "Senegal": "SN",
    "Serbia": "RS",
    "Seychelles": "SC",
    "Sierra Leone": "SL",
    "Singapore": "SG",
    "Slovakia": "SK",
    "Slovenia": "SI",
    "Solomon Islands": "SB",
    "Somalia": "SO",
    "South Africa": "ZA",
    "South Sudan": "SS",
    "Spain": "ES",
    "Sri Lanka": "LK",
    "Sudan": "SD",
    "Suriname": "SR",
    "Sweden": "SE",
    "Switzerland": "CH",
    "Syria": "SY",
    "Taiwan": "TW",
    "Tajikistan": "TJ",
    "Tanzania": "TZ",
    "Thailand": "TH",
    "Togo": "TG",
    "Tonga": "TO",
    "Trinidad and Tobago": "TT",
    "Tunisia": "TN",
    "Turkey": "TR",
    "Turkmenistan": "TM",
    "Tuvalu": "TV",
    "Uganda": "UG",
    "Ukraine": "UA",
    "United Arab Emirates": "AE",
    "United Kingdom": "GB",
    "United States": "US",
    "Uruguay": "UY",
    "Uzbekistan": "UZ",
    "Vanuatu": "VU",
    "Vatican City": "VA",
    "Venezuela": "VE",
    "Vietnam": "VN",
    "Yemen": "YE",
    "Zambia": "ZM",
    "Zimbabwe": "ZW"
  };
  
    if ( clientSecret) {
      window.scrollTo({top: 0, left: 0 });
      $( '.wp-travel' ).css( 'visibility', 'hidden' );
      $( '.wp-travel' ).css( 'height', '0px' ); 
      $('body').append('<div id="stripe-element"><div id="loader-init"><div class="stripe-loader"></div><h4>Processing Payment..</h4></div></div>')      
      
      
      $( '.stripe-loader' ).css( 'display', 'block' );  
      $( '#loader-init' ).css( 'position', 'absolute' );   
      $( '#loader-init' ).css( 'top', '0px' ); 
      $( '#loader-init' ).css( 'z-index', '9999999' ); 
      $( '#loader-init' ).css( 'background', '#fff' );
      $( '#loader-init' ).css( 'width', '100%' );
      $( '#loader-init' ).css( 'height', '100%' );
      // $("#wp-travel-booking").restoreForm();
      // $("#wp-travel-partial-payment").restoreForm();
      stripe = Stripe(wp_travel.payment.stripe_publishable_key);

      var paymentIntent  = stripe.retrievePaymentIntent(clientSecret).then(function (result) {
          switch (result.paymentIntent.status) {
            case "succeeded":
              console.log("Payment successsseded!");
              complete( result.paymentIntent );
            break;
            case "processing":
              console.log("Your payment is processing.");
            break;
            case "requires_payment_method":
              console.log("Your payment was not successful, please try again.");
            break;
            default:
              console.log("Something went wrong.");
            break;
        }
      });
            
      

    }else{
    
    if( wp_travel.payment.stripe_publishable_key.length > 0 ){


        var stripe, elements, style, card, form, submitBtn, paymentIntent;
        var form = document.getElementById('wp-travel-booking') || document.getElementById('wp-travel-partial-payment');

        cardElement = document.createElement('div')
        // cardElement.setAttribute('id', 'card-element')
        cardElement.classList.add('wp-travel-form-field', 'stripe-payment-field')
        var refElement = form.querySelector('.wp-travel-form-field.button-field')
        cardEl = refElement.parentNode.insertBefore(cardElement, refElement)
        $(cardEl).html('<div id="stripe-element"><div id="loader-init"><div class="stripe-loader"></div></div></div>')

        cardElement = document.createElement('div')
        // cardElement.setAttribute('id', 'card-element')
        cardElement.classList.add('wp-travel-form-field', 'stripe-payment-btn')
        var refElement = form.querySelector('.wp-travel-form-field.button-field')
        cardEl = refElement.parentNode.insertBefore(cardElement, refElement)
        $(cardEl).html('<div id="stripe-element"><div id="loader-init"><div class="stripe-loader"></div></div></div>')
        $(cardEl).html('<span class="btn" id="wptravel-pay-with-stripe">'+_wpTravelStripeL10n.pay_with_stripe+'</span>');

        cardElement = document.createElement('div')
        // cardElement.setAttribute('id', 'card-element')
        cardElement.classList.add('wp-travel-form-field', 'stripe-procced-payment-btn')
        var refElement = form.querySelector('.wp-travel-form-field.button-field')
        cardEl = refElement.parentNode.insertBefore(cardElement, refElement)
        $(cardEl).html('<div id="stripe-element"><div id="loader-init"><div class="stripe-loader"></div></div></div>')
        $(cardEl).html('<span class="btn" id="wptravel-proceed-with-stripe">'+_wpTravelStripeL10n.proceed_payment+'</span>');

        stripe = Stripe(wp_travel.payment.stripe_publishable_key);



        if( $( '#wp-travel-payment-stripe' ).is(":checked") ){
          $( '#wp-travel-book-now' ).css( 'visibility', 'hidden' );
          $( '.stripe-procced-payment-btn' ).css( 'visibility', 'visible' );
          
        }

        
        function handleServerResponse(response) {

            if (response.error) {
                // Show error from server on payment form
            } else {
              
              const clientSecret = response.payment_intent_client_secret;
              elements = stripe.elements({ clientSecret });

                const paymentElementOptions = {
                    layout: "tabs",
                };

                const paymentElement = elements.create("payment", paymentElementOptions);
                paymentElement.mount("#stripe-element");

            }
        }
    }

  }

  $( "#wptravel-pay-with-stripe" ).on( "click", function(e) {

    if ($("#wp-travel-partial-payment").length) {
      console.log( 'parsley not required' )
    } else {
      wt_parsley = jQuery("#wp-travel-booking").parsley()

      if (!wt_parsley.isValid()) {
        return wt_parsley.validate();
      }
    }

    // $("#wp-travel-booking").saveForm();
    // $("#wp-travel-partial-payment").saveForm();
    
      e.preventDefault();

      stripe.confirmPayment({
        elements,
      //   redirect: 'if_required',
        confirmParams: {
          // Make sure to change this to your payment completion page
          return_url: window.location.href,
        },
      })  
         
  } );

  // stripeInit();
  function complete(response) {
      var form_id = 'wp-travel-booking'; // Default payment form id
      var payment_form_id = jQuery('#wp-travel-payment-form-id').val();

      if (payment_form_id) {
          form_id = payment_form_id;
      }

      setTimeout(function () {
          jQuery('[name=payment_details]').remove();
          jQuery('form#' + form_id).append(jQuery("<input type='hidden' name='payment_details' />").attr("value", JSON.stringify(response)));
          jQuery('form#' + form_id).find("[type=submit]").click();
      }, 2);
  };

  jQuery(document).on('change', '[name=wp_travel_payment_gateway]', function () {
    if( $( '#wp-travel-payment-stripe' ).is(":checked") ){
      $( '#wp-travel-book-now' ).css( 'visibility', 'hidden' );
      $( '.stripe-payment-btn' ).css( 'visibility', 'hidden' );
      $( '.stripe-procced-payment-btn' ).css( 'visibility', 'visible' );
      $( '#wp-travel-complete-partial-payment' ).css( 'visibility', 'hidden' );
      
      
    }else{
      $( '#wp-travel-book-now' ).css( 'visibility', 'visible' );
      $( '.stripe-procced-payment-btn' ).css( 'visibility', 'hidden' );
      $( '.stripe-payment-btn' ).css( 'visibility', 'hidden' );
      $( '#wp-travel-complete-partial-payment' ).css( 'visibility', 'visible' );
    }

  }); 

  jQuery(document).on('change', '[name=wp_travel_booking_option]', function () {

    if( jQuery( 'select[name="wp_travel_booking_option"]' ).val() === 'booking_with_payment' ){
      $( '.StripeElement' ).css( 'display', 'none' );
      $( '.stripe-payment-btn' ).css( 'visibility', 'hidden' );
      $( '.stripe-procced-payment-btn' ).css( 'visibility', 'hidden' );
      if( $( '#wp-travel-payment-stripe' ).is(":checked") ){  
        $( '#wp-travel-book-now' ).css( 'visibility', 'hidden' ); 
         $( '.stripe-procced-payment-btn' ).css( 'visibility', 'visible' );
      }
    }else{
      $( '.stripe-payment-btn' ).css( 'visibility', 'hidden' );
      $( '.stripe-procced-payment-btn' ).css( 'visibility', 'hidden' );
      $( '#wp-travel-book-now' ).css( 'visibility', 'visible' );
      jQuery('.__PrivateStripeElement').remove();
    }

  }); 

  jQuery(document).on('change', '[name=wp_travel_payment_mode]', function () {
      $( '.StripeElement' ).css( 'display', 'none' );
      $( '.stripe-payment-btn' ).css( 'visibility', 'hidden' );
      $( '.stripe-procced-payment-btn' ).css( 'visibility', 'hidden' );
      if( $( '#wp-travel-payment-stripe' ).is(":checked") ){   
        $( '#wp-travel-book-now' ).css( 'visibility', 'hidden' ); 
         $( '.stripe-procced-payment-btn' ).css( 'visibility', 'visible' );
      }
  }); 

  $( "#wptravel-proceed-with-stripe" ).on( "click", function(e) {

    $( '.StripeElement' ).css( 'display', 'block' );

    if ($("#wp-travel-tab-content-bookings #wp-travel-partial-payment").length) {
      wt_parsley = jQuery("#wp-travel-partial-payment").parsley()
    }else{
      wt_parsley = jQuery("#wp-travel-booking").parsley()
    }
    
    if (!wt_parsley.isValid()) {
      return wt_parsley.validate();
    }else{
      $( '.stripe-procced-payment-btn' ).css( 'visibility', 'hidden' );
      $( '.stripe-payment-btn' ).css( 'visibility', 'visible' );
      

      title = $('.entry-title').html() || 'Trip Book';
      trip_title = $('.trip-name h5 a').html() || '';

      l = jQuery("#wp-travel-payment-mode option:selected").val();

      if ($('[name=complete_partial_payment]').length > 0) {
          o = $('#wp-travel-amount').val(); // Added for partial payment.
      } else {
          o = "partial" == l ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price;
      }

      data = {
          currency: wp_travel.payment.currency_code,
          currency_symbol: wp_travel.currency_symbol,
          total_qty: 1,
          title: title,
          trip_title: trip_title,
          amount: o,
          customer_name: document.querySelector('input[name^=wp_travel_fname_traveller]') ? document.querySelector('input[name^=wp_travel_fname_traveller]').value : document.querySelector('input[name=account_first_name]').value,
          customer_email: document.querySelector('input[name^=wp_travel_email_traveller]') ? document.querySelector('input[name^=wp_travel_email_traveller]').value : document.querySelector('input[name=account_email]').value,
          customer_country: countryCodeMap[$("select[name^='wp_travel_country_traveller']").val()] ? countryCodeMap[$("select[name^='wp_travel_country_traveller']").val()] : 1,
          customer_contact_number: document.querySelector('input[name^=wp_travel_phone_traveller]') ? document.querySelector('input[name^=wp_travel_phone_traveller]').value : 1
        };
        


      $('#stripe-element').html('<div id="stripe-element"><div id="loader-init"><div class="stripe-loader"></div></div></div>')      
      $( '.stripe-loader' ).css( 'display', 'block' );        
      

      if ($("#wp-travel-tab-content-bookings #wp-travel-partial-payment").length) { 
        var _data = {}
        _data['name'] = document.querySelector('input[name^=wp_travel_fname_traveller]') ? document.querySelector('input[name^=wp_travel_fname_traveller]').value : document.querySelector('input[name=account_first_name]').value
        _data['email'] = document.querySelector('input[name^=wp_travel_email_traveller]') ? document.querySelector('input[name^=wp_travel_email_traveller]').value : document.querySelector('input[name=account_email]').value
        
        if (_data.name.length <= 0 || _data.email.length <= 0) {
            const cardErrors = document.getElementById('card-errors');
            cardErrors.textContent = 'Please add your name and email on account tab.';
            cardErrors.classList.add('visible');
            submitBtn.disabled = false;
            jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
            return;
        }else{
          fetch(wp_travel.ajaxUrl + '?action=payment_intents', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ data: data })
          }).then(function (result) {
  
              // Handle server response (see Step 3)
              result.json().then(function (json) {
                  handleServerResponse(json);
              })
          });
        }

      }else{
        fetch(wp_travel.ajaxUrl + '?action=payment_intents', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ data: data })
        }).then(function (result) {

            // Handle server response (see Step 3)
            result.json().then(function (json) {
                handleServerResponse(json);
            })
        });
      }
      
    }
  }); 

})