jQuery(function ($) {

    const stripeInit = function (form) {
        // Create references to the main form and its submit button.
        var stripe, elements, style, card, form, submitBtn, paymentIntent;
        // var form = document.getElementById('wp-travel-booking')
        // if (!form) {
        //     form = document.getElementById('wp-travel-partial-payment');
        // }
        submitBtn = form.querySelector('input[type=submit]');
        cardElement = document.createElement('div')
        // cardElement.setAttribute('id', 'card-element')
        cardElement.classList.add('wp-travel-form-field', 'payment-card-field')
        var refElement = form.querySelector('.wp-travel-form-field.button-field')
        cardEl = refElement.parentNode.insertBefore(cardElement, refElement)
        $(cardEl).html('<label>' + wp_travel.strip_card + '</label><div id="card-element"></div>')
        // Create a Stripe client.
        stripe = Stripe(wp_travel.payment.stripe_publishable_key);
        elements = stripe.elements();
        style = {
            iconStyle: 'solid',
            style: {
                base: {
                    iconColor: '#c4f0ff',
                    color: '#fff',
                    fontWeight: 500,
                    fontFamily: 'Roboto, Open Sans, Segoe UI, sans-serif',
                    fontSize: '16px',
                    fontSmoothing: 'antialiased',

                    ':-webkit-autofill': {
                        color: '#fce883',
                    },
                    '::placeholder': {
                        color: '#87BBFD',
                    },
                },
                invalid: {
                    iconColor: '#FFC7EE',
                    color: '#FFC7EE',
                },
            }
        };
        card = elements.create('card' );
        // Mount the Card Element on the page.
        // card.mount('#card-element');

        // Monitor change events on the Card Element to display any errors.
        card.on('change', ({ error }) => {
            const cardErrors = document.getElementById('card-errors');
            if (error) {
                cardErrors.textContent = error.message;
                cardErrors.classList.add('visible');

            } else {
                cardErrors.classList.remove('visible');
            }
            // Re-enable the Pay button.
            jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
            submitBtn.disabled = false;
        });

        function handleServerResponse(response) {
            if (response.error) {
                // Show error from server on payment form
            } else if (response.requires_action) {
                // Use Stripe.js to handle required card action
                stripe.handleCardAction(
                    response.payment_intent_client_secret
                ).then(function (result) {
                    if (result.error) {
                        // Show error in payment form
                    } else {
                        // The card action has been handled
                        // The PaymentIntent can be confirmed again on the server
                        fetch(wp_travel.ajaxUrl + '?action=payment_intents', {
                            method: 'POST',
                            headers: { 'Content-Type': 'application/json' },
                            body: JSON.stringify({ payment_intent_id: result.paymentIntent.id })
                        }).then(function (confirmResult) {
                            return confirmResult.json();
                        }).then(handleServerResponse);
                    }
                });
            } else {
                // Show success message
                stripe.retrievePaymentIntent(response.payment_intent_client_secret)
                    .then(function (result) {
                        if (result.error) {
                            // Handle error here
                        } else if (result.paymentIntent && result.paymentIntent.status === 'succeeded') {
                            // Handle successful payment here
                            complete(result);
                        }
                    })
            }
        }

        const stripe_trigger = function (e) {
            jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
            wt_parsley = jQuery("#wp-travel-booking").parsley()
            e.preventDefault();
            var l = jQuery("#wp-travel-payment-mode option:selected").val();

            if ($('[name=complete_partial_payment]').length > 0) {
                o = $('#wp-travel-amount').val(); // Added for partial payment.
            } else {
                o = "partial" == l ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price;
                if (!wt_parsley.isValid()) {
                    return wt_parsley.validate();
                }
            }

            var booking_option = $('[name=wp_travel_booking_option]').val();
            if ('booking_with_payment' === booking_option) {

                jQuery('.wp-travel-form-field.button-field').append('<i class="wt-icon wt-icon-spin wt-icon-spinner"></i>');
                submitBtn.disabled = true;

                var title = $('.entry-title').html() || 'Trip Book';

                data = {
                    currency: wp_travel.payment.currency_code,
                    currency_symbol: wp_travel.currency_symbol,
                    total_qty: 1,
                    title: title,
                    amount: o
                };

                var _data = {}
                _data['name'] = document.querySelector('input[name^=wp_travel_fname_traveller]') ? document.querySelector('input[name^=wp_travel_fname_traveller]').value : document.querySelector('input[name=account_first_name]').value
                _data['email'] = document.querySelector('input[name^=wp_travel_email_traveller]') ? document.querySelector('input[name^=wp_travel_email_traveller]').value : document.querySelector('input[name=account_email]').value
                if (_data.name.length <= 0 || _data.email.length <= 0) {
                    const cardErrors = document.getElementById('card-errors');
                    cardErrors.textContent = 'Please add your name and email on account tab.';
                    cardErrors.classList.add('visible');
                    submitBtn.disabled = false;
                    jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
                    return;
                }
                if (document.getElementById('wp-travel-booking')) {
                    let phone = document.querySelector('input[name^=wp_travel_phone_traveller]')
                    let city = document.querySelector('input[name=billing_city]')
                    let country = document.querySelector('input[name=wp_travel_country]')
                    let postalCode = document.querySelector('input[name=billing_postal]')
                    let line1 = document.querySelector('input[name=wp_travel_address]')
                    _data['address'] = {}
                    if (phone) {
                        _data['phone'] = phone.value
                    }
                    if (city) {
                        _data['address']['city'] = city.value
                    }
                    if (country) {
                        _data['address']['country'] = country.value
                    }
                    if (postalCode) {
                        _data['address']['postal_code'] = postalCode.value
                    }
                    if (line1) {
                        _data['address']['line1'] = line1.value
                    }
                }
                // var handle = wp_travel_stripe_handler(data);
                stripe.createPaymentMethod('card', card, {
                    billing_details: _data
                }).then(function (result) {
                    if (result.error) {
                        // Show error in payment form
                        jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
                        submitBtn.disabled = false;
                        alert('Couldn\'t complete. Please try again later.')
                    } else {
                        // checking inventory enable or not. if enable then also checking max pax available or not.
                        //since 6.5.1
                        if ( typeof wp_travel.inventory != 'undefined' && wp_travel.inventory == 'yes' ) {
                            fetch( wp_travel.ajaxUrl + '?action=inventory_testing&_nonce='+ wp_travel._nonce, {
                                method : 'POST',
                                headers : { 'Content-Type': 'application/json' },
                                body : JSON.stringify({ wp_travel_trip : typeof wp_travel.items != 'undefined' && wp_travel.items || Array(), nonce :  wp_travel.nonce } )
                            } ).then( function ( resp ) { 
                                resp.json().then( responces => {
                                    if ( responces.success == true ) {
                                        if ( typeof responces.data != 'undefined' && typeof responces.data.code != 'undefined' && typeof responces.data.inventory_available != 'undefined' && responces.data.code == "WP_TRAVEL_INVENTORY_TESTING" && responces.data.inventory_available == 'no_pax' ) {
                                            if ( confirm( "Sorry your booking can't proceed, booking is full." ) ) {
                                                fetch( wp_travel.ajaxUrl + '?action=wp_travel_use_inventory_empty_cart'+ wp_travel._nonce, {
                                                    method : 'POST',
                                                    headers : { 'Content-Type' : 'application/json' },
                                                    body : JSON.stringify( { wp_travel_empty_cart : typeof wp_travel.items != 'undefined' && wp_travel.items || Array() } ),
                                                } ).then( results => results.json().then( resu => { location.reload();} ) ) ;
                                            }
                                        } else {
                                            // Otherwise send paymentMethod.id to your server (see Step 2)
                                            fetch(wp_travel.ajaxUrl + '?action=payment_intents', {
                                                method: 'POST',
                                                headers: { 'Content-Type': 'application/json' },
                                                body: JSON.stringify({ payment_method_id: result.paymentMethod.id, data: data })
                                            }).then(function (result) {
                                                // Handle server response (see Step 3)
                                                result.json().then(function (json) {
                                                    handleServerResponse(json);
                                                })
                                            });
                                        }

                                    }
                                })
                                
                            })
                        } else {
                            // Otherwise send paymentMethod.id to your server (see Step 2)
                            fetch(wp_travel.ajaxUrl + '?action=payment_intents', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/json' },
                                body: JSON.stringify({ payment_method_id: result.paymentMethod.id, data: data })
                            }).then(function (result) {
                                // Handle server response (see Step 3)
                                result.json().then(function (json) {
                                    handleServerResponse(json);
                                })
                            });
                        }
                    }
                });
            }
        }

        const complete = function (response) {
            var form_id = 'wp-travel-booking'; // Default payment form id
            submitBtn.disabled = false;
            var payment_form_id = jQuery('#wp-travel-payment-form-id').val();

            if (payment_form_id) {
                form_id = payment_form_id;
            }
            jQuery('.loader-active').show();
            stripe_remove();
            setTimeout(function () {
                jQuery('[name=payment_details]').remove();
                jQuery('form#' + form_id).append(jQuery("<input type='hidden' name='payment_details' />").attr("value", JSON.stringify(response)));
                jQuery('form#' + form_id).find("[type=submit]").click();
            }, 2);
            // This will submit form and trigger wp_travel_after_frontend_booking_save, wp_travel_after_partial_payment_complete hooks with  respective callbacks.
            // For partial payment from dashboard add_action( 'init', 'wp_travel_complete_parital_payment', 20 ); in partial payment addons.
            // For frontend payment add_action( 'init', 'wptravel_book_now', 99 ); in wp-travel.php
        };

        const stripe_checkout = function () {
            stripe_remove();
            var payment_gateway = jQuery('input[name=wp_travel_payment_gateway]').attr('type').match(/(radio|checkbox)/) && jQuery('input[name=wp_travel_payment_gateway]:checked').val() || jQuery('input[name=wp_travel_payment_gateway]').val()
            var booking_option = jQuery('[name=wp_travel_booking_option]').val();

            if ('stripe' === payment_gateway && 'booking_with_payment' === booking_option) {
                $('.payment-card-field').show();
                card.mount('#card-element');
                const brandLogo = document.createElement('img')
                brandLogo.src = _wpTravelStripeL10n.brandLogo
                brandLogo.classList.add('stripe-brand-logo')
                jQuery("#wp-travel-book-now, #wp-travel-complete-partial-payment").show().siblings().hide();

                jQuery(".paypal-button").remove();
                jQuery(brandLogo).insertAfter(jQuery('#wp-travel-book-now'))
                jQuery('[name=wp_travel_book_now], [name=complete_partial_payment]').click(stripe_trigger);
            } else {
                $('.payment-card-field').hide();
                $('.stripe-brand-logo').remove()
                card.unmount();
            }
        }

        const stripe_remove = function () {
            jQuery('[name=wp_travel_book_now]').off('click', stripe_trigger);
            jQuery('[name=complete_partial_payment]').off('click', stripe_trigger);
        }

        jQuery(document).on('change', '[name=wp_travel_booking_option]', function () {
            stripe_checkout();
        });
        jQuery(document).on('change', '[name=wp_travel_payment_gateway]', function () {
            if (jQuery('[name=wp_travel_payment_gateway]').length > 1) {
                stripe_checkout();
            }
        });

        // Checkout on load.
        stripe_checkout();
        // Parsley validation on load.
        $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();
    }
    var form = document.getElementById('wp-travel-booking') || document.getElementById('wp-travel-partial-payment')
    form && wp_travel.payment.stripe_publishable_key.length > 0 && stripeInit(form);
    $( '.payment-card-field, .stripe-brand-logo' ).hide();
    if( $( '#wp-travel-payment-stripe' ).is(":checked") ){
        $( '.payment-card-field, .stripe-brand-logo' ).show();
    }
    $(document).on('change', '[name=wp_travel_payment_gateway]', function () {
        if($( '#wp-travel-payment-stripe' ).is(':checked')){
            $( '.payment-card-field, .stripe-brand-logo' ).show();
        }
    });
    const formFields = document.querySelectorAll('#wp-travel-booking input, #wp-travel-booking select');

    // Add change event listener to each field
    formFields.forEach(field => {
      field.addEventListener('change', function() {
        if($( '#wp-travel-payment-stripe' ).is(':checked')){
            $( '.payment-card-field, .stripe-brand-logo' ).show();
        }
      });
    });
})