<?php
/**
 * Functions.
 *
 * @package wp-travel-stripe/inc/admin/
 */

/**
 * Save settings v4.
 *
 * @param Array $settings List of settings.
 * @param Array $settings_data List of settings data.
 */
function wp_travel_settings_stripe_savev4( $settings, $settings_data ) {
	if ( ! $settings ) {
		return;
	}
	$payment_option_stripe       = ( isset( $settings_data['payment_option_stripe'] ) && '' !== $settings_data['payment_option_stripe'] ) ? $settings_data['payment_option_stripe'] : '';
	$stripe_new_payment_ui       = ( isset( $settings_data['stripe_new_payment_ui'] ) && '' !== $settings_data['stripe_new_payment_ui'] ) ? $settings_data['stripe_new_payment_ui'] : '';
	$stripe_test_publishable_key = ( isset( $settings_data['stripe_test_publishable_key'] ) && '' !== $settings_data['stripe_test_publishable_key'] ) ? $settings_data['stripe_test_publishable_key'] : '';
	$stripe_test_secret_key      = ( isset( $settings_data['stripe_test_secret_key'] ) && '' !== $settings_data['stripe_test_secret_key'] ) ? $settings_data['stripe_test_secret_key'] : '';
	$stripe_publishable_key      = ( isset( $settings_data['stripe_publishable_key'] ) && '' !== $settings_data['stripe_publishable_key'] ) ? $settings_data['stripe_publishable_key'] : '';
	$stripe_secret_key           = ( isset( $settings_data['stripe_secret_key'] ) && '' !== $settings_data['stripe_secret_key'] ) ? $settings_data['stripe_secret_key'] : '';
	// $stripe_enable_3d_secure     = ( isset( $settings_data['stripe_enable_3d_secure'] ) && '' !== $settings_data['stripe_enable_3d_secure'] ) ? $settings_data['stripe_enable_3d_secure'] : 'no';

	$settings['payment_option_stripe']       = $payment_option_stripe;
	$settings['stripe_new_payment_ui']       = $stripe_new_payment_ui;
	$settings['stripe_test_publishable_key'] = $stripe_test_publishable_key;
	$settings['stripe_test_secret_key']      = $stripe_test_secret_key;
	$settings['stripe_publishable_key']      = $stripe_publishable_key;
	$settings['stripe_secret_key']           = $stripe_secret_key;
	// $settings['stripe_enable_3d_secure']     = $stripe_enable_3d_secure;

	return $settings;
}
add_filter( 'wp_travel_block_before_save_settings', 'wp_travel_settings_stripe_savev4', 10, 2 );

function wp_travel_settings_stripe_save( $settings ) {
	if ( ! $settings ) {
		return;
	}
	$payment_option_stripe = ( isset( $_POST['payment_option_stripe'] ) && '' !== $_POST['payment_option_stripe'] ) ? $_POST['payment_option_stripe'] : '';

	$stripe_new_payment_ui = ( isset( $_POST['stripe_new_payment_ui'] ) && '' !== $_POST['stripe_new_payment_ui'] ) ? $_POST['stripe_new_payment_ui'] : '';

	$stripe_test_publishable_key = ( isset( $_POST['stripe_test_publishable_key'] ) && '' !== $_POST['stripe_test_publishable_key'] ) ? $_POST['stripe_test_publishable_key'] : '';
	$stripe_test_secret_key = ( isset( $_POST['stripe_test_secret_key'] ) && '' !== $_POST['stripe_test_secret_key'] ) ? $_POST['stripe_test_secret_key'] : '';
	$stripe_publishable_key = ( isset( $_POST['stripe_publishable_key'] ) && '' !== $_POST['stripe_publishable_key'] ) ? $_POST['stripe_publishable_key'] : '';
	$stripe_secret_key = ( isset( $_POST['stripe_secret_key'] ) && '' !== $_POST['stripe_secret_key'] ) ? $_POST['stripe_secret_key'] : '';

	$settings['payment_option_stripe'] = $payment_option_stripe;
	$settings['stripe_new_payment_ui'] = $stripe_new_payment_ui;
	$settings['stripe_test_publishable_key'] = $stripe_test_publishable_key;
	$settings['stripe_test_secret_key'] = $stripe_test_secret_key;
	$settings['stripe_publishable_key'] = $stripe_publishable_key;
	$settings['stripe_secret_key'] = $stripe_secret_key;

	return $settings;
}
add_filter( 'wp_travel_before_save_settings', 'wp_travel_settings_stripe_save' );