<?php
/**
 * Functions.
 *
 * @package wp-travel-paypal/inc/
 */

// Functions.
/**
 * Return 
 */
function wp_travel_gateway_stripe( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['stripe'] = __( 'Stripe Checkout', 'wp-travel-pro' );
	return $gateways;
}

function wp_travel_stripe_addons( $addons ) {
	$addons['stripe'] = __( 'Stripe Checkout', 'wp-travel-pro' );
	return $addons;
}

function wp_travel_stripe_add_vars( $args, $settings ) {
	if ( ! $args ) {
		return;
	}
	$publishable_key = isset( $settings['stripe_publishable_key'] ) ? $settings['stripe_publishable_key'] : '';
	
	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	if ( $test_mode ) {
		$publishable_key = isset( $settings['stripe_test_publishable_key'] ) ? $settings['stripe_test_publishable_key'] : '';
	}

	$args['payment']['stripe_publishable_key'] = $publishable_key;
	return $args;
}