jQuery(function ($) {
    var stripeIdealInit = function stripeIdealInit() {
        var init = function init() {
            $('#wp-travel-booking').length > 0 && $('#wp-travel-booking').parsley();
            jQuery(document).on('change', '[name=wp_travel_booking_option],[name=wp_travel_payment_gateway]', stripe_checkout);
            stripe_checkout();
        }
        // Create references to the main form and its submit button.
        var stripe, elements, style, form, submitBtn;
        var form = document.getElementById('wp-travel-booking')
        if (!form) {
            form = document.getElementById('wp-travel-partial-payment');
        }
        submitBtn = form.querySelector('input[type=submit]');
        cardElement = document.createElement('div')
        cardElement.classList.add('wp-travel-form-field', 'payment-ideal-field')
        var refElement = form.querySelector('.wp-travel-form-field.button-field')
        cardEl = refElement.parentNode.insertBefore(cardElement, refElement)
        $(cardEl).html('<label>iDEAL Bank</label><div id="stripeIdealElement"></div>')
        // Create a Stripe client.
        stripe = Stripe(wp_travel.payment.stripe_ideal_publishable_key);
        elements = stripe.elements();
        var style = {
            base: {
                padding: '10px 12px',
                color: '#32325d',
                fontFamily: '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif',
                fontSmoothing: 'antialiased',
                fontSize: '16px',
                '::placeholder': {
                    color: '#aab7c4'
                },
            },
            invalid: {
                color: '#fa755a',
            }
        };
        var idealBank = elements.create('idealBank', { style: style });
        // Mount the Card Element on the page.
        // idealBank.mount('#stripeIdealElement');

        // Monitor change events on the Card Element to display any errors.
        idealBank.on('change', function (e) {
            var cardErrors = document.getElementById('stripe-ideal-errors');

            // Re-enable the Pay button.
            jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
            submitBtn.disabled = false;
        });

        var stripe_trigger = function (e) {
            jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
            wt_parsley = jQuery("#wp-travel-booking").parsley()
            e.preventDefault();
            if ( wp_travel.payment.currency_code !== 'EUR' ) {
                alert( 'The currency must be \'EUR\'' );
                return;
            }
            var l = jQuery("#wp-travel-payment-mode option:selected").val();

            if ($('[name=complete_partial_payment]').length > 0) {
                o = $('#wp-travel-amount').val(); // Added for partial payment.
            } else {
                o = "partial" == l ? wp_travel.payment.payment_amount : wp_travel.payment.trip_price;
                if (!wt_parsley.isValid()) {
                    return wt_parsley.validate();
                }
            }

            var booking_option = $('[name=wp_travel_booking_option]').val();
            if ('booking_with_payment' === booking_option) {

                jQuery('.wp-travel-form-field.button-field').append('<i class="wt-icon wt-icon-spin wt-icon-spinner"></i>');
                submitBtn.disabled = true;

                var title = $('.entry-title').html() || 'Trip Book';

                data = {
                    currency: wp_travel.payment.currency_code,
                    currency_symbol: wp_travel.currency_symbol,
                    total_qty: 1,
                    title: title,
                    amount: o
                };

                var _data = {}
                _data['name'] = document.querySelector('input[name^=wp_travel_fname_traveller]') ? document.querySelector('input[name^=wp_travel_fname_traveller]').value : document.querySelector('input[name=account_first_name]').value
                _data['email'] = document.querySelector('input[name^=wp_travel_email_traveller]') ? document.querySelector('input[name^=wp_travel_email_traveller]').value : document.querySelector('input[name=account_email]').value
                if (_data.name.length <= 0 || _data.email.length <= 0) {
                    var cardErrors = document.getElementById('stripe-ideal-errors');
                    cardErrors.textContent = 'Please add your name and email on account tab.';
                    cardErrors.classList.add('visible');
                    submitBtn.disabled = false;
                    jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
                    return;
                }
                if (document.getElementById('wp-travel-booking')) {
                    _data['address'] = {}
                    _data['phone'] = document.querySelector('input[name^=wp_travel_phone_traveller]').value
                    _data['address']['city'] = document.querySelector('input[name=billing_city]').value
                    _data['address']['country'] = document.querySelector('select[name=wp_travel_country]').value
                    _data['address']['postal_code'] = document.querySelector('input[name=billing_postal]').value
                    _data['address']['line1'] = document.querySelector('input[name=wp_travel_address]').value
                }
                // var handle = wp_travel_stripe_handler(data);

                var sourceData = {
                    type: 'ideal',
                    amount: parseInt(data.amount) * 100,
                    currency: 'eur',
                    owner: _data,
                    // Specify the URL to which the customer should be redirected
                    // after paying.
                    redirect: {
                        return_url: wp_travel.payment.thankyouurl,
                    }
                }

                // Call `stripe.createSource` with the idealBank Element and
                // additional options.
                fetch(wp_travel.ajaxUrl + "?action=inventory_testing" + wp_travel._nonce , {
                    method: "POST",
                    headers: { "Content-Type": "application/json" },
                    body: JSON.stringify({
                      wp_travel_trip:
                        (typeof wp_travel.items != "undefined" && wp_travel.items) || Array(),
                      nonce: wp_travel.nonce,
                    }),
                }).then(function (resp) {
                    resp.json().then((responces) => {
                        if (responces.success == true) {
                            if (
                                typeof responces.data != "undefined" &&
                                typeof responces.data.code != "undefined" &&
                                typeof responces.data.inventory_available != "undefined" &&
                                responces.data.code == "WP_TRAVEL_INVENTORY_TESTING" &&
                                responces.data.inventory_available == "no_pax"
                            ) {
                            if (confirm("Sorry your booking can't proceed, booking is full.")) {
                                fetch(
                                wp_travel.ajaxUrl + "?action=wp_travel_use_inventory_empty_cart"+ wp_travel._nonce,
                                {
                                    method: "POST",
                                    headers: { "Content-Type": "application/json" },
                                    body: JSON.stringify({
                                    wp_travel_empty_cart:
                                        (typeof wp_travel.items != "undefined" && wp_travel.items) ||
                                        Array(),
                                    }),
                                }
                                ).then((results) =>
                                results.json().then((resu) => {
                                    location.reload();
                                })
                                );
                            }
                            } else {
                                stripe.createSource(idealBank, sourceData).then(function (result) {
                                    if (result.error) {
                                        // Inform the customer that there was an error.
                                        jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
                                        var errorElement = document.getElementById('stripe-ideal-errors');
                                        errorElement.textContent = 'Error: ' + result.error.message;
                                        submitBtn.disabled = false;
                                    } else {
                                        // Redirect the customer to the authorization URL.
                                        complete(result.source);
                                    }
                                });
                            }
                        } else {
                            stripe.createSource(idealBank, sourceData).then(function (result) {
                                if (result.error) {
                                    // Inform the customer that there was an error.
                                    jQuery('.wp-travel-form-field.button-field').find('.wt-icon.wt-icon-spinner').remove();
                                    var errorElement = document.getElementById('stripe-ideal-errors');
                                    errorElement.textContent = 'Error: ' + result.error.message;
                                    submitBtn.disabled = false;
                                } else {
                                    // Redirect the customer to the authorization URL.
                                    complete(result.source);
                                }
                            });
                        }
                    });
                });
            }
        }

        var complete = function (response) {
            var form_id = 'wp-travel-booking'; // Default payment form id
            submitBtn.disabled = false;
            var payment_form_id = jQuery('#wp-travel-payment-form-id').val();

            if (payment_form_id) {
                form_id = payment_form_id;
            }
            jQuery('.loader-active').show();
            stripe_remove();
            setTimeout(function () {
                jQuery('[name=payment_details]').remove();
                jQuery('form#' + form_id).append(jQuery("<input type='hidden' name='payment_details' />").attr("value", JSON.stringify(response)));
                jQuery('form#' + form_id).find("[type=submit]").click();
            }, 2);
        };

        // Remove Event Listeners.
        var stripe_remove = function () {
            jQuery('[name=wp_travel_book_now]').off('click', stripe_trigger);
            jQuery('[name=complete_partial_payment]').off('click', stripe_trigger);
        }
        /**
         * Removes Event Listeners if previously attached.
         * Checks the selected payment gateway and adds click event listeners to the pay button if needed.
         */
        var stripe_checkout = function () {
            stripe_remove(); //  Removes Event Listeners from BOOK Now Button.
            var payment_gateway = jQuery('input[name=wp_travel_payment_gateway]:checked').val()
            var booking_option = jQuery('[name=wp_travel_booking_option]').val();

            if ('stripe_ideal' === payment_gateway ) {
                $('.payment-ideal-field').show();
                idealBank.mount('#stripeIdealElement');
                jQuery("#wp-travel-book-now, #wp-travel-complete-partial-payment").show().siblings().hide();
                jQuery(".paypal-button").remove();
                jQuery('[name=wp_travel_book_now], [name=complete_partial_payment]').click(stripe_trigger);
            } else {
                $('.payment-ideal-field').hide();
                idealBank.unmount();
            }
        }

        init();
    }
    wp_travel.payment.stripe_ideal_publishable_key.length > 0 && stripeIdealInit()
})