<?php
/**
 * Functions.
 *
 * @package wp-travel-stripe-ideal-core/
 */

// Functions.
/**
 * @param array $gateways Gateways Array.
 *
 * @return mixed
 */
function wp_travel_stripe_ideal_gateway( $gateways ) {
	if ( ! $gateways ) {
		return;
	}
	$gateways['stripe_ideal'] = __( 'Stripe iDEAL Checkout', 'wp-travel-pro' );
	return $gateways;
}

/**
 * Adds this plugin to Addons List.
 *
 * @param array $addons Addons Array.
 *
 * @return array Array.
 */
function wp_travel_stripe_ideal_addons( $addons ) {
	$addons['stripe_ideal'] = __( 'Stripe iDEAL Checkout', 'wp-travel-pro' );
	return $addons;
}

/**
 * Localization.
 *
 * @param array  $args Arguments.
 * @param [type] $settings Array.
 *
 * @return array Arguments.
 */
function wp_travel_stripe_ideal_add_vars( $args, $settings ) {
	if ( ! $args ) {
		return;
	}
	$publishable_key = isset( $settings['stripe_ideal_publishable_key'] ) ? $settings['stripe_ideal_publishable_key'] : '';
	if ( function_exists( 'wptravel_test_mode' ) ) {
		$test_mode = wptravel_test_mode();
	} else {
		$test_mode = wp_travel_test_mode();
	}
	
	if ( $test_mode ) {
		$publishable_key = isset( $settings['stripe_ideal_test_publishable_key'] ) ? $settings['stripe_ideal_test_publishable_key'] : '';
	}
	$thankyou_page_url                               = wptravel_thankyou_page_url();
	$thankyou_page_url                               = add_query_arg( 'booked', true, $thankyou_page_url );
	$args['payment']['thankyouurl']                  = $thankyou_page_url;
	$args['payment']['stripe_ideal_publishable_key'] = $publishable_key;
	return $args;
}
