<?php
class WP_Travel_Tour_Extras_Ajax {

	public function __construct() {

		// Delete cart item
		add_action( 'wp_ajax_wt_extras_remove_from_cart', array( $this, 'wp_travel_extras_remove_from_cart' ) );
		add_action( 'wp_ajax_nopriv_wt_extras_remove_from_cart', array( $this, 'wp_travel_extras_remove_from_cart' ) );

	}

	function wp_travel_extras_remove_from_cart() {
		if ( ! isset( $_POST['cart_id'] ) ) {
			return;
		}
		if ( ! isset( $_POST['extra_itm_id'] ) ) {
			return;
		}
		global $wt_cart;
		$crt_items = $wt_cart->getItems();

		if ( isset( $crt_items[ $_POST['cart_id'] ] ) && isset( $crt_items[ $_POST['cart_id'] ]['trip_extras'] ) ) {
			$trip_id    = $crt_items[ $_POST['cart_id'] ]['trip_id'];
			$price_key  = $crt_items[ $_POST['cart_id'] ]['price_key'];
			$pax        = $crt_items[ $_POST['cart_id'] ]['pax'];
			$trip_price = $crt_items[ $_POST['cart_id'] ]['trip_price'];

			$attrs                 = wptravel_get_cart_attrs( $trip_id, $pax, $price_key );
			$attrs['arrival_date'] = isset( $crt_items[ $_POST['cart_id'] ]['arrival_date'] ) ? $crt_items[ $_POST['cart_id'] ]['arrival_date'] : '';

			$trip_extras = (array) $crt_items[ $_POST['cart_id'] ]['trip_extras'];

			foreach ( $trip_extras['id'] as $key => $val ) {

				if ( $val === $_POST['extra_itm_id'] ) {
					unset( $trip_extras['id'][ $key ] );
					unset( $trip_extras['qty'][ $key ] );
				}
			}
			if ( empty( $trip_extras['id'] ) ) {
				$trip_extras = array();
			}
			$attrs['trip_extras'] = $trip_extras;

			$add_to_cart_args = array(
				'trip_id'            => $trip_id,
				'trip_price'         => $trip_price,
				'trip_price_partial' => 0,
				'pax'                => $pax,
				'price_key'          => $price_key,
				'attrs'              => $attrs,
			);
			$wt_cart->add( $add_to_cart_args );
		}

		return true;
	}


}
new WP_Travel_Tour_Extras_Ajax();
