<?php

function wp_travel_tour_extras_enable_partial( $trip_id, $price_key = null ) {
	if ( ! $trip_id ) {
		return;
	}

	// Return if partial is disabled.
	if ( ! wptravel_is_partial_payment_enabled() ) {
		return;
	}

	// partial as per pricing option.
	$pricing_option = get_post_meta( $trip_id, 'wp_travel_pricing_option_type', true );

	if ( 'single-price' === $pricing_option ) {
		$partial = get_post_meta( $trip_id, 'wp_travel_tour_extras_partial', true );
		return $partial;
	} elseif ( 'multiple-price' === $pricing_option ) {
		// Get Pricing variations.
		$pricing_variations = get_post_meta( $trip_id, 'wp_travel_pricing_options', true );

		$array_cols = array_column( $pricing_variations, 'price_key' );

		// to preserve keys.
		$array_cols = array_combine( array_keys( $pricing_variations ), array_column( $pricing_variations, 'price_key' ) );

		$pricing_option_key = array_search( $price_key, $array_cols, true );

		if ( false !== $pricing_option_key ) {
			return isset( $pricing_variations[ $pricing_option_key ]['tour_extras_partial'] ) ? $pricing_variations[ $pricing_option_key ]['tour_extras_partial'] : false;
		}
	}
	return; // return other than single and multiple pricing. [ i.e. custom booking ].

}

/**
 * Returns the formated price with currency symbols and price.
 *
 * @since 1.1.4
 * @param  int    $price
 * @return string $formated_price
 */
function wp_travel_tour_extras_formated_price( $price ) {
	if ( function_exists( 'wptravel_get_currency_symbol' ) ) {
		$currency_symbol = wptravel_get_currency_symbol();
	} else {
		$currency_symbol = wp_travel_get_currency_symbol();
	}
	$formated_price  = ! empty( $currency_symbol ) && ! empty( $price ) ? $currency_symbol . ' ' . wptravel_get_formated_price( $price ) : '';
	return $formated_price;
}
