<?php 
/**
 * Return template.
 *
 * @param  String $template_name Path of template.
 * @param  array  $args arguments.
 * @return Mixed
 */
function wp_travel_tour_extras_get_template( $template_name, $args = array() ) {
	$template_path = apply_filters( 'wp_travel_tour_extras_template_path',  'wp-travel-tour-extras/' );
	$default_path = sprintf( '%s/templates/', plugin_dir_path( dirname( __FILE__ ) ) );

	// Look templates in theme first.
	$template = locate_template(
		array(
			trailingslashit( $template_path ) . $template_name,
			$template_name,
		)
	);
	if ( ! $template ) {
		$template = $default_path . $template_name;
    }
	if ( file_exists( $template ) ) {
		return $template;
	}
	return false;
}