<?php
/**
 * Itinerary Archive Template
 *
 * This template can be overridden by copying it to yourtheme/wp-travel-tour-extras/single-extra.php.
 *
 * HOWEVER, on occasion wp-travel will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.wensolutions.com/document/template-structure/
 * @author      WenSolutions
 * @package     wp-travel-tour-extras/Templates
 * @since       1.0.0
 */

 global $post;
 if ( ! $post )
	 return;
 
 $post_id = $post->ID;
 $gallery_ids = get_post_meta( $post_id, 'wp_travel_extras_gallery_ids', true );
 $trip_extras_data = get_post_meta( $post_id, 'wp_travel_tour_extras_metas', true );
 
 $description      = isset( $trip_extras_data['extras_item_description'] ) && ! empty( $trip_extras_data['extras_item_description'] ) ? $trip_extras_data['extras_item_description'] : false;
 $price            = isset( $trip_extras_data['extras_item_price'] ) && ! empty( $trip_extras_data['extras_item_price'] ) ? $trip_extras_data['extras_item_price'] : false;
 $sale_price       = isset( $trip_extras_data['extras_item_sale_price'] ) && ! empty( $trip_extras_data['extras_item_sale_price'] ) ? $trip_extras_data['extras_item_sale_price'] : false;
 $item_is_required = isset( $trip_extras_data['extras_is_required'] ) && ! empty( $trip_extras_data['extras_is_required'] ) ? $trip_extras_data['extras_is_required'] : ''; // @since 1.1.2
 $unit             = isset( $trip_extras_data['extras_item_unit'] ) && ! empty( $trip_extras_data['extras_item_unit'] ) ? $trip_extras_data['extras_item_unit'] : false;
 
 
 // Multiple Currency Support.
 $price      = apply_filters( 'wp_travel_multiple_currency', $price );
 $sale_price = apply_filters( 'wp_travel_multiple_currency', $sale_price );
 
 $required_text = ! empty( $item_is_required ) ? __( '*Item Required', 'wp-travel-pro' ) : '';

if( !wp_is_block_theme() ){

get_header( 'extras' );
?>
<div class="wp-tour-extras-detail row wp-tour-extras-detail_content">
	<div>

			<?php if ( ! empty( $gallery_ids ) && is_array( $gallery_ids ) ) : ?>
				<div class="wp-tour-extras-detail-slider-wrap">
					<div class="wp-tour-extras-detail-slider">
						<?php
						if ( has_post_thumbnail( $post_id ) ) :
							$thumb_id = get_post_thumbnail_id( $post_id );
							$img_url_large = wp_get_attachment_image_url( $thumb_id, 'large' );
					
						?>
							<div><figure class="wp-tour-extras-detail-thumb"><a href="<?php echo esc_url( $img_url_large ); ?>"><img src="<?php echo esc_url( get_the_post_thumbnail_url( $post_id ) ); ?>" alt="<?php echo esc_html( get_the_title( $post_id ) ); ?>"></a></figure></div>
						<?php endif; ?>

						<?php foreach( $gallery_ids as $key => $id ) :
						$img_url = wp_get_attachment_image_url( $id );
						$img_url_large = wp_get_attachment_image_url( $id, 'large' );
						?>
							<div><figure class="wp-tour-extras-detail-thumb"><a href="<?php echo esc_url( $img_url_large ); ?>"><img src="<?php echo esc_url( $img_url_large ); ?>" alt=""></a></figure></div>

						<?php endforeach; ?>


					</div>
					<div class="wp-tour-extras-detail-slider-nav">

						<?php if ( has_post_thumbnail( $post_id ) ) : ?>
							<div><figure class="wp-tour-extras-detail-thumb"><img src="<?php echo esc_url( get_the_post_thumbnail_url( $post_id, 'medium' ) ); ?>" alt="<?php echo esc_html( get_the_title( $post_id ) ); ?>"></figure></div>
						<?php endif; ?>

						<?php foreach( $gallery_ids as $key => $id ) :
						$img_url = wp_get_attachment_image_url( $id, 'medium' );
						?>
							<div><figure class="wp-tour-extras-detail-thumb"><img src="<?php echo esc_url( $img_url ); ?>" alt=""></figure></div>

						<?php endforeach; ?>
					</div>
				</div>
			<?php else : ?>
				<?php if( has_post_thumbnail( $post_id ) ) : ?>
					<figure class="wp-tour-extras-detail-thumb"><a href="<?php echo esc_url( get_the_post_thumbnail_url( $post_id ) ); ?>"><img src="<?php echo esc_url( get_the_post_thumbnail_url( $post_id ) ); ?>" alt=""></a></figure>
				<?php endif; ?>
			<?php endif; ?>
		</div>

		<div >
			<div class="wp-tour-extras-detail-heading">
				<!-- <div class="wp-tour-extras-item-required-text"><?php echo esc_html( $required_text ); ?></div> -->
				<h2><?php echo esc_html( get_the_title( $post_id ) ); ?></h2>
				<?php if ( $description ) : ?>
					<?php echo wp_kses_post( wpautop( $description ) ); ?>
				<?php endif; ?>
			</div>
			<div class="wp-tour-extras-detail-pricing">
				<?php if( $price || $sale_price ) : ?>
					<p><?php esc_html_e( 'Price:', 'wp-travel-pro' ); ?>
					<?php if( $sale_price ) : ?>
						<del>
							<?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $price ) ); ?>
						</del>
						<ins>
							<?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $sale_price ) ); ?> / <?php echo esc_html( $unit ); ?>
						</ins>
					<?php else : ?>
						<ins> 
							<?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $price ) ); ?> / <?php echo esc_html( $unit ); ?>
						</ins>
					<?php endif; ?>
					</p>
				<?php endif; ?>
			</div>
			<div class="wp-tour-extras-detail-desc">
				<p><?php echo wp_kses_post( apply_filters('the_content', get_post_field('post_content', $post_id)) ); ?></p>
			</div>
		</div>

	</div>
</div>

<?php
get_footer( 'extras' );
}else{
 ?>
	<!DOCTYPE html>
	<html <?php language_attributes(); ?>>
		<head>
			<meta charset="<?php bloginfo('charset'); ?>">
			<meta name="viewport" content="width=device-width, initial-scale=1.0">
			<?php
			$title = get_the_title();
			$site_name = get_bloginfo('name');
			$page_title = $title . ' - ' . $site_name;
			?>
			<title><?php echo esc_html( $page_title ); ?></title>
			<?php
			/*
			You have to run the do_blocks() between the <head></head> tags in order
			for WordPress to load the corresponding CSS.
			*/
			ob_start();
			block_header_area();
			$str = ob_get_clean();
			$block_header = do_blocks($str);
			// Spacer block.
			$str = '<div 
						style="height:32px" 
						aria-hidden="true" 
						class="wp-block-spacer"
					></div>';
			$block_spacer = do_blocks($str);
			// Content block.
			$block_content = do_blocks(
				'<!-- wp:group {"layout":{"type":"constrained"}} -->
				<div class="wp-block-group">
				<!-- wp:post-content /-->
				</div>
				<!-- /wp:group -->'
			);
			ob_start();
			block_footer_area();
			$str = ob_get_clean();
			$block_footer = do_blocks($str);
			wp_head();
			?>
		</head>
		<body <?php body_class('block-theme-active'); ?>>
			<?php wp_body_open(); ?>
			<div class="wp-site-blocks">
				<header class="wp-block-template-part">
					<?php echo wp_kses_post( $block_header ); ?>
				</header>
				<main class="wptravel-content-wrapper is-layout-constrained" style="padding: 40px 20px 80px 20px;">
					<div class="wp-block-group alignwide">
					<div class="wp-tour-extras-detail">
						<div class="row wp-tour-extras-detail_content">
							<div>
								<?php if ( ! empty( $gallery_ids ) && is_array( $gallery_ids ) ) : ?>
									<div class="wp-tour-extras-detail-slider-wrap">
										<div class="wp-tour-extras-detail-slider">
											<?php
											if ( has_post_thumbnail( $post_id ) ) :
												$thumb_id = get_post_thumbnail_id( $post_id );
												$img_url_large = wp_get_attachment_image_url( $id, 'large' );

											?>
												<div><figure class="wp-tour-extras-detail-thumb"><a href="<?php echo esc_url( $img_url_large ); ?>"><img src="<?php echo esc_url( get_the_post_thumbnail_url( $post_id ) ); ?>" alt="<?php echo esc_html( get_the_title( $post_id ) ); ?>"></a></figure></div>
											<?php endif; ?>

											<?php foreach( $gallery_ids as $key => $id ) :
											$img_url = wp_get_attachment_image_url( $id );
											$img_url_large = wp_get_attachment_image_url( $id, 'large' );
											?>
												<div><figure class="wp-tour-extras-detail-thumb"><a href="<?php echo esc_url( $img_url_large ); ?>"><img src="<?php echo esc_url( $img_url ); ?>" alt=""></a></figure></div>

											<?php endforeach; ?>


										</div>
										<div class="wp-tour-extras-detail-slider-nav">

											<?php if ( has_post_thumbnail( $post_id ) ) : ?>
												<div><figure class="wp-tour-extras-detail-thumb"><img src="<?php echo esc_url( get_the_post_thumbnail_url( $post_id ) ); ?>" alt="<?php echo esc_html( get_the_title( $post_id ) ); ?>"></figure></div>
											<?php endif; ?>

											<?php foreach( $gallery_ids as $key => $id ) :
											$img_url = wp_get_attachment_image_url( $id );
											?>
												<div><figure class="wp-tour-extras-detail-thumb"><img src="<?php echo esc_url( $img_url ); ?>" alt=""></figure></div>

											<?php endforeach; ?>
										</div>
									</div>
								<?php else : ?>
									<?php if( has_post_thumbnail( $post_id ) ) : ?>
										<figure class="wp-tour-extras-detail-thumb"><a href="<?php echo esc_url( get_the_post_thumbnail_url( $post_id ) ); ?>"><img src="<?php echo esc_url( get_the_post_thumbnail_url( $post_id ) ); ?>" alt=""></a></figure>
									<?php endif; ?>
								<?php endif; ?>
							</div>

							<div >
								<div class="wp-tour-extras-detail-heading">
									<div class="wp-tour-extras-item-required-text"><?php echo esc_html( $required_text ); ?></div>
									<h2><?php echo esc_html( get_the_title( $post_id ) ); ?></h2>
									<?php if ( $description ) : ?>
										<?php echo wp_kses_post( wpautop( $description ) ); ?>
									<?php endif; ?>
								</div>
								<div class="wp-tour-extras-detail-pricing">
									<?php if( $price || $sale_price ) : ?>
										<p><?php esc_html_e( 'Price:', 'wp-travel-pro' ); ?>
										<?php if( $sale_price ) : ?>
											<del>
												<?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $price ) ); ?>
											</del>
											<ins>
												<?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $sale_price ) ); ?> / <?php echo esc_html( $unit ); ?>
											</ins>
										<?php else : ?>
											<ins> 
												<?php echo wp_kses_post( wp_travel_tour_extras_formated_price( $price ) ); ?> / <?php echo esc_html( $unit ); ?>
											</ins>
										<?php endif; ?>
										</p>
									<?php endif; ?>
								</div>
								<div class="wp-tour-extras-detail-desc">
									<p><?php echo wp_kses_post( apply_filters('the_content', get_post_field('post_content', $post_id)) ); ?></p>
								</div>
							</div>

						</div>
					</div>
					</div>
				</main>
				<footer class="wp-block-template-part site-footer">
					<?php echo wp_kses_post( $block_footer ); ?>
				</footer>
			</div>
			<?php wp_footer(); ?>
		</body>
	<?php
}